/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input prefixes
 */

#include <cannonical.h>
#include <error.h> /* for assert */
#include <tar/input/filter/prefix.h>


tar_input_filter_prefix::~tar_input_filter_prefix()
{
}


tar_input_filter_prefix::tar_input_filter_prefix(tar_input *arg_fp,
	const rcstring &arg_prefix) :
    tar_input_filter(arg_fp),
    prefix(arg_prefix)
{
}


static rcstring
apply_prefix(const rcstring &prefix, const rcstring &name)
{
    return cannonicalize(prefix + "/" + name);
}


int
tar_input_filter_prefix::read_header(tar_header &h)
{
    int ok = tar_input_filter::read_header(h);
    if (ok)
    {
	h.name = apply_prefix(prefix, h.name);
	if (h.type == tar_header::type_link_hard)
    	    h.linkname = apply_prefix(prefix, h.linkname);
    }
    return ok;
}
