/***************************************************************************
 *   Copyright (C) 2006 by Marco Martin   *
 *   notmart@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tastytooltip.h"

#include <qlabel.h>
#include <qtimer.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <qbutton.h>


TastyToolTip::TastyToolTip( QWidget * parent,const char * name, WFlags fl)
  : QWidget(parent, name, fl|WX11BypassWM )
{
  iconName = "kmenu";
  tastyToolTipLayout = new QVBoxLayout( this, 0, 0, "tastyToolTipLayout"); 
  toolTipWidget = new TastyToolTipWidget(this);
  tastyToolTipLayout->addWidget(toolTipWidget);
}


void TastyToolTip::loadIcon( QString icon )
{
  iconName = icon;
  KIconLoader *iconLoader = KGlobal::iconLoader();
  QPixmap btnPixmap(iconLoader->loadIcon(icon, KIcon::Panel, KIcon::SizeHuge));

  if( !btnPixmap.isNull() )
    toolTipWidget->iconPixmap->setPixmap(btnPixmap);
  else
  {
    kdDebug() << "Failed to load custom icon" << endl;
    toolTipWidget->iconPixmap->setPixmap(iconLoader->loadIcon("kmenu", KIcon::Panel, KIcon::SizeHuge));
  }
}

TastyToolTip::~TastyToolTip()
{
}


void TastyToolTip::showTip(const QPoint & point)
{
  move(point);
  QTimer::singleShot(250, this, SLOT(show()));
}

void TastyToolTip::show()
{
  QButton *button  = dynamic_cast<QButton *>(parent());
  if(button && button->hasMouse() && !button->isDown())
    QWidget::show();
}

void TastyToolTip::hideTip( )
{
  QTimer::singleShot(250, this, SLOT(hide()));
}

void TastyToolTip::notify(const QPoint & point )
{
  move(point);
  show();
  QTimer::singleShot(5000, this, SLOT(hide()));
}

void TastyToolTip::setMessage( QString message )
{
  KIconLoader *iconLoader = KGlobal::iconLoader();
  toolTipWidget->MessageLabel->setText(message);

  if( message.length() > 0 )
    toolTipWidget->iconPixmap->setPixmap(iconLoader->loadIcon("messagebox_info", KIcon::Panel, KIcon::SizeHuge));
  else
    loadIcon(iconName);
}

void TastyToolTip::setTitle( QString title )
{
  if( !title.isEmpty() )
    toolTipWidget->appNameLabel->setText( title );
}

