/*
 * Decompiled with CFR 0.152.
 */
package TauIL;

import TauIL.absyn.AbstractSyntaxTree;
import TauIL.interpreter.Interpreter;
import TauIL.lexer.Lexer;
import TauIL.parser.Parser;
import TauIL.util.BadOptException;
import TauIL.util.GetOpt;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class jReduce {
    public static final String DEFAULT_RULE = "numcalls > 1000000 & usecs/call < 2";
    private static boolean debug = false;
    private static boolean print = false;
    private static boolean default_rules = true;
    private static boolean verbose = false;
    private static String rulefile = null;
    private static String outputfile = null;

    public static boolean parseCommandLine(String[] stringArray) {
        try {
            char c;
            GetOpt getOpt = new GetOpt(stringArray, "dpr:o:vh");
            while ((c = getOpt.getopt()) != '\u0000') {
                switch (c) {
                    case 'd': {
                        debug = true;
                        break;
                    }
                    case 'p': {
                        print = true;
                        break;
                    }
                    case 'r': {
                        rulefile = getOpt.optarg();
                        default_rules = false;
                        break;
                    }
                    case 'o': {
                        outputfile = getOpt.optarg();
                        break;
                    }
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        catch (BadOptException badOptException) {
            return false;
        }
        return true;
    }

    public static void usage() {
        System.err.println("usage: jReduce [-hpv] [-r rulefile] [-o outputfile]");
        System.err.println(" -r rulefile   : specify filename of rule file");
        System.err.println(" -p            : print out all functions with their attributes");
        System.err.println(" -v            : verbose mode");
        System.err.println(" -o outputfile : specify filename of exclude list (defaults to stdout)");
        System.err.println(" -h            : display this usage dialogue");
        System.err.println("\nTauIL v0.2\njReduce v0.3");
        System.err.println("\nWritten by Tyrel Datwyler, 2003");
        System.err.println("Based on the tau_reduce utility written by Nick Trebon, 2002");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        if (!jReduce.parseCommandLine(stringArray)) {
            jReduce.usage();
        }
        try {
            Lexer lexer;
            Object object;
            if (verbose) {
                if (default_rules) {
                    System.out.println("Applying default rule : numcalls > 1000000 & usecs/call < 2");
                } else {
                    System.out.println("Applying rule file : " + rulefile);
                }
            }
            if (rulefile != null) {
                object = new FileInputStream(rulefile);
                lexer = new Lexer((InputStream)object);
            } else {
                object = new StringReader(DEFAULT_RULE);
                lexer = new Lexer((Reader)object);
            }
            object = new Parser(lexer);
            if (verbose) {
                System.out.println("Parsing rules...");
            }
            AbstractSyntaxTree abstractSyntaxTree = debug ? (AbstractSyntaxTree)object.debug_parse().value : (AbstractSyntaxTree)object.parse().value;
            Interpreter interpreter = new Interpreter(abstractSyntaxTree);
            if (debug) {
                interpreter.setDebugMode(true);
            }
            if (verbose) {
                System.out.println("Interpreting intermidiate rule representation...");
            }
            interpreter.interpret();
        }
        catch (Error error) {
            System.err.println("Unhandled error has been thrown.");
            error.printStackTrace();
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println("Unhandled exception has been thrown.");
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

