/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.StaticMainWindowData;
import jRacy.TotalStatWindowPanel;
import jRacy.Trial;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class TotalStatWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private Trial trial = null;
    private TotalStatWindowPanel totalStatWindowPanelRef;
    private StaticMainWindowData sMWData;
    ButtonGroup sortGroup;
    ButtonGroup sortOrderGroup;
    private ButtonGroup metricGroup = null;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    JRadioButtonMenuItem ascendingButton = new JRadioButtonMenuItem("Ascending", false);
    JRadioButtonMenuItem descendingButton = new JRadioButtonMenuItem("Descending", true);
    private JRadioButtonMenuItem nameButton = new JRadioButtonMenuItem("Name", false);
    private JRadioButtonMenuItem inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
    private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
    private JRadioButtonMenuItem numOfCallsRadioButton = new JRadioButtonMenuItem("Number of Calls", false);
    private JRadioButtonMenuItem numOfSubRoutinesRadioButton = new JRadioButtonMenuItem("Number of Subroutines", false);
    private JRadioButtonMenuItem userSecPerCallRadioButton = new JRadioButtonMenuItem("Per Call Value", false);
    private String metric = "Exclusive";
    boolean sortByMappingID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean inclusive = false;
    int server;
    int context;
    int thread;
    Vector FIdDE;
    Vector FIdAE;
    Vector NDE;
    Vector NAE;
    Vector MDE;
    Vector MAE;
    Vector MDI;
    Vector MAI;

    public TotalStatWindow() {
        try {
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW01");
        }
    }

    public TotalStatWindow(Trial trial, int n, int n2, int n3, StaticMainWindowData staticMainWindowData) {
        try {
            this.trial = trial;
            this.sMWData = staticMainWindowData;
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("Total n,c,t, " + n + "," + n2 + "," + n3 + " - " + this.trial.getProfilePathName());
            this.server = n;
            this.context = n2;
            this.thread = n3;
            this.FIdDE = null;
            this.FIdAE = null;
            this.NDE = null;
            this.NAE = null;
            this.MDE = null;
            this.MAE = null;
            this.MDI = null;
            this.MAI = null;
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TotalStatWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the total function statistics window.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you the total statistics for all functions on this thread.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            this.sortGroup = new ButtonGroup();
            this.ascendingButton.addActionListener(this);
            this.descendingButton.addActionListener(this);
            this.sortGroup.add(this.ascendingButton);
            this.sortGroup.add(this.descendingButton);
            JMenu jMenu3 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.nameButton.addActionListener(this);
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton.addActionListener(this);
            this.numOfCallsRadioButton.addActionListener(this);
            this.numOfSubRoutinesRadioButton.addActionListener(this);
            this.userSecPerCallRadioButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            this.sortOrderGroup.add(this.nameButton);
            this.sortOrderGroup.add(this.inclusiveRadioButton);
            this.sortOrderGroup.add(this.exclusiveRadioButton);
            this.sortOrderGroup.add(this.numOfCallsRadioButton);
            this.sortOrderGroup.add(this.numOfSubRoutinesRadioButton);
            this.sortOrderGroup.add(this.userSecPerCallRadioButton);
            jMenu3.add(this.ascendingButton);
            jMenu3.add(this.descendingButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.inclusiveRadioButton);
            jMenu3.add(this.exclusiveRadioButton);
            jMenu3.add(this.numOfCallsRadioButton);
            jMenu3.add(this.numOfSubRoutinesRadioButton);
            jMenu3.add(this.userSecPerCallRadioButton);
            jMenu3.insertSeparator(2);
            jMenu2.add(jMenu3);
            JMenuItem jMenuItem3 = new JMenuItem("Adjust Racy Colors");
            jMenuItem3.addActionListener(this);
            jMenu2.add(jMenuItem3);
            JMenu jMenu4 = new JMenu("Windows");
            jMenu4.addMenuListener(this);
            JMenuItem jMenuItem4 = new JMenuItem("Show Function Ledger");
            jMenuItem4.addActionListener(this);
            jMenu4.add(jMenuItem4);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu4.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu4.add(this.userEventLedgerItem);
            JMenuItem jMenuItem5 = new JMenuItem("Close All Sub-Windows");
            jMenuItem5.addActionListener(this);
            jMenu4.add(jMenuItem5);
            JMenu jMenu5 = new JMenu("Help");
            JMenuItem jMenuItem6 = new JMenuItem("About Racy");
            jMenuItem6.addActionListener(this);
            jMenu5.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Show Help Window");
            jMenuItem7.addActionListener(this);
            jMenu5.add(jMenuItem7);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu5);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.totalStatWindowPanelRef = new TotalStatWindowPanel(this.trial, n, n2, n3, this);
            JScrollPane jScrollPane = new JScrollPane(this.totalStatWindowPanelRef);
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            jScrollBar.setUnitIncrement(35);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Adjust Racy Colors")) {
                    this.trial.getColorChooser().showColorChooser();
                } else if (string.equals("Name")) {
                    if (this.nameButton.isSelected()) {
                        this.metric = "Name";
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.metric = "Inclusive";
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.metric = "Exclusive";
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Number of Calls")) {
                    if (this.numOfCallsRadioButton.isSelected()) {
                        this.metric = "Number of Calls";
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Number of Subroutines")) {
                    if (this.numOfSubRoutinesRadioButton.isSelected()) {
                        this.metric = "Number of Subroutines";
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Per Call Value")) {
                    if (this.userSecPerCallRadioButton.isSelected()) {
                        this.metric = "Per Call Value";
                        this.totalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the total function statistics window.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you the total statistics for all functions on this thread.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for the function, or to show more details about the function.");
                    jRacy.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW03");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.mappingGroupLedgerItem.setEnabled(true);
            } else {
                this.mappingGroupLedgerItem.setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.userEventLedgerItem.setEnabled(true);
            } else {
                this.userEventLedgerItem.setEnabled(false);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW03");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.totalStatWindowPanelRef.repaint();
            }
            if (string.equals("colorEvent")) {
                this.totalStatWindowPanelRef.repaint();
            } else if (string.equals("dataEvent")) {
                this.totalStatWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW04");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.metric.equals("Name")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NDE");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "NAE");
            }
            if (this.metric.equals("Inclusive")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDI");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAI");
            }
            if (this.metric.equals("Exclusive")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDE");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAE");
            }
            if (this.metric.equals("Number of Calls")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDNC");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MANC");
            }
            if (this.metric.equals("Number of Subroutines")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDNS");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MANS");
            }
            if (this.metric.equals("Per Call Value")) {
                if (this.descendingOrder) {
                    return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MDUS");
                }
                return this.sMWData.getSMWThreadData(this.server, this.context, this.thread, "MAUS");
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW06");
        }
        return null;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A total stat window for: \"n,c,t, " + this.server + "," + this.context + "," + this.thread + "\" is closing");
                System.out.println("Clearing resourses for this window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSW07");
        }
    }
}

