/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.Application;
import jRacy.ApplicationType;
import jRacy.ConnectionManager;
import jRacy.Experiment;
import jRacy.JRacyTableModel;
import jRacy.JRacyTreeCellRenderer;
import jRacy.Trial;
import jRacy.Value;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.ResultSet;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class jRacyManager
extends JFrame
implements ActionListener {
    JTree tree = null;
    DefaultTreeModel treeModel = null;
    DefaultMutableTreeNode dbApps = null;
    JSplitPane innerPane = null;
    JSplitPane innerPane2 = null;
    JSplitPane outerPane = null;
    DefaultMutableTreeNode defaultTrialNode = null;
    private DefaultListModel experimentsModel;
    private DefaultListModel runsModel;
    private DefaultListModel valuesModel;
    private JList experimentsList;
    private JList runsList;
    private JList valuesList;
    private JButton connectDisconnectButton = null;
    private JButton refreshButton = null;
    private JButton refreshExpButton = null;
    private JTextField serverField = null;
    private JTextField usernameField = null;
    private JPasswordField passwordField = null;
    private JComboBox operation = null;
    private JTextField opA = null;
    private JTextField opB = null;
    private Border loweredbev = null;
    private Border raisedbev = null;
    private Border empty = null;

    public jRacyManager() {
        try {
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("jRacy Manager");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jRacyManager.this.thisWindowClosing(windowEvent);
                }
            });
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("jRacy Manager");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit jRacy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Help");
            JMenuItem jMenuItem3 = new JMenuItem("About Racy");
            jMenuItem3.addActionListener(this);
            jMenu2.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Show Help Window");
            jMenuItem4.addActionListener(this);
            jMenu2.add(jMenuItem4);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            this.setJMenuBar(jMenuBar);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            this.loweredbev = BorderFactory.createLoweredBevelBorder();
            this.raisedbev = BorderFactory.createRaisedBevelBorder();
            this.empty = BorderFactory.createEmptyBorder();
            this.connectDisconnectButton = new JButton("Connect to Database");
            this.connectDisconnectButton.setFont(new Font("Times-Roman", 0, 12));
            this.refreshButton = new JButton("Reload");
            this.refreshButton.setFont(new Font("Times-Roman", 0, 12));
            this.refreshExpButton = new JButton("Reload Experiment");
            this.refreshExpButton.setFont(new Font("Times-Roman", 0, 12));
            this.serverField = new JTextField("Please enter server address", 30);
            this.usernameField = new JTextField("Username", 30);
            this.passwordField = new JPasswordField("Password", 30);
            String[] stringArray = new String[]{"Add", "Subtract", "Multiply", "Divide"};
            this.operation = new JComboBox<String>(stringArray);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Applications");
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ApplicationType("Standard Applications"));
            this.populateStandardApplications(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ApplicationType("Runtime Applications"));
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            this.dbApps = new DefaultMutableTreeNode(new ApplicationType("DB Applications"));
            defaultMutableTreeNode.add(this.dbApps);
            this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.treeModel.setAsksAllowsChildren(true);
            this.tree = new JTree(this.treeModel);
            this.tree.setRootVisible(false);
            this.tree.getSelectionModel().setSelectionMode(1);
            JRacyTreeCellRenderer jRacyTreeCellRenderer = new JRacyTreeCellRenderer();
            this.tree.setCellRenderer(jRacyTreeCellRenderer);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    jRacyManager.this.treeSelectionEventHandler(treeSelectionEvent);
                }
            });
            this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    jRacyManager.this.treeCollapsedEventHandler(treeExpansionEvent);
                }

                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    jRacyManager.this.treeExpansionEventHandler(treeExpansionEvent);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            this.innerPane = new JSplitPane(1, jScrollPane, this.getWelcomeUpperRight());
            this.innerPane.setContinuousLayout(true);
            this.innerPane.setOneTouchExpandable(true);
            this.innerPane.setDividerLocation(0.5);
            this.innerPane2 = new JSplitPane(1, jPanel2, this.getApplyOperationComponent());
            this.innerPane2.setContinuousLayout(true);
            this.innerPane2.setOneTouchExpandable(true);
            this.innerPane2.setDividerLocation(0.5);
            this.outerPane = new JSplitPane(0, this.innerPane, this.innerPane2);
            this.outerPane.setContinuousLayout(true);
            this.outerPane.setOneTouchExpandable(true);
            this.getContentPane().add((Component)this.outerPane, "Center");
            this.connectDisconnectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jRacyManager.this.connectDisconnectButtonFunction();
                }
            });
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jRacyManager.this.refreshButton();
                }
            });
            this.refreshExpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jRacyManager.this.refreshExperimentsButton();
                }
            });
            this.show();
            this.innerPane.setDividerLocation(0.5);
            this.innerPane2.setDividerLocation(0.5);
            this.outerPane.setDividerLocation(0.667);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            jRacy.systemError(exception, null, "jRM01");
        }
    }

    private void treeSelectionEventHandler(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isRoot()) {
            this.innerPane.setRightComponent(this.getRootUpperRight());
            this.innerPane2.setLeftComponent(new JPanel());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        } else if (object instanceof ApplicationType) {
            String string = object.toString();
            if (defaultMutableTreeNode2 != null) {
                if (string.equals("Standard Applications")) {
                    this.innerPane.setRightComponent(this.getSAppUpperRight());
                    this.innerPane2.setLeftComponent(this.getAppTypeNodeLowerLeft());
                    this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
                    this.tree.expandPath(treePath);
                } else if (string.equals("Runtime Applications")) {
                    this.innerPane.setRightComponent(this.getRAppUpperRight());
                    this.innerPane2.setLeftComponent(this.getAppTypeNodeLowerLeft());
                    this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
                } else {
                    this.innerPane.setRightComponent(this.getDBAppUpperRight());
                    this.innerPane2.setLeftComponent(this.getDBAppTypeNodeLowerLeft());
                    this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
                }
            }
        } else if (object instanceof Application) {
            this.innerPane.setRightComponent(this.getAppNodeUpperRight((Application)object));
            this.innerPane2.setLeftComponent(this.getBlank());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        } else if (defaultMutableTreeNode2.getUserObject() instanceof Application) {
            this.innerPane.setRightComponent(this.getExpTypeNodeUpperRight());
            this.innerPane2.setLeftComponent(this.getExpTypeNodeLowerLeft());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        } else if (defaultMutableTreeNode2.getUserObject() instanceof Experiment) {
            this.innerPane.setRightComponent(this.getTrialTypeNodeUpperRight());
            this.innerPane2.setLeftComponent(this.getTrialTypeNodeLowerLeft());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        } else if (object instanceof Experiment) {
            this.innerPane.setRightComponent(this.getExpNodeUpperRight());
            this.innerPane2.setLeftComponent(this.getBlank());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        } else if (object instanceof Trial) {
            this.tree.expandPath(treePath);
            String string = object.toString();
            this.innerPane.setRightComponent(this.getTrialNodeUpperRight());
            this.innerPane2.setLeftComponent(this.getBlank());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        } else if (object instanceof Value) {
            this.innerPane.setRightComponent(this.getValueUpperRight());
            Object object2 = defaultMutableTreeNode2.getUserObject();
            if (object2 instanceof Trial) {
                this.showValue((Trial)object2, (Value)object);
            } else {
                jRacy.systemError(null, null, "jRM02 - Logic Error");
            }
            this.innerPane2.setLeftComponent(this.getBlank());
            this.setJSPDividers(this.innerPane, this.innerPane2, 0.5, 0.5);
        }
    }

    private void treeExpansionEventHandler(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        System.out.println(treePath);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if ((object instanceof Application || object instanceof Experiment) && defaultMutableTreeNode.getChildCount() > 0) {
            this.tree.expandPath(treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(0)));
        }
    }

    private void treeCollapsedEventHandler(TreeExpansionEvent treeExpansionEvent) {
    }

    private Component getWelcomeUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("This window allows you to manage all of jRacy's loaded data.\n");
        jTextArea.append("Data can be static (ie, not updated at runtime), and loaded either remotely or locally.  You can also specify data to be uploaded at runtime.\n\n");
        return new JScrollPane(jTextArea);
    }

    private Component getSAppUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("This is the Standard application section:\n\n");
        jTextArea.append("Standard - The classic jRacy mode.  Data sets that are loaded at startup are placedunder the default application automatically. Please see the jRacy documentation for mre details.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getRAppUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("This is the Runtime application section:\n\n");
        jTextArea.append("Runtime - A new feature allowing jRacy to update data at runtime.  Please see the jRacy documentation if the options are not clear.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getDBAppUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("This is the DB Apps application section:\n\n");
        jTextArea.append("DB Apps - Another new feature allowing jRacy to load data from a database.  Again, please see the jRacy documentation if the options are not clear.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getExpTypeNodeUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("The button in the lower left allows you to add an experiment. Other features will be added here soon.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getTrialTypeNodeUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("The buttons in the lower left allow you to add trials to this experiment.  You can either add a trial with a single counter (top button) or you can select to add a trial with multiple counters\n (bottom button).  You will be prompted for a name for the trial, and then you can select either a \n pprof dump file, or a directory, depending on which button you clicked on.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getExpNodeUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("If this node is not expanded, you may double click on it to see the trials in this experiment.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getTrialNodeUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("If this node is not expanded, you may double click on it to see the values in this trial.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getAppTypeNodeLowerLeft() {
        JButton jButton = null;
        JPanel jPanel = new JPanel();
        jButton = new JButton("Add Application");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.newApplicationButton();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private Component getExpTypeNodeLowerLeft() {
        JButton jButton = null;
        JPanel jPanel = new JPanel();
        jButton = new JButton("Add Experiment");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.addExperimentButtonFunction();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private Component getTrialTypeNodeLowerLeft() {
        JButton jButton = null;
        JPanel jPanel = new JPanel();
        jButton = new JButton("Add Single Valued Trail");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.addTrialSVTButtonFunction();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Add Multiple Valued Trail");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.addTrialMVTButtonFunction();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private Component getDBAppTypeNodeLowerLeft() {
        JButton jButton = null;
        JPanel jPanel = new JPanel();
        jButton = new JButton("Add Application");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.newApplicationButton();
            }
        });
        JLabel jLabel = new JLabel("Server Address:");
        JLabel jLabel2 = new JLabel("Password:");
        JLabel jLabel3 = new JLabel("Username:");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.serverField, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.usernameField, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel3, gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.passwordField, gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.connectDisconnectButton, gridBagConstraints, 0, 4, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.refreshButton, gridBagConstraints, 1, 4, 1, 1);
        return jPanel;
    }

    private Component getRootUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("There are three application types:\n\n");
        jTextArea.append("Standard - The classic jRacy mode.  At present, there is only a \"default\" set which is set for you automatically.  This maintains compatability with older versions where the application set was not definied.  This grouping will be expanded in time. For now, you may add experiments under the default set only.\n\n");
        jTextArea.append("Runtime - A new feature allowing jRacy to update data at runtime.  Please see the jRacy documentation if the options are not clear. As in the Standard set, there is only section.\n\n");
        jTextArea.append("DB Apps - Another new feature allowing jRacy to load data from a database.  Again, please see the jRacy documentation if the options are not clear.\n\n");
        return new JScrollPane(jTextArea);
    }

    private Component getAppNodeUpperRight(Application application) {
        return new JScrollPane(new JTable(new JRacyTableModel(application)));
    }

    private Component getValueUpperRight() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.append("jRacy Manager\n\n");
        jTextArea.append("Clicking on different values causes jRacy to display the clicked on metric.\n\n");
        jTextArea.append("The sub-window below allow you to generate new metrics based on those that were gathered during the run.  The operand number options for Operand A and B correspond the numbers prefixing the values.\n");
        return new JScrollPane(jTextArea);
    }

    private Component getAppNodeLowerLeft(Application application) {
        JButton jButton = null;
        JPanel jPanel = new JPanel();
        jButton = new JButton("Update Application");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.updateApplicationButton();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Add Experiment");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private Component getApplyOperationComponent() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Apply Operation");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRacyManager.this.applyOperationButtonFunction();
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JLabel jLabel = new JLabel("Op A");
        JLabel jLabel2 = new JLabel("Op B:");
        JLabel jLabel3 = new JLabel("Apply operations here!");
        JLabel jLabel4 = new JLabel("Operation");
        this.opA = new JTextField("XXXX - XXXX...            ", 30);
        this.opB = new JTextField("XXXX _ XXXX...            ", 30);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.opA, gridBagConstraints, 1, 1, 2, 1);
        gridBagConstraints.fill = 10;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.opB, gridBagConstraints, 1, 2, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jLabel4, gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, this.operation, gridBagConstraints, 1, 3, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelAdd(jPanel, jButton, gridBagConstraints, 0, 4, 3, 1);
        return jPanel;
    }

    private Component getBlank() {
        return new JPanel();
    }

    private void setJSPDividers(JSplitPane jSplitPane, JSplitPane jSplitPane2, double d, double d2) {
        jSplitPane.setDividerLocation(d);
        jSplitPane2.setDividerLocation(d2);
    }

    void addExperimentButtonFunction() {
        JOptionPane.showMessageDialog(this, "Only the default experiment allowed in this release!", "Warning!", 0);
    }

    void addTrialSVTButtonFunction() {
        block9: {
            try {
                Trial trial = null;
                String string = null;
                String string2 = null;
                String string3 = null;
                TreePath treePath = this.tree.getSelectionPath();
                if (treePath == null) {
                    System.out.println("Error adding trial ... aborted.");
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                if (defaultMutableTreeNode2 == null) {
                    System.out.println("Error adding trial ... aborted.");
                    return;
                }
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof Experiment)) {
                    System.out.println("Error adding trial ... aborted.");
                    return;
                }
                Experiment experiment = (Experiment)object;
                String string4 = JOptionPane.showInputDialog(this, (Object)"Please enter a new trial name, click ok, and then select a pprof dump file!");
                if (string4 == null || "".equals(string4)) {
                    JOptionPane.showMessageDialog(this, "You must enter a name!", "Error!", 0);
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(null);
                int n = jFileChooser.showOpenDialog(this);
                if (n != 0) break block9;
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    string = file.getCanonicalPath();
                    string2 = jRacy.applicationManager.getPathReverse(string);
                    string3 = string4 + " : " + string2;
                    if (experiment.isTrialNamePresent(string3)) {
                        JOptionPane.showMessageDialog(this, "A run already exists with that name!", "Warning!", 0);
                        return;
                    }
                    trial = experiment.addTrial();
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(trial);
                    trial.setDMTN(defaultMutableTreeNode3);
                    trial.setProfilePathName(string);
                    trial.setTrialName(string3);
                    trial.buildStaticData(true, file);
                    Enumeration enumeration = trial.getValues().elements();
                    while (enumeration.hasMoreElements()) {
                        Value value = (Value)enumeration.nextElement();
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(value);
                        value.setDMTN(defaultMutableTreeNode4);
                        defaultMutableTreeNode4.setAllowsChildren(false);
                        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                    }
                    this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    trial.showStaticMainWindow();
                    break block9;
                }
                System.out.println("There was some sort of internal error!");
                return;
            }
            catch (Exception exception) {
                jRacy.systemError(exception, null, "ELM01");
            }
        }
    }

    void addTrialMVTButtonFunction() {
        block12: {
            try {
                Trial trial = null;
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                String string = null;
                String string2 = null;
                String string3 = null;
                TreePath treePath = this.tree.getSelectionPath();
                if (treePath == null) {
                    System.out.println("Error adding trial ... aborted.");
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (defaultMutableTreeNode3 == null) {
                    System.out.println("Error adding trial ... aborted.");
                    return;
                }
                Object object = defaultMutableTreeNode3.getUserObject();
                if (!(object instanceof Experiment)) {
                    System.out.println("Error adding trial ... aborted.");
                    return;
                }
                Experiment experiment = (Experiment)object;
                String string4 = JOptionPane.showInputDialog(this, (Object)"Please enter a new trial name, click ok, and then select a pprof dump file!");
                if (string4 == null || "".equals(string4)) {
                    JOptionPane.showMessageDialog(this, "You must enter a name!", "Error!", 0);
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setCurrentDirectory(null);
                int n = jFileChooser.showOpenDialog(this);
                if (n != 0) break block12;
                boolean bl = false;
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string5 = file.getCanonicalPath();
                    File[] fileArray = file.listFiles();
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        File file2;
                        object4 = fileArray[n2];
                        if (object4 != null && ((String)(object3 = ((File)object4).getName())).indexOf("MULTI__") != -1 && (file2 = new File((String)(object2 = string5 + "/" + (String)object3 + "/pprof.dat"))).exists()) {
                            if (!bl) {
                                System.out.println("Found pprof.dat ... loading");
                                string = string5;
                                string2 = jRacy.applicationManager.getPathReverse(string);
                                string3 = string4 + " : " + string2;
                                trial = experiment.addTrial();
                                defaultMutableTreeNode = new DefaultMutableTreeNode(trial);
                                trial.setDMTN(defaultMutableTreeNode);
                                trial.setProfilePathName(string);
                                trial.setTrialName(string3);
                                trial.buildStaticData(true, file2);
                                System.out.println("Found: " + (String)object2);
                                bl = true;
                            } else {
                                trial.buildStaticData(false, file2);
                            }
                        }
                        ++n2;
                    }
                    object4 = trial.getValues().elements();
                    while (object4.hasMoreElements()) {
                        object3 = (Value)object4.nextElement();
                        object2 = new DefaultMutableTreeNode(object3);
                        ((Value)object3).setDMTN((DefaultMutableTreeNode)object2);
                        ((DefaultMutableTreeNode)object2).setAllowsChildren(false);
                        defaultMutableTreeNode.add((MutableTreeNode)object2);
                    }
                    this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                    trial.showStaticMainWindow();
                    break block12;
                }
                System.out.println("There was some sort of internal error!");
                return;
            }
            catch (Exception exception) {
                jRacy.systemError(exception, null, "ELM01");
            }
        }
    }

    public void connectDisconnectButtonFunction() {
        if (!jRacy.dbSupport) {
            JOptionPane.showMessageDialog(this, "Sorry, in this release db support is not turned on!", "Warning!", 0);
            return;
        }
        try {
            if (this.connectDisconnectButton.getText().equals("Connect to Database")) {
                String string = this.serverField.getText().trim();
                String string2 = this.usernameField.getText().trim();
                String string3 = new String(this.passwordField.getPassword());
                string3.trim();
                ConnectionManager.connect(string, string2, string3);
                this.connectDisconnectButton.setText("Disconnect from Database");
            } else {
                ConnectionManager.dbclose();
                this.connectDisconnectButton.setText("Connect to Database");
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "ELM03");
        }
    }

    public void refreshButton() {
        if (!jRacy.dbSupport) {
            JOptionPane.showMessageDialog(this, "Sorry, in this release db support is not turned on!", "Warning!", 0);
            return;
        }
        try {
            int n = this.dbApps.getChildCount();
            while (n > 0) {
                this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.dbApps.getChildAt(n - 1));
                --n;
            }
            String string = new String("select * from applications; ");
            ResultSet resultSet = ConnectionManager.getDB().executeQuery(string);
            int n2 = resultSet.getMetaData().getColumnCount();
            boolean bl = false;
            while (resultSet.next()) {
                Application application = new Application();
                application.setDBApplication(true);
                int n3 = 1;
                while (n3 <= n2) {
                    String string2 = resultSet.getString(n3);
                    switch (n3) {
                        case 1: {
                            application.setApplicationID(Integer.parseInt(string2));
                            break;
                        }
                        case 2: {
                            application.setApplicationName(string2);
                            break;
                        }
                        case 3: {
                            application.setVersion(string2);
                            break;
                        }
                        case 4: {
                            application.setDescription(string2);
                            break;
                        }
                        case 5: {
                            application.setLanguage(string2);
                            break;
                        }
                        case 6: {
                            application.setPara_diag(string2);
                            break;
                        }
                        case 7: {
                            application.setUsage(string2);
                            break;
                        }
                        case 8: {
                            application.setExe_opt(string2);
                            break;
                        }
                        default: {
                            System.out.println("Error in application information parsing" + n3);
                        }
                    }
                    ++n3;
                }
                this.treeModel.insertNodeInto(new DefaultMutableTreeNode(application), this.dbApps, this.dbApps.getChildCount());
            }
            resultSet.close();
            return;
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "ELM03");
            return;
        }
    }

    public void refreshExperimentsButton() {
        try {
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Application) {
                int n = ((Application)object).getApplicationID();
                String string = new String("select * from experiments where appID = '" + n + "';");
                ResultSet resultSet = ConnectionManager.getDB().executeQuery(string);
                int n2 = resultSet.getMetaData().getColumnCount();
                int n3 = 0;
                while (resultSet.next()) {
                    Application application = new Application();
                    System.out.println("@@@@@@@@@@@@@Application: " + n3++);
                    int n4 = 1;
                    while (n4 <= 1) {
                        String string2 = resultSet.getString(n4);
                        System.out.println("Experiment: " + string2);
                        ++n4;
                    }
                }
                resultSet.close();
                return;
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "ELM03");
        }
    }

    void applyOperationButtonFunction() {
        try {
            int n = -1;
            int n2 = -1;
            String string = this.opA.getText().trim();
            String string2 = this.opB.getText().trim();
            if (!string.substring(0, 3).equals(string2.substring(0, 3))) {
                JOptionPane.showMessageDialog(this, "Sorry, in this release, please select from the same trial!", "Warning!", 0);
                return;
            }
            n = Character.getNumericValue(string.charAt(0));
            Application application = (Application)jRacy.applicationManager.getApplicationList().elementAt(n);
            n = Character.getNumericValue(string.charAt(1));
            Experiment experiment = (Experiment)application.getExperimentsList().elementAt(n);
            n = Character.getNumericValue(string.charAt(2));
            Trial trial = (Trial)experiment.getTrials().elementAt(n);
            n = Character.getNumericValue(string.charAt(3));
            Value value = (Value)trial.getValues().elementAt(n);
            n2 = Character.getNumericValue(string2.charAt(3));
            Value value2 = (Value)trial.getValues().elementAt(n2);
            string = string.substring(string.indexOf(45) + 2);
            string2 = string2.substring(string2.indexOf(45) + 2);
            String string3 = (String)this.operation.getSelectedItem();
            Value value3 = trial.applyOperation(value.getValueName(), value2.getValueName(), string3);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(value3);
            value3.setDMTN(defaultMutableTreeNode);
            DefaultMutableTreeNode defaultMutableTreeNode2 = trial.getDMTN();
            defaultMutableTreeNode.setAllowsChildren(false);
            this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            trial.getSystemEvents().updateRegisteredObjects("dataEvent");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "ELM03");
        }
    }

    void showValue(Trial trial, Value value) {
        try {
            this.opB.setText(this.opA.getText().trim());
            this.opA.setText(value.toString());
            trial.setCurValLoc(value.getValueID());
            trial.getSystemEvents().updateRegisteredObjects("dataEvent");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "jRM04");
        }
    }

    void populateStandardApplications(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        DefaultMutableTreeNode defaultMutableTreeNode5 = null;
        DefaultMutableTreeNode defaultMutableTreeNode6 = null;
        DefaultMutableTreeNode defaultMutableTreeNode7 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = jRacy.applicationManager.getApplicationList().elements();
        while (enumeration.hasMoreElements()) {
            Application application = (Application)enumeration.nextElement();
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(application);
            application.setDMTN(defaultMutableTreeNode2);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Experiments");
            Enumeration enumeration2 = application.getExperimentsList().elements();
            while (enumeration2.hasMoreElements()) {
                Experiment experiment = (Experiment)enumeration2.nextElement();
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(experiment);
                experiment.setDMTN(defaultMutableTreeNode4);
                defaultMutableTreeNode5 = new DefaultMutableTreeNode("Trials");
                Enumeration enumeration3 = experiment.getTrials().elements();
                while (enumeration3.hasMoreElements()) {
                    Trial trial = (Trial)enumeration3.nextElement();
                    defaultMutableTreeNode6 = new DefaultMutableTreeNode(trial);
                    trial.setDMTN(defaultMutableTreeNode6);
                    Enumeration enumeration4 = trial.getValues().elements();
                    while (enumeration4.hasMoreElements()) {
                        Value value = (Value)enumeration4.nextElement();
                        defaultMutableTreeNode7 = new DefaultMutableTreeNode(value);
                        value.setDMTN(defaultMutableTreeNode7);
                        defaultMutableTreeNode7.setAllowsChildren(false);
                        defaultMutableTreeNode6.add(defaultMutableTreeNode7);
                        ++n4;
                    }
                    defaultMutableTreeNode5.add(defaultMutableTreeNode6);
                    if (n3 == 0) {
                        this.defaultTrialNode = defaultMutableTreeNode6;
                    }
                    ++n3;
                }
                defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                ++n2;
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    public void expandDefaultTrialNode() {
        this.tree.expandPath(new TreePath(this.defaultTrialNode.getPath()));
    }

    public void newApplicationButton() {
        JOptionPane.showMessageDialog(this, "Only the default application allowed in this release!", "Warning!", 0);
    }

    public void updateApplicationButton() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2.isRoot()) {
            String string = object.toString();
            if (string.equals("Standard Applications")) {
                this.treeModel.insertNodeInto(new DefaultMutableTreeNode(jRacy.applicationManager.addApplication()), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            } else if (string.equals("Runtime Applications")) {
                // empty if block
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Exit jRacy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("jRacy Manager")) {
                    if (!jRacy.runHasBeenOpened) {
                        ((Component)this).setVisible(false);
                        this.dispose();
                        System.out.println("Quiting jRacy!");
                        System.exit(0);
                    } else {
                        this.dispose();
                    }
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the experiment manager window.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("You can create an experiment, and then add separate runs,.");
                    jRacy.helpWindow.writeText("which may contain one or more values (gettimeofday, cache misses, etc.");
                    jRacy.helpWindow.writeText("You can also derive new metrics in this window.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Please see jRacy's documentation for more information.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "ELM05");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("Experiment List Manager Window is closing!");
                System.out.println("Clearing resourses for this window.");
            }
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "ELM06");
        }
    }

    private void panelAdd(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }
}

