/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.PerfDMFSession;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.paraprof.Metric;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManager;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;

public class ParaProfManagerTableModel
extends AbstractTableModel {
    private int type = -1;
    private ParaProfApplication application = null;
    private ParaProfExperiment experiment = null;
    private ParaProfTrial trial = null;
    private Metric metric = null;
    private ParaProfManager paraProfManager = null;
    private DefaultTreeModel defaultTreeModel = null;
    String[] columnNames = new String[]{"Field", "Value"};

    public ParaProfManagerTableModel(ParaProfManager paraProfManager, Object object, DefaultTreeModel defaultTreeModel) {
        if (object instanceof ParaProfApplication) {
            this.application = (ParaProfApplication)object;
            this.type = 0;
        } else if (object instanceof ParaProfExperiment) {
            this.experiment = (ParaProfExperiment)object;
            this.type = 1;
        } else if (object instanceof ParaProfTrial) {
            this.trial = (ParaProfTrial)object;
            this.type = 2;
        } else {
            this.metric = (Metric)object;
            this.type = 3;
        }
        this.paraProfManager = paraProfManager;
        this.defaultTreeModel = defaultTreeModel;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        switch (this.type) {
            case 0: {
                return 7;
            }
            case 1: {
                return 27;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        switch (this.type) {
            case 0: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                        case 2: {
                            return "Language";
                        }
                        case 3: {
                            return "Para_diag";
                        }
                        case 4: {
                            return "Usage";
                        }
                        case 5: {
                            return "Executable Options";
                        }
                        case 6: {
                            return "Description";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.application.getName();
                    }
                    case 1: {
                        return new Integer(this.application.getID());
                    }
                    case 2: {
                        return this.application.getLanguage();
                    }
                    case 3: {
                        return this.application.getParaDiag();
                    }
                    case 4: {
                        return this.application.getUsage();
                    }
                    case 5: {
                        return this.application.getExecutableOptions();
                    }
                    case 6: {
                        return this.application.getDescription();
                    }
                }
                return "";
            }
            case 1: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                        case 2: {
                            return "Experiment ID";
                        }
                        case 3: {
                            return "User Data";
                        }
                        case 4: {
                            return "System Name";
                        }
                        case 5: {
                            return "System Machine Type";
                        }
                        case 6: {
                            return "System Arch.";
                        }
                        case 7: {
                            return "System OS";
                        }
                        case 8: {
                            return "System Memory Size";
                        }
                        case 9: {
                            return "System Processor Amount";
                        }
                        case 10: {
                            return "System L1 Cache Size";
                        }
                        case 11: {
                            return "System L2 Cache Size";
                        }
                        case 12: {
                            return "System User Data";
                        }
                        case 13: {
                            return "Configuration Prefix";
                        }
                        case 14: {
                            return "Configuration Architecture";
                        }
                        case 15: {
                            return "Configuration CPP";
                        }
                        case 16: {
                            return "Configuration CC";
                        }
                        case 17: {
                            return "Configuration JDK";
                        }
                        case 18: {
                            return "Configuration Profile";
                        }
                        case 19: {
                            return "Configuration User Data";
                        }
                        case 20: {
                            return "Compiler CPP Name";
                        }
                        case 21: {
                            return "Compiler CPP Version";
                        }
                        case 22: {
                            return "Compiler CC Name";
                        }
                        case 23: {
                            return "Compiler CC Version";
                        }
                        case 24: {
                            return "Compiler Java Dir. Path";
                        }
                        case 25: {
                            return "Compiler Java Version";
                        }
                        case 26: {
                            return "Compiler User Data";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.experiment.getName();
                    }
                    case 1: {
                        return new Integer(this.experiment.getApplicationID());
                    }
                    case 2: {
                        return new Integer(this.experiment.getID());
                    }
                    case 3: {
                        return this.experiment.getUserData();
                    }
                    case 4: {
                        return this.experiment.getSystemName();
                    }
                    case 5: {
                        return this.experiment.getSystemMachineType();
                    }
                    case 6: {
                        return this.experiment.getSystemArch();
                    }
                    case 7: {
                        return this.experiment.getSystemOS();
                    }
                    case 8: {
                        return this.experiment.getSystemMemorySize();
                    }
                    case 9: {
                        return this.experiment.getSystemProcessorAmount();
                    }
                    case 10: {
                        return this.experiment.getSystemL1CacheSize();
                    }
                    case 11: {
                        return this.experiment.getSystemL2CacheSize();
                    }
                    case 12: {
                        return this.experiment.getSystemUserData();
                    }
                    case 13: {
                        return this.experiment.getConfigPrefix();
                    }
                    case 14: {
                        return this.experiment.getConfigArchitecture();
                    }
                    case 15: {
                        return this.experiment.getConfigCpp();
                    }
                    case 16: {
                        return this.experiment.getConfigCc();
                    }
                    case 17: {
                        return this.experiment.getConfigJdk();
                    }
                    case 18: {
                        return this.experiment.getConfigProfile();
                    }
                    case 19: {
                        return this.experiment.getConfigUserData();
                    }
                    case 20: {
                        return this.experiment.getCompilerCppName();
                    }
                    case 21: {
                        return this.experiment.getCompilerCppVersion();
                    }
                    case 22: {
                        return this.experiment.getCompilerCcName();
                    }
                    case 23: {
                        return this.experiment.getCompilerCcVersion();
                    }
                    case 24: {
                        return this.experiment.getCompilerJavaDirpath();
                    }
                    case 25: {
                        return this.experiment.getCompilerJavaVersion();
                    }
                    case 26: {
                        return this.experiment.getCompilerUserData();
                    }
                }
                return "";
            }
            case 2: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                        case 2: {
                            return "Experiment ID";
                        }
                        case 3: {
                            return "Trial ID";
                        }
                        case 4: {
                            return "Time";
                        }
                        case 5: {
                            return "Node Count";
                        }
                        case 6: {
                            return "Contexts Per Node";
                        }
                        case 7: {
                            return "Threads Per Context";
                        }
                        case 8: {
                            return "User Data";
                        }
                        case 9: {
                            return "Problem Definition";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.trial.getName();
                    }
                    case 1: {
                        return new Integer(this.trial.getApplicationID());
                    }
                    case 2: {
                        return new Integer(this.trial.getExperimentID());
                    }
                    case 3: {
                        return new Integer(this.trial.getID());
                    }
                    case 4: {
                        return this.trial.getTime();
                    }
                    case 5: {
                        return new Integer(this.trial.getNodeCount());
                    }
                    case 6: {
                        return new Integer(this.trial.getNumContextsPerNode());
                    }
                    case 7: {
                        return new Integer(this.trial.getNumThreadsPerContext());
                    }
                    case 8: {
                        return this.trial.getUserData();
                    }
                    case 9: {
                        return this.trial.getProblemDefinition();
                    }
                }
                return "";
            }
            case 3: {
                if (n2 == 0) {
                    switch (n) {
                        case 0: {
                            return "Name";
                        }
                        case 1: {
                            return "Application ID";
                        }
                        case 2: {
                            return "Experiment ID";
                        }
                        case 3: {
                            return "Trial ID";
                        }
                        case 4: {
                            return "Metric ID";
                        }
                    }
                    return "";
                }
                switch (n) {
                    case 0: {
                        return this.metric.getName();
                    }
                    case 1: {
                        return new Integer(this.metric.getApplicationID());
                    }
                    case 2: {
                        return new Integer(this.metric.getExperimentID());
                    }
                    case 3: {
                        return new Integer(this.metric.getTrialID());
                    }
                    case 4: {
                        return new Integer(this.metric.getID());
                    }
                }
                return "";
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 && n != 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object instanceof String) {
            String string = (String)object;
            if (n2 == 1) {
                switch (this.type) {
                    case 0: {
                        switch (n) {
                            case 0: {
                                this.application.setName(string);
                                this.updateDB(this.application);
                                break;
                            }
                            case 1: {
                                this.application.setID(Integer.parseInt(string));
                                this.updateDB(this.application);
                                break;
                            }
                            case 2: {
                                this.application.setLanguage(string);
                                this.updateDB(this.application);
                                break;
                            }
                            case 3: {
                                this.application.setParaDiag(string);
                                this.updateDB(this.application);
                                break;
                            }
                            case 4: {
                                this.application.setUsage(string);
                                this.updateDB(this.application);
                                break;
                            }
                            case 5: {
                                this.application.setExecutableOptions(string);
                                this.updateDB(this.application);
                                break;
                            }
                            case 6: {
                                this.application.setDescription(string);
                                this.updateDB(this.application);
                            }
                        }
                        this.defaultTreeModel.nodeChanged(this.application.getDMTN());
                        break;
                    }
                    case 1: {
                        switch (n) {
                            case 0: {
                                this.experiment.setName(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 3: {
                                this.experiment.setUserData(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 4: {
                                this.experiment.setSystemName(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 5: {
                                this.experiment.setSystemMachineType(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 6: {
                                this.experiment.setSystemArch(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 7: {
                                this.experiment.setSystemOS(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 8: {
                                this.experiment.setSystemMemorySize(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 9: {
                                this.experiment.setSystemProcessorAmount(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 10: {
                                this.experiment.setSystemL1CacheSize(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 11: {
                                this.experiment.setSystemL2CacheSize(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 12: {
                                this.experiment.setSystemUserData(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 13: {
                                this.experiment.setConfigurationPrefix(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 14: {
                                this.experiment.setConfigurationArchitecture(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 15: {
                                this.experiment.setConfigurationCpp(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 16: {
                                this.experiment.setConfigurationCc(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 17: {
                                this.experiment.setConfigurationJdk(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 18: {
                                this.experiment.setConfigurationProfile(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 19: {
                                this.experiment.setConfigurationUserData(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 20: {
                                this.experiment.setCompilerCppName(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 21: {
                                this.experiment.setCompilerCppVersion(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 22: {
                                this.experiment.setCompilerCcName(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 23: {
                                this.experiment.setCompilerCcVersion(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 24: {
                                this.experiment.setCompilerJavaDirpath(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 25: {
                                this.experiment.setCompilerJavaVersion(string);
                                this.updateDB(this.experiment);
                                break;
                            }
                            case 26: {
                                this.experiment.setCompilerUserData(string);
                                this.updateDB(this.experiment);
                            }
                        }
                        this.defaultTreeModel.nodeChanged(this.experiment.getDMTN());
                        break;
                    }
                    case 2: {
                        switch (n) {
                            case 0: {
                                this.trial.setName(string);
                                this.updateDB(this.trial);
                                break;
                            }
                            case 8: {
                                this.trial.setUserData(string);
                                this.updateDB(this.trial);
                                break;
                            }
                            case 9: {
                                this.trial.setProblemDefinition(string);
                                this.updateDB(this.trial);
                            }
                        }
                        this.defaultTreeModel.nodeChanged(this.trial.getDMTN());
                    }
                }
            }
        }
    }

    private void updateDB(Object object) {
        PerfDMFSession perfDMFSession;
        ParaProfTrial paraProfTrial;
        if (object instanceof ParaProfApplication) {
            PerfDMFSession perfDMFSession2;
            ParaProfApplication paraProfApplication = (ParaProfApplication)object;
            if (paraProfApplication.dBApplication() && (perfDMFSession2 = this.paraProfManager.getDBSession()) != null) {
                perfDMFSession2.saveApplication((Application)paraProfApplication);
                perfDMFSession2.terminate();
            }
        } else if (object instanceof ParaProfExperiment) {
            PerfDMFSession perfDMFSession3;
            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
            if (paraProfExperiment.dBExperiment() && (perfDMFSession3 = this.paraProfManager.getDBSession()) != null) {
                perfDMFSession3.saveExperiment((Experiment)paraProfExperiment);
                perfDMFSession3.terminate();
            }
        } else if (object instanceof ParaProfTrial && (paraProfTrial = (ParaProfTrial)object).dBTrial() && (perfDMFSession = this.paraProfManager.getDBSession()) != null) {
            perfDMFSession.saveTrial((Trial)paraProfTrial);
            perfDMFSession.terminate();
        }
    }
}

