/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.PerfDMFSession;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.DBConfiguration;
import edu.uoregon.tau.paraprof.FileList;
import edu.uoregon.tau.paraprof.LoadTrialPanel;
import edu.uoregon.tau.paraprof.Metric;
import edu.uoregon.tau.paraprof.PPMLPanel;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerTableModel;
import edu.uoregon.tau.paraprof.ParaProfTreeCellRenderer;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ParaProfManager
extends JFrame
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener {
    private JTree tree = null;
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode standard = null;
    private DefaultMutableTreeNode runtime = null;
    private DefaultMutableTreeNode dbApps = null;
    private JSplitPane jSplitInnerPane = null;
    private JSplitPane jSplitOuterPane = null;
    private DefaultMutableTreeNode defaultParaProfTrialNode = null;
    private JCheckBoxMenuItem showApplyOperationItem = null;
    private PPMLPanel pPMLPanel = new PPMLPanel(this);
    private Vector loadedTrials = new Vector();
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    private JPopupMenu popup3 = new JPopupMenu();
    private JPopupMenu popup4 = new JPopupMenu();
    private JPopupMenu popup5 = new JPopupMenu();
    private JMenuItem uploadMetricItem = null;
    private Object clickedOnObject = null;
    private Metric operand1 = null;
    private Metric operand2 = null;

    public ParaProfManager() {
        try {
            int n = 800;
            int n2 = 515;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n3 = dimension.height;
            int n4 = dimension.width;
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            if (n5 > 50) {
                n5 -= 50;
            }
            if (n6 > 50) {
                n6 -= 50;
            }
            this.setLocation(n5, n6);
            this.setSize(new Dimension(n, n2));
            this.setTitle("ParaProf Manager");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ParaProfManager.this.thisWindowClosing(windowEvent);
                }
            });
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Database Configuration");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenu jMenu2 = new JMenu("Save ...");
            jMenuItem = new JMenuItem("ParaProf Preferrences");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu.add(jMenu2);
            jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Exit ParaProf!");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenu jMenu3 = new JMenu("Options");
            this.showApplyOperationItem = new JCheckBoxMenuItem("Show Apply Operation", false);
            this.showApplyOperationItem.addActionListener(this);
            jMenu3.add(this.showApplyOperationItem);
            JMenu jMenu4 = new JMenu("Help");
            JMenuItem jMenuItem2 = new JMenuItem("About ParaProf");
            jMenuItem2.addActionListener(this);
            jMenu4.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Show Help Window");
            jMenuItem3.addActionListener(this);
            jMenu4.add(jMenuItem3);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            this.setJMenuBar(jMenuBar);
            JMenuItem jMenuItem4 = new JMenuItem("Add Application");
            jMenuItem4.addActionListener(this);
            this.popup1.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Add Experiment");
            jMenuItem4.addActionListener(this);
            this.popup1.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Add Trial");
            jMenuItem4.addActionListener(this);
            this.popup1.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Add Experiment");
            jMenuItem4.addActionListener(this);
            this.popup2.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Delete");
            jMenuItem4.addActionListener(this);
            this.popup2.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Add Trial");
            jMenuItem4.addActionListener(this);
            this.popup2.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Delete");
            jMenuItem4.addActionListener(this);
            this.popup3.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Add Trial");
            jMenuItem4.addActionListener(this);
            this.popup3.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Delete");
            jMenuItem4.addActionListener(this);
            this.popup4.add(jMenuItem4);
            jMenuItem4 = new JMenuItem("Upload Trial to DB");
            jMenuItem4.addActionListener(this);
            this.popup4.add(jMenuItem4);
            this.uploadMetricItem = new JMenuItem("Upload Metric to DB");
            this.uploadMetricItem.addActionListener(this);
            this.popup5.add(this.uploadMetricItem);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Applications");
            this.standard = new DefaultMutableTreeNode("Standard Applications");
            this.runtime = new DefaultMutableTreeNode("Runtime Applications");
            this.dbApps = new DefaultMutableTreeNode("DB Applications");
            defaultMutableTreeNode.add(this.standard);
            defaultMutableTreeNode.add(this.runtime);
            defaultMutableTreeNode.add(this.dbApps);
            this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.treeModel.setAsksAllowsChildren(true);
            this.tree = new JTree(this.treeModel);
            this.tree.getSelectionModel().setSelectionMode(1);
            ParaProfTreeCellRenderer paraProfTreeCellRenderer = new ParaProfTreeCellRenderer();
            this.tree.setCellRenderer(paraProfTreeCellRenderer);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = ParaProfManager.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = ParaProfManager.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if ((mouseEvent.getModifiers() & 0x10) == 0) {
                            if (defaultMutableTreeNode == ParaProfManager.this.standard || defaultMutableTreeNode == ParaProfManager.this.dbApps) {
                                ParaProfManager.this.clickedOnObject = defaultMutableTreeNode;
                                ParaProfManager.this.popup1.show(ParaProfManager.this, mouseEvent.getX(), mouseEvent.getY());
                            } else if (object instanceof ParaProfApplication) {
                                ParaProfManager.this.clickedOnObject = object;
                                ParaProfManager.this.popup2.show(ParaProfManager.this, mouseEvent.getX(), mouseEvent.getY());
                            } else if (object instanceof ParaProfExperiment) {
                                ParaProfManager.this.clickedOnObject = object;
                                ParaProfManager.this.popup3.show(ParaProfManager.this, mouseEvent.getX(), mouseEvent.getY());
                            } else if (object instanceof ParaProfTrial) {
                                ParaProfManager.this.clickedOnObject = object;
                                ParaProfManager.this.popup4.show(ParaProfManager.this, mouseEvent.getX(), mouseEvent.getY());
                            } else if (object instanceof Metric) {
                                ParaProfManager.this.clickedOnObject = object;
                                if (((Metric)object).getTrial().dBTrial()) {
                                    ParaProfManager.this.uploadMetricItem.setEnabled(false);
                                } else {
                                    ParaProfManager.this.uploadMetricItem.setEnabled(true);
                                }
                                ParaProfManager.this.popup5.show(ParaProfManager.this, mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else if (mouseEvent.getClickCount() == 2 && object instanceof Metric) {
                            ParaProfManager.this.metric((Metric)object, true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(mouseAdapter);
            this.tree.addTreeSelectionListener(this);
            this.tree.addTreeWillExpandListener(this);
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            this.jSplitInnerPane = new JSplitPane(1, jScrollPane, this.getPanelHelpMessage(0));
            this.jSplitInnerPane.setContinuousLayout(true);
            this.jSplitOuterPane = new JSplitPane(0, this.jSplitInnerPane, this.pPMLPanel);
            this.getContentPane().add((Component)this.jSplitOuterPane, "Center");
            this.show();
            this.jSplitInnerPane.setDividerLocation(0.5);
            this.jSplitOuterPane.setDividerLocation(1.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UtilFncs.systemError((Object)exception, null, (String)"PPM01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Close This Window")) {
                    if (!ParaProf.runHasBeenOpened) {
                        this.setVisible(false);
                        this.dispose();
                        System.out.println("Quiting ParaProf!");
                        System.exit(0);
                    } else {
                        this.dispose();
                    }
                } else if (string.equals("Database Configuration")) {
                    new DBConfiguration(this).show();
                } else if (string.equals("ParaProf Preferrences")) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setSelectedFile(new File("pref.dat"));
                    int n = jFileChooser.showSaveDialog(this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        if (file != null) {
                            try {
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                                objectOutputStream.writeObject(ParaProf.savedPreferences);
                                objectOutputStream.close();
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(this, "An error occured whilst trying to save ParaProf preferences.", "Error!", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "No filename was given!", "Error!", 0);
                        }
                    }
                } else if (string.equals("Show Apply Operation")) {
                    if (this.showApplyOperationItem.isSelected()) {
                        this.jSplitOuterPane.setDividerLocation(0.75);
                    } else {
                        this.jSplitOuterPane.setDividerLocation(1.0);
                    }
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    ParaProf.helpWindow.show();
                    ParaProf.helpWindow.clearText();
                    ParaProf.helpWindow.writeText("This is ParaProf's manager window!");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window allows you to manage all of ParaProf's data sources, including loading data from local files, or from a database. We also support the generation of derived metrics. Please see the items below for more help.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("------------------");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("1) Navigation: The window is split into two halves, the left side gives a tree representation of all data. The right side gives information about items clicked on in the left half. You can also update information in the right half by double clicking in the fields, and entering new data.  This automatically updates the left half. Right-clicking on the tree nodes in the left half displays popup menus which allow you to add/delete applications, experiments, or trials.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("2) DB Configuration: By default, ParaProf looks in the .ParaProf home directory in your home directory for the database configuration file.  If that file is found, then you are done, and can just expand the DB Applications node.  If there was a problem finding the file, you can enter the location of the file by selecting File -> Database Configuration.  You can also override the configuration file password in the same manner.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("3) Deriving new metrics: By selecting Options -> Show Apply Operation, you will display the apply operations window.  Clicking on the metrics of a trial will update the arguments to the selected operation.  Currently, you can only derive metrics from metric in the same trial (thus for example creating floating point operations per second), and you cannot enter the arguments manually.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("------------------");
                    ParaProf.helpWindow.writeText("");
                } else if (string.equals("Delete")) {
                    if (this.clickedOnObject instanceof ParaProfApplication) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            PerfDMFSession perfDMFSession = this.getDBSession();
                            if (perfDMFSession != null) {
                                perfDMFSession.deleteApplication(paraProfApplication.getID());
                                perfDMFSession.terminate();
                                System.out.println("Removing associated loaded trials from this ParaProf session ...");
                                Enumeration enumeration = this.loadedTrials.elements();
                                while (enumeration.hasMoreElements()) {
                                    ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                                    if (paraProfTrial.getApplicationID() != paraProfApplication.getID()) continue;
                                    this.loadedTrials.remove(paraProfTrial);
                                }
                                System.out.println("Done - Removing associated loaded trials!");
                                this.treeModel.removeNodeFromParent(paraProfApplication.getDMTN());
                                System.out.println("Application deleted!");
                            }
                        } else {
                            System.out.println("Removing associated loaded trials from this ParaProf session ...");
                            ParaProf.applicationManager.removeApplication(paraProfApplication);
                            this.treeModel.removeNodeFromParent(paraProfApplication.getDMTN());
                            System.out.println("Application deleted!");
                        }
                    } else if (this.clickedOnObject instanceof ParaProfExperiment) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)this.clickedOnObject;
                        if (paraProfExperiment.dBExperiment()) {
                            PerfDMFSession perfDMFSession = this.getDBSession();
                            if (perfDMFSession != null) {
                                perfDMFSession.deleteExperiment(paraProfExperiment.getID());
                                perfDMFSession.terminate();
                                System.out.println("Removing associated loaded trials from this ParaProf session ...");
                                Enumeration enumeration = this.loadedTrials.elements();
                                while (enumeration.hasMoreElements()) {
                                    ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                                    if (paraProfTrial.getApplicationID() != paraProfExperiment.getApplicationID() || paraProfTrial.getExperimentID() != paraProfExperiment.getID()) continue;
                                    this.loadedTrials.remove(paraProfTrial);
                                }
                                this.treeModel.removeNodeFromParent(paraProfExperiment.getDMTN());
                                System.out.println("Experiment deleted!");
                            }
                        } else {
                            System.out.println("Removing associated loaded trials from this ParaProf session ...");
                            paraProfExperiment.getApplication().removeExperiment(paraProfExperiment);
                            this.treeModel.removeNodeFromParent(paraProfExperiment.getDMTN());
                            System.out.println("Experiment deleted!");
                        }
                    } else if (this.clickedOnObject instanceof ParaProfTrial) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                        if (paraProfTrial.dBTrial()) {
                            PerfDMFSession perfDMFSession = this.getDBSession();
                            if (perfDMFSession != null) {
                                perfDMFSession.deleteTrial(paraProfTrial.getID());
                                perfDMFSession.terminate();
                                System.out.println("Removing associated loaded trials from this ParaProf session ...");
                                Enumeration enumeration = this.loadedTrials.elements();
                                while (enumeration.hasMoreElements()) {
                                    ParaProfTrial paraProfTrial2 = (ParaProfTrial)enumeration.nextElement();
                                    if (paraProfTrial2.getApplicationID() != paraProfTrial.getApplicationID() || paraProfTrial2.getExperimentID() != paraProfTrial.getID() || paraProfTrial2.getID() != paraProfTrial.getID()) continue;
                                    this.loadedTrials.remove(paraProfTrial2);
                                }
                                this.treeModel.removeNodeFromParent(paraProfTrial.getDMTN());
                                System.out.println("Trial deleted!");
                            }
                        } else {
                            System.out.println("Removing trial from this ParaProf session ...");
                            paraProfTrial.getExperiment().removeTrial(paraProfTrial);
                            this.treeModel.removeNodeFromParent(paraProfTrial.getDMTN());
                            System.out.println("Trial deleted!");
                        }
                    }
                } else if (string.equals("Add Application")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                    } else if (this.clickedOnObject == this.dbApps) {
                        ParaProfApplication paraProfApplication = this.addApplication(true, this.dbApps);
                        this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                    }
                } else if (string.equals("Add Experiment")) {
                    ParaProfExperiment paraProfExperiment;
                    ParaProfApplication paraProfApplication;
                    if (this.clickedOnObject == this.standard) {
                        paraProfApplication = this.addApplication(false, this.standard);
                        paraProfExperiment = this.addExperiment(false, paraProfApplication);
                        if (paraProfApplication != null || paraProfExperiment != null) {
                            this.expandApplication(0, paraProfApplication.getID(), paraProfExperiment.getID(), paraProfApplication, paraProfExperiment);
                        } else {
                            System.out.println("There was an error adding the experiment!");
                        }
                    } else if (this.clickedOnObject == this.dbApps) {
                        paraProfApplication = this.addApplication(true, this.dbApps);
                        paraProfExperiment = this.addExperiment(true, paraProfApplication);
                        if (paraProfApplication != null || paraProfExperiment != null) {
                            this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), paraProfApplication, paraProfExperiment);
                        } else {
                            System.out.println("There was an error adding the experiment!");
                        }
                    }
                    if (this.clickedOnObject instanceof ParaProfApplication) {
                        paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                            } else {
                                System.out.println("There was an error adding the experiment!");
                            }
                        } else {
                            paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication.getID(), paraProfExperiment.getID(), null, paraProfExperiment);
                            } else {
                                System.out.println("There was an error adding the experiment!");
                            }
                        }
                    }
                } else if (string.equals("Add Trial")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfExperiment paraProfExperiment;
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        if (paraProfApplication != null && (paraProfExperiment = this.addExperiment(false, paraProfApplication)) != null) {
                            new LoadTrialPanel(this, paraProfApplication, paraProfExperiment, false).show();
                        }
                    } else if (this.clickedOnObject == this.dbApps) {
                        ParaProfExperiment paraProfExperiment;
                        ParaProfApplication paraProfApplication = this.addApplication(true, this.dbApps);
                        if (paraProfApplication != null && (paraProfExperiment = this.addExperiment(true, paraProfApplication)) != null) {
                            new LoadTrialPanel(this, paraProfApplication, paraProfExperiment, false).show();
                        }
                    } else if (this.clickedOnObject instanceof ParaProfApplication) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                new LoadTrialPanel(this, null, paraProfExperiment, false).show();
                            }
                        } else {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                new LoadTrialPanel(this, null, paraProfExperiment, false).show();
                            }
                        }
                    } else if (this.clickedOnObject instanceof ParaProfExperiment) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)this.clickedOnObject;
                        if (paraProfExperiment.dBExperiment()) {
                            new LoadTrialPanel(this, null, paraProfExperiment, true).show();
                        } else {
                            new LoadTrialPanel(this, null, paraProfExperiment, false).show();
                        }
                    }
                } else if (string.equals("Upload Trial to DB")) {
                    if (this.clickedOnObject instanceof ParaProfTrial) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                        int[] nArray = this.getSelectedDBExperiment();
                        if (nArray != null) {
                            System.out.println("Uploading trial: " + paraProfTrial.getApplicationID() + "," + paraProfTrial.getExperimentID() + "," + paraProfTrial.getID() + " to the database. Please wait ...");
                            PerfDMFSession perfDMFSession = this.getDBSession();
                            if (perfDMFSession != null) {
                                Trial trial = new Trial();
                                trial.setDataSession(paraProfTrial.getDataSession());
                                trial.setName(paraProfTrial.getName());
                                trial.setExperimentID(nArray[1]);
                                int[] nArray2 = paraProfTrial.getMaxNCTNumbers();
                                trial.setNodeCount(nArray2[0] + 1);
                                trial.setNumContextsPerNode(nArray2[1] + 1);
                                trial.setNumThreadsPerContext(nArray2[2] + 1);
                                perfDMFSession.saveParaProfTrial(trial, -1);
                                perfDMFSession.terminate();
                            }
                            System.out.println("Done uploading trial: " + paraProfTrial.getApplicationID() + "," + paraProfTrial.getExperimentID() + "," + paraProfTrial.getID());
                        }
                    }
                } else if (string.equals("Upload Metric to DB") && this.clickedOnObject instanceof Metric) {
                    PerfDMFSession perfDMFSession;
                    Metric metric = (Metric)this.clickedOnObject;
                    int[] nArray = this.getSelectedDBTrial();
                    if (nArray != null && (perfDMFSession = this.getDBSession()) != null) {
                        Trial trial = new Trial();
                        trial.setDataSession(metric.getTrial().getDataSession());
                        trial.setID(nArray[2]);
                        perfDMFSession.saveParaProfTrial(trial, metric.getID());
                        perfDMFSession.terminate();
                        Enumeration enumeration = this.loadedTrials.elements();
                        while (enumeration.hasMoreElements()) {
                            ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                            if (trial.getID() != nArray[2] || trial.getExperimentID() != nArray[1] || trial.getApplicationID() != nArray[0]) continue;
                            this.loadedTrials.remove(paraProfTrial);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"ELM05");
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        if (UtilFncs.debug) {
            System.out.println("In valueChanged - path:" + treePath.toString());
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isRoot()) {
            this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(0));
            this.jSplitInnerPane.setDividerLocation(0.5);
        } else if (defaultMutableTreeNode2.isRoot()) {
            if (object.toString().equals("Standard Applications")) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(1));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object.toString().equals("Runtime Applications")) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(2));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object.toString().equals("DB Applications")) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(3));
                this.jSplitInnerPane.setDividerLocation(0.5);
            }
        } else if (object instanceof ParaProfApplication) {
            this.jSplitInnerPane.setRightComponent(this.getTable(object));
            this.jSplitInnerPane.setDividerLocation(0.5);
        } else if (object instanceof ParaProfExperiment) {
            this.jSplitInnerPane.setRightComponent(this.getTable(object));
            this.jSplitInnerPane.setDividerLocation(0.5);
        } else if (object instanceof ParaProfTrial) {
            this.jSplitInnerPane.setRightComponent(this.getTable(object));
            this.jSplitInnerPane.setDividerLocation(0.5);
        } else if (object instanceof Metric) {
            this.metric((Metric)object, false);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath == null) {
            return;
        }
        if (UtilFncs.debug) {
            System.out.println("In treeWillCollapse - path:" + treePath.toString());
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isRoot()) {
            int n;
            int n2 = this.standard.getChildCount();
            for (n = 0; n < n2; ++n) {
                this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.standard.getChildAt(n));
            }
            n2 = this.runtime.getChildCount();
            for (n = 0; n < n2; ++n) {
                this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.runtime.getChildAt(n));
            }
            n2 = this.dbApps.getChildCount();
            for (n = 0; n < n2; ++n) {
                this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.dbApps.getChildAt(n));
            }
        } else if (defaultMutableTreeNode2.isRoot()) {
            if (object.toString().equals("Standard Applications")) {
                int n = this.standard.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.standard.getChildAt(i));
                }
            } else if (object.toString().equals("Runtime Applications")) {
                int n = this.runtime.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.runtime.getChildAt(i));
                }
            } else if (object.toString().equals("DB Applications")) {
                int n = this.dbApps.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)this.dbApps.getChildAt(i));
                }
            }
        } else if (object instanceof ParaProfTreeNodeUserObject) {
            this.clearDefaultMutableTreeNodes(defaultMutableTreeNode);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath == null) {
            return;
        }
        if (UtilFncs.debug) {
            System.out.println("In treeWillExpand - path:" + treePath.toString());
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isRoot()) {
            return;
        }
        if (defaultMutableTreeNode2.isRoot()) {
            if (object.toString().equals("Standard Applications")) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(1));
                this.jSplitInnerPane.setDividerLocation(0.5);
                System.out.println("Loading application list ...");
                for (int i = this.standard.getChildCount(); i > 0; --i) {
                    this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.standard.getChildAt(i - 1));
                }
                DataSessionIterator dataSessionIterator = ParaProf.applicationManager.getApplicationList();
                while (dataSessionIterator.hasNext()) {
                    ParaProfApplication paraProfApplication = (ParaProfApplication)dataSessionIterator.next();
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode3);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode3, this.standard, this.standard.getChildCount());
                }
                System.out.println("Done loading application list.");
                return;
            }
            if (object.toString().equals("Runtime Applications")) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(2));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else if (object.toString().equals("DB Applications")) {
                try {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(3));
                    this.jSplitInnerPane.setDividerLocation(0.5);
                    System.out.println("Loading application list ...");
                    for (int i = this.dbApps.getChildCount(); i > 0; --i) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.dbApps.getChildAt(i - 1));
                    }
                    PerfDMFSession perfDMFSession = this.getDBSession();
                    if (perfDMFSession != null) {
                        ListIterator listIterator = perfDMFSession.getApplicationList();
                        while (listIterator.hasNext()) {
                            ParaProfApplication paraProfApplication = new ParaProfApplication((Application)listIterator.next());
                            paraProfApplication.setDBApplication(true);
                            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(paraProfApplication);
                            paraProfApplication.setDMTN(defaultMutableTreeNode4);
                            this.treeModel.insertNodeInto(defaultMutableTreeNode4, this.dbApps, this.dbApps.getChildCount());
                        }
                        perfDMFSession.terminate();
                    }
                    System.out.println("Done loading application list.");
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (object instanceof ParaProfApplication) {
            try {
                ParaProfApplication paraProfApplication = (ParaProfApplication)object;
                if (paraProfApplication.dBApplication()) {
                    System.out.println("Loading experiment list ...");
                    for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1));
                    }
                    PerfDMFSession perfDMFSession = this.getDBSession();
                    if (perfDMFSession != null) {
                        perfDMFSession.setApplication(paraProfApplication.getID());
                        ListIterator listIterator = perfDMFSession.getExperimentList();
                        while (listIterator.hasNext()) {
                            ParaProfExperiment paraProfExperiment = new ParaProfExperiment((Experiment)listIterator.next());
                            paraProfExperiment.setDBExperiment(true);
                            paraProfExperiment.setApplication(paraProfApplication);
                            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(paraProfExperiment);
                            paraProfExperiment.setDMTN(defaultMutableTreeNode5);
                            this.treeModel.insertNodeInto(defaultMutableTreeNode5, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        }
                        perfDMFSession.terminate();
                    }
                    System.out.println("Done loading experiment list.");
                } else {
                    System.out.println("Loading experiment list ...");
                    for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                        this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1));
                    }
                    ListIterator listIterator = paraProfApplication.getExperimentList();
                    while (listIterator.hasNext()) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(paraProfExperiment);
                        paraProfExperiment.setDMTN(defaultMutableTreeNode6);
                        this.treeModel.insertNodeInto(defaultMutableTreeNode6, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    }
                    System.out.println("Done loading experiment list.");
                }
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof ParaProfExperiment) {
            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
            if (paraProfExperiment.dBExperiment()) {
                System.out.println("Loading trial list ...");
                for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                    this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1));
                }
                PerfDMFSession perfDMFSession = this.getDBSession();
                if (perfDMFSession != null) {
                    perfDMFSession.setApplication(paraProfExperiment.getApplicationID());
                    perfDMFSession.setExperiment(paraProfExperiment.getID());
                    ListIterator listIterator = perfDMFSession.getTrialList();
                    while (listIterator.hasNext()) {
                        ParaProfTrial paraProfTrial = new ParaProfTrial((Trial)listIterator.next(), 4);
                        paraProfTrial.setExperiment(paraProfExperiment);
                        paraProfTrial.setDBTrial(true);
                        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(paraProfTrial);
                        paraProfTrial.setDMTN(defaultMutableTreeNode7);
                        this.treeModel.insertNodeInto(defaultMutableTreeNode7, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        paraProfTrial.setTreePath(new TreePath(defaultMutableTreeNode7.getPath()));
                    }
                    perfDMFSession.terminate();
                }
                System.out.println("Done loading trial list.");
            } else {
                System.out.println("Loading trial list ...");
                for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                    this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1));
                }
                DataSessionIterator dataSessionIterator = paraProfExperiment.getTrialList();
                while (dataSessionIterator.hasNext()) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)dataSessionIterator.next();
                    DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(paraProfTrial);
                    paraProfTrial.setDMTN(defaultMutableTreeNode8);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode8, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    paraProfTrial.setTreePath(new TreePath(defaultMutableTreeNode8.getPath()));
                }
                System.out.println("Done loading trial list.");
            }
            this.jSplitInnerPane.setRightComponent(this.getTable(object));
            this.jSplitInnerPane.setDividerLocation(0.5);
        } else if (object instanceof ParaProfTrial) {
            Object object2;
            Object object3;
            int n;
            Object object4 = (ParaProfTrial)object;
            if (((ParaProfTrial)object4).dBTrial()) {
                n = 0;
                object3 = this.loadedTrials.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ParaProfTrial)object3.nextElement();
                    if (object4.getID() != object2.getID() || object4.getExperimentID() != object2.getExperimentID() || object4.getApplicationID() != object2.getApplicationID()) continue;
                    defaultMutableTreeNode.setUserObject(object2);
                    object4 = object2;
                    n = 1;
                }
                if (n == 0) {
                    System.out.println("Loading trial ...");
                    object3 = this.getDBSession();
                    if (object3 != null) {
                        object3.setApplication(object4.getApplicationID());
                        object3.setExperiment(object4.getExperimentID());
                        object3.setTrial(object4.getID());
                        ((ParaProfTrial)object4).initialize(object3);
                        this.loadedTrials.add(object4);
                    }
                }
            }
            if (!((ParaProfTrial)object4).loading()) {
                System.out.println("Loading metric list ...");
                for (n = defaultMutableTreeNode.getChildCount(); n > 0; --n) {
                    this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
                }
                DataSessionIterator dataSessionIterator = ((ParaProfTrial)object4).getMetricList();
                while (dataSessionIterator.hasNext()) {
                    object3 = (Metric)dataSessionIterator.next();
                    object2 = new DefaultMutableTreeNode(object3, false);
                    ((Metric)object3).setDMTN((DefaultMutableTreeNode)object2);
                    this.treeModel.insertNodeInto((MutableTreeNode)object2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                }
                System.out.println("Done loading metric list.");
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
                this.jSplitInnerPane.setDividerLocation(0.5);
            } else {
                this.jSplitInnerPane.setRightComponent(new JScrollPane(this.getLoadingTrialPanel(object)));
                this.jSplitInnerPane.setDividerLocation(0.5);
            }
        }
    }

    private void metric(Metric metric, boolean bl) {
        this.jSplitInnerPane.setRightComponent(this.getTable(metric));
        this.jSplitInnerPane.setDividerLocation(0.5);
        this.operand2 = this.operand1;
        this.pPMLPanel.setArg2Field(this.pPMLPanel.getArg1Field());
        this.operand1 = metric;
        this.pPMLPanel.setArg1Field(metric.getApplicationID() + ":" + metric.getExperimentID() + ":" + metric.getTrialID() + ":" + metric.getID() + " - " + metric.getName());
        if (bl) {
            this.showMetric(metric);
        }
    }

    public Metric getOperand1() {
        return this.operand1;
    }

    public Metric getOperand2() {
        return this.operand2;
    }

    public void uploadMetric(Metric metric) {
        PerfDMFSession perfDMFSession;
        if (metric != null && (perfDMFSession = this.getDBSession()) != null) {
            perfDMFSession.saveParaProfTrial((Trial)metric.getTrial(), metric.getID());
            perfDMFSession.terminate();
        }
    }

    public void clearDefaultMutableTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.clearDefaultMutableTreeNodesHelper((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }

    public void clearDefaultMutableTreeNodesHelper(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.clearDefaultMutableTreeNodesHelper((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        ((ParaProfTreeNodeUserObject)defaultMutableTreeNode.getUserObject()).clearDefaultMutableTreeNodes();
    }

    public int[] getSelectedDBExperiment() {
        if (ParaProf.savedPreferences.getDatabaseConfigurationFile() == null || ParaProf.savedPreferences.getDatabasePassword() == null) {
            JOptionPane.showMessageDialog(this, "Please set the database configuration information (file menu).", "DB Configuration Error!", 0);
            return null;
        }
        TreePath treePath = this.tree.getSelectionPath();
        boolean bl = false;
        if (treePath == null) {
            bl = true;
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ParaProfExperiment) {
                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
                if (paraProfExperiment.dBExperiment()) {
                    int[] nArray = new int[]{paraProfExperiment.getApplicationID(), paraProfExperiment.getID()};
                    return nArray;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this, "Please select an db experiment first!", "DB Upload Error!", 0);
        }
        return null;
    }

    public int[] getSelectedDBTrial() {
        if (ParaProf.savedPreferences.getDatabaseConfigurationFile() == null || ParaProf.savedPreferences.getDatabasePassword() == null) {
            JOptionPane.showMessageDialog(this, "Please set the database configuration information (file menu).", "DB Configuration Error!", 0);
            return null;
        }
        TreePath treePath = this.tree.getSelectionPath();
        boolean bl = false;
        if (treePath == null) {
            bl = true;
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ParaProfTrial) {
                ParaProfTrial paraProfTrial = (ParaProfTrial)object;
                if (paraProfTrial.dBTrial()) {
                    int[] nArray = new int[]{paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID()};
                    return nArray;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this, "Please select an db trial first!", "DB Upload Error!", 0);
        }
        return null;
    }

    private Component getPanelHelpMessage(int n) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        switch (n) {
            case 0: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This window allows you to manage all of ParaProf's loaded data.\n");
                jTextArea.append("Data can be static (ie, not updated at runtime), and loaded either remotely or locally.  You can also specify data to be uploaded at runtime.\n\n");
                break;
            }
            case 1: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the Standard application section:\n\n");
                jTextArea.append("Standard - The classic ParaProf mode.  Data sets that are loaded at startup are placedunder the default application automatically. Please see the ParaProf documentation for mre details.\n");
                break;
            }
            case 2: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the Runtime application section:\n\n");
                jTextArea.append("Runtime - A new feature allowing ParaProf to update data at runtime.  Please see the ParaProf documentation if the options are not clear.\n");
                jTextArea.append("*** THIS FEATURE IS CURRENTLY OFF ***\n");
                break;
            }
            case 3: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the DB Apps application section:\n\n");
                jTextArea.append("DB Apps - Another new feature allowing ParaProf to load data from a database.  Again, please see the ParaProf documentation if the options are not clear.\n");
                break;
            }
        }
        return new JScrollPane(jTextArea);
    }

    private Component getTable(Object object) {
        return new JScrollPane(new JTable(new ParaProfManagerTableModel(this, object, this.treeModel)));
    }

    private Component getLoadingTrialPanel(Object object) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel("Trial loading ... Please wait!");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add(this.getTable(object), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        return jPanel;
    }

    public ParaProfApplication addApplication(boolean bl, DefaultMutableTreeNode defaultMutableTreeNode) {
        ParaProfApplication paraProfApplication = null;
        if (bl) {
            PerfDMFSession perfDMFSession = this.getDBSession();
            if (perfDMFSession != null) {
                paraProfApplication = new ParaProfApplication();
                paraProfApplication.setDBApplication(true);
                paraProfApplication.setName("New Application");
                paraProfApplication.setID(perfDMFSession.saveApplication((Application)paraProfApplication));
                perfDMFSession.terminate();
            }
        } else {
            paraProfApplication = ParaProf.applicationManager.addApplication();
            paraProfApplication.setName("New Application");
        }
        return paraProfApplication;
    }

    public ParaProfExperiment addExperiment(boolean bl, ParaProfApplication paraProfApplication) {
        ParaProfExperiment paraProfExperiment = null;
        if (bl) {
            PerfDMFSession perfDMFSession = this.getDBSession();
            if (perfDMFSession != null) {
                paraProfExperiment = new ParaProfExperiment();
                paraProfExperiment.setDBExperiment(true);
                paraProfExperiment.setApplicationID(paraProfApplication.getID());
                paraProfExperiment.setName("New Experiment");
                paraProfExperiment.setID(perfDMFSession.saveExperiment((Experiment)paraProfExperiment));
                perfDMFSession.terminate();
            }
        } else {
            paraProfExperiment = paraProfApplication.addExperiment();
            paraProfExperiment.setName("New Experiment");
        }
        return paraProfExperiment;
    }

    public void addTrial(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, File file, String string, int n) {
        try {
            ParaProfTrial paraProfTrial = null;
            FileList fileList = new FileList();
            Vector vector = null;
            if (n == 0) {
                n = 1;
            } else if (n == 1) {
                n = 0;
            }
            if (n != -1) {
                switch (n) {
                    case 0: {
                        if (string == null) {
                            vector = fileList.getFileList(file, null, n, "pprof", UtilFncs.debug);
                            break;
                        }
                        vector = fileList.getFileList(file, null, n, string, UtilFncs.debug);
                        break;
                    }
                    case 1: {
                        if (string == null) {
                            vector = fileList.getFileList(file, null, n, "profile", UtilFncs.debug);
                            break;
                        }
                        vector = fileList.getFileList(file, null, n, string, UtilFncs.debug);
                        break;
                    }
                    case 2: {
                        vector = fileList.getFileList(file, null, n, string, UtilFncs.debug);
                        break;
                    }
                    case 5: {
                        if (string == null) {
                            vector = fileList.getFileList(file, null, n, "gprof", UtilFncs.debug);
                            break;
                        }
                        vector = fileList.getFileList(file, null, n, string, UtilFncs.debug);
                        break;
                    }
                    default: {
                        vector = new Vector();
                        System.out.println("Unrecognized file type.");
                    }
                }
                if (vector.size() > 0) {
                    paraProfTrial = new ParaProfTrial(null, n);
                    if (paraProfExperiment.dBExperiment()) {
                        paraProfTrial.setUpload(true);
                    } else {
                        paraProfExperiment.addTrial(paraProfTrial);
                    }
                    paraProfTrial.setExperiment(paraProfExperiment);
                    paraProfTrial.setApplicationID(paraProfExperiment.getApplicationID());
                    paraProfTrial.setExperimentID(paraProfExperiment.getID());
                    paraProfTrial.setPaths(fileList.getPath());
                    paraProfTrial.setName(paraProfTrial.getPathReverse());
                    paraProfTrial.setLoading(true);
                    paraProfTrial.initialize(vector);
                    if (paraProfExperiment.dBExperiment()) {
                        this.expandTrial(2, paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID(), paraProfApplication, paraProfExperiment, paraProfTrial);
                    } else {
                        this.expandTrial(0, paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID(), paraProfApplication, paraProfExperiment, paraProfTrial);
                    }
                } else {
                    System.out.println("No profile files found in the selected directory.");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error adding trial ... aborted.");
            System.out.println("Location - ParaProfManager.addTrial(...)");
            if (UtilFncs.debug) {
                exception.printStackTrace();
            }
            return;
        }
    }

    private void showMetric(Metric metric) {
        try {
            ParaProfTrial paraProfTrial = metric.getTrial();
            paraProfTrial.setSelectedMetricID(metric.getID());
            paraProfTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
            paraProfTrial.showMainWindow();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"PPM04");
        }
    }

    public void populateTrialMetrics(ParaProfTrial paraProfTrial) {
        if (paraProfTrial.upload()) {
            System.out.println("Uploading trial: " + paraProfTrial.getApplicationID() + "," + paraProfTrial.getExperimentID() + "," + paraProfTrial.getID() + " to the database. Please wait ...");
            PerfDMFSession perfDMFSession = this.getDBSession();
            if (perfDMFSession != null) {
                paraProfTrial.setID(perfDMFSession.saveParaProfTrial((Trial)paraProfTrial, -1));
                perfDMFSession.terminate();
            }
            paraProfTrial.setUpload(false);
            System.out.println("Done uploading trial: " + paraProfTrial.getApplicationID() + "," + paraProfTrial.getExperimentID() + "," + paraProfTrial.getID());
            this.loadedTrials.add(paraProfTrial);
            paraProfTrial.setDBTrial(true);
        }
        if (paraProfTrial.dBTrial()) {
            this.expandTrial(2, paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID(), null, null, paraProfTrial);
        } else {
            this.expandTrial(0, paraProfTrial.getApplicationID(), paraProfTrial.getExperimentID(), paraProfTrial.getID(), null, null, paraProfTrial);
        }
    }

    public DefaultMutableTreeNode expandApplicationType(int n, int n2, ParaProfApplication paraProfApplication) {
        switch (n) {
            case 0: {
                if (!this.tree.isExpanded(new TreePath(this.standard.getPath()))) {
                    this.tree.expandPath(new TreePath(this.standard.getPath()));
                }
                for (int i = this.standard.getChildCount(); i > 0; --i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.standard.getChildAt(i - 1);
                    if (n2 != ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) continue;
                    return defaultMutableTreeNode;
                }
                if (paraProfApplication != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode, this.standard, this.standard.getChildCount());
                    return defaultMutableTreeNode;
                }
                return null;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.tree.isExpanded(new TreePath(this.dbApps.getPath()))) {
                    this.tree.expandPath(new TreePath(this.dbApps.getPath()));
                }
                for (int i = this.dbApps.getChildCount(); i > 0; --i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.dbApps.getChildAt(i - 1);
                    if (n2 != ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) continue;
                    return defaultMutableTreeNode;
                }
                if (paraProfApplication != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode, this.dbApps, this.dbApps.getChildCount());
                    return defaultMutableTreeNode;
                }
                return null;
            }
        }
        return null;
    }

    public DefaultMutableTreeNode expandApplication(int n, int n2, int n3, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplicationType(n, n2, paraProfApplication);
        if (defaultMutableTreeNode != null) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            this.tree.expandPath(new TreePath(this.standard.getPath()));
            for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1);
                if (n3 != ((ParaProfExperiment)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfExperiment != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfExperiment);
                paraProfExperiment.setDMTN(defaultMutableTreeNode3);
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    public DefaultMutableTreeNode expandExperiment(int n, int n2, int n3, int n4, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplication(n, n2, n3, paraProfApplication, paraProfExperiment);
        if (defaultMutableTreeNode != null) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1);
                if (n4 != ((ParaProfTrial)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfTrial != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfTrial);
                paraProfTrial.setDMTN(defaultMutableTreeNode3);
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    public void expandTrial(int n, int n2, int n3, int n4, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandExperiment(n, n2, n3, n4, paraProfApplication, paraProfExperiment, paraProfTrial);
        if (defaultMutableTreeNode != null) {
            if (this.tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) {
                this.tree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
            }
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public PerfDMFSession getDBSession() {
        try {
            if (ParaProf.savedPreferences.getDatabaseConfigurationFile() == null) {
                JOptionPane.showMessageDialog(this, "Please set the database configuration information (file menu).", "DB Configuration Error!", 0);
                return null;
            }
            File file = new File(ParaProf.savedPreferences.getDatabaseConfigurationFile());
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, "Specified configuration file does not exist.", "DB Configuration Error!", 0);
                return null;
            }
            file = new PerfDMFSession();
            if (ParaProf.savedPreferences.getDatabasePassword() == null) {
                file.initialize(ParaProf.savedPreferences.getDatabaseConfigurationFile(), false, false);
            } else {
                file.initialize(ParaProf.savedPreferences.getDatabaseConfigurationFile(), ParaProf.savedPreferences.getDatabasePassword(), false);
            }
            return file;
        }
        catch (Exception exception) {
            ParaProf.helpWindow.show();
            ParaProf.helpWindow.clearText();
            ParaProf.helpWindow.writeText("There was an error connecting to the database!");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Please see the help items below to try and resolve this issue. If none of those work, send an email to tau-bugs@cs.uoregon.edu including as complete a description of the problem as possible.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("------------------");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("1) JDBC driver issue: The JDBC driver is required in your classpath. If you ran ParaProf using the shell script provided in tau (paraprof), then the default. location used is $LOCATION_OF_TAU_ROOT/$ARCH/lib.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText(" If you ran ParaProf manually, make sure that the location of the JDBC driver is in your classpath (you can set this in your. environment, or as a commmand line option to java. As an example, PostgreSQL uses postgresql.jar as its JDBC driver name.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("2) Network connection issue: Check your ability to connect to the database. You might be connecting to the incorrect port (PostgreSQL uses port 5432 by default). Also make sure that if there exists a firewall on you network (or local machine), it is not blocking you connection. Also check your database logs to ensure that you have permission to connect to the server.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("3) Password issue: Make sure that your password is set correctly. If it is not in the perfdmf configuration file, you can enter it manually by selecting  File -> Database Configuration in the ParaProfManager window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("------------------");
            ParaProf.helpWindow.writeText("");
            this.tree.collapsePath(new TreePath(this.dbApps));
            return null;
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (UtilFncs.debug) {
                System.out.println("------------------------");
                System.out.println("ParaProfExperiment List Manager Window is closing!");
                System.out.println("Clearing resourses for this window.");
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"ELM06");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }
}

