/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.Mapping;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.awt.Color;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ListIterator;
import java.util.Vector;

public class GlobalMappingElement
implements Mapping,
Serializable,
Comparable {
    private String mappingName = null;
    private int mappingID = -1;
    private int[] groups = null;
    private int numberOfGroups = 0;
    private Vector parents = null;
    private Vector children = null;
    private Vector callPathIDSParents = null;
    private Vector callPathIDSChildren = null;
    private boolean callPathObject = false;
    private boolean colorFlag = false;
    private Color color = null;
    private Color specificColor = null;
    private double[] doubleList = null;
    private int maxNumberOfCalls = 0;
    private int maxNumberOfSubRoutines = 0;
    private int maxUserEventNumberValue = 0;
    private double maxUserEventMinValue = 0.0;
    private double maxUserEventMaxValue = 0.0;
    private double maxUserEventMeanValue = 0.0;
    private double meanNumberOfCalls = 0.0;
    private double meanNumberOfSubRoutines = 0.0;
    private int totalNumberOfCalls = 0;
    private int totalNumberOfSubRoutines = 0;
    private int xBeg;
    private int xEnd;
    private int yBeg;
    private int yEnd;
    private boolean meanValuesSet = false;
    private boolean groupsSet = false;
    private int counter = 0;
    private double totalExclusiveValue = 0.0;
    private double totalInclusiveValue = 0.0;
    private Vector members = null;

    public GlobalMappingElement(int n) {
        this.doubleList = new double[n * 15];
    }

    public void setMappingName(String string) {
        this.mappingName = string;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setMappingID(int n) {
        this.mappingID = n;
    }

    public int getMappingID() {
        return this.mappingID;
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + 14];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    public void incrementStorage(int n) {
        int n2 = this.doubleList.length;
        double[] dArray = new double[n2 + n * 14];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    public void addGroup(int n) {
        if (this.isGroupMember(n)) {
            return;
        }
        if (this.groups == null) {
            this.groups = new int[5];
        } else if (this.groups.length <= this.numberOfGroups) {
            int n2 = this.groups.length;
            int[] nArray = new int[n2 + 5];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.groups[i];
            }
            this.groups = nArray;
        }
        this.groups[this.numberOfGroups] = n;
        ++this.numberOfGroups;
    }

    public boolean isGroupMember(int n) {
        for (int i = 0; i < this.numberOfGroups; ++i) {
            if (this.groups[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public int[] getGroups() {
        int[] nArray = new int[this.numberOfGroups];
        for (int i = 0; i < this.numberOfGroups; ++i) {
            nArray[i] = this.groups[i];
        }
        return nArray;
    }

    public void setGroupsSet(boolean bl) {
        this.groupsSet = bl;
    }

    public boolean groupsSet() {
        return this.groupsSet;
    }

    public void addMember(GlobalMappingElement globalMappingElement) {
        if (this.members == null) {
            this.members = new Vector();
        }
        this.members.add(globalMappingElement);
    }

    public void addParent(int n, int n2) {
        int n3 = UtilFncs.exists(this.parents, n);
        if (n3 == -1) {
            if (this.parents == null) {
                this.parents = new Vector();
                this.callPathIDSParents = new Vector();
            }
            this.parents.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSParents.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSParents.elementAt(n3);
            if ((n3 = UtilFncs.exists(vector, n2)) == -1) {
                vector.add(new Integer(n2));
            } else {
                System.out.println("addParent(int id,int pathID): Duplicate entry attempt!");
            }
        }
    }

    public Vector getParents() {
        return this.parents;
    }

    public Vector getChildren() {
        return this.children;
    }

    public ListIterator getParentsIterator() {
        return new DataSessionIterator(this.parents);
    }

    public ListIterator getChildrenIterator() {
        return new DataSessionIterator(this.children);
    }

    public ListIterator getCallPathIDParents(int n) {
        int n2 = UtilFncs.exists(this.parents, n);
        return new DataSessionIterator((Vector)this.callPathIDSParents.elementAt(n2));
    }

    public ListIterator getCallPathIDChildren(int n) {
        int n2 = UtilFncs.exists(this.children, n);
        return new DataSessionIterator((Vector)this.callPathIDSChildren.elementAt(n2));
    }

    public void addChild(int n, int n2) {
        int n3 = UtilFncs.exists(this.children, n);
        if (n3 == -1) {
            if (this.children == null) {
                this.children = new Vector();
                this.callPathIDSChildren = new Vector();
            }
            this.children.add(new Integer(n));
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(n2));
            this.callPathIDSChildren.add(vector);
        } else {
            Vector vector = (Vector)this.callPathIDSChildren.elementAt(n3);
            if ((n3 = UtilFncs.exists(vector, n2)) == -1) {
                vector.add(new Integer(n2));
            } else {
                System.out.println("addChild(int id,int pathID): Duplicate entry attempt!");
            }
        }
    }

    public void setCallPathObject(boolean bl) {
        this.callPathObject = bl;
    }

    public boolean isCallPathObject() {
        return this.callPathObject;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        if (this.colorFlag) {
            return this.specificColor;
        }
        return this.color;
    }

    public void setColorFlag(boolean bl) {
        this.colorFlag = bl;
    }

    public boolean isColorFlagSet() {
        return this.colorFlag;
    }

    public void setSpecificColor(Color color) {
        this.specificColor = color;
    }

    public void setMaxInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setMaxExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setMaxInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setMaxExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setMaxNumberOfCalls(int n) {
        this.maxNumberOfCalls = n;
    }

    public int getMaxNumberOfCalls() {
        return this.maxNumberOfCalls;
    }

    public void setMaxNumberOfSubRoutines(int n) {
        this.maxNumberOfSubRoutines = n;
    }

    public int getMaxNumberOfSubRoutines() {
        return this.maxNumberOfSubRoutines;
    }

    public void setMaxUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public void setMaxUserEventNumberValue(int n) {
        this.maxUserEventNumberValue = n;
    }

    public int getMaxUserEventNumberValue() {
        return this.maxUserEventNumberValue;
    }

    public void setMaxUserEventMinValue(double d) {
        this.maxUserEventMinValue = d;
    }

    public double getMaxUserEventMinValue() {
        return this.maxUserEventMinValue;
    }

    public void setMaxUserEventMaxValue(double d) {
        this.maxUserEventMaxValue = d;
    }

    public double getMaxUserEventMaxValue() {
        return this.maxUserEventMaxValue;
    }

    public void setMaxUserEventMeanValue(double d) {
        this.maxUserEventMeanValue = d;
    }

    public double getMaxUserEventMeanValue() {
        return this.maxUserEventMeanValue;
    }

    public void setMeanInclusiveValue(int n, double d) {
        this.insertDouble(n, 5, d);
    }

    public double getMeanInclusiveValue(int n) {
        return this.getDouble(n, 5);
    }

    public void setMeanExclusiveValue(int n, double d) {
        this.insertDouble(n, 6, d);
    }

    public double getMeanExclusiveValue(int n) {
        return this.getDouble(n, 6);
    }

    public void setMeanInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 7, d);
    }

    public double getMeanInclusivePercentValue(int n) {
        return this.getDouble(n, 7);
    }

    public void setMeanExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 8, d);
    }

    public double getMeanExclusivePercentValue(int n) {
        return this.getDouble(n, 8);
    }

    public void setMeanNumberOfCalls(double d) {
        this.meanNumberOfCalls = d;
    }

    public double getMeanNumberOfCalls() {
        return this.meanNumberOfCalls;
    }

    public void setMeanNumberOfSubRoutines(double d) {
        this.meanNumberOfSubRoutines = d;
    }

    public double getMeanNumberOfSubRoutines() {
        return this.meanNumberOfSubRoutines;
    }

    public void setMeanUserSecPerCall(int n, double d) {
        this.insertDouble(n, 9, d);
    }

    public double getMeanUserSecPerCall(int n) {
        return this.getDouble(n, 9);
    }

    public String getMeanTotalStatString(int n, int n2, int n3) {
        try {
            int n4;
            int n5 = 99;
            int n6 = 0;
            char[] cArray = new char[n5];
            this.insertSpaces(cArray, 0, 99);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.applyPattern("##0.0");
            char[] cArray2 = decimalFormat.format(this.getMeanInclusivePercentValue(n2)).toCharArray();
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                cArray[n6] = cArray2[n4];
                ++n6;
            }
            n6 = 9;
            String string = UtilFncs.getOutputString(n, this.getMeanExclusiveValue(n2), n3);
            cArray2 = string.toCharArray();
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                cArray[n6] = cArray2[n4];
                ++n6;
            }
            n6 = 27;
            string = UtilFncs.getOutputString(n, this.getMeanInclusiveValue(n2), n3);
            cArray2 = string.toCharArray();
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                cArray[n6] = cArray2[n4];
                ++n6;
            }
            n6 = 45;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getMeanNumberOfCalls(), n3)));
            cArray2 = string.toCharArray();
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                cArray[n6] = cArray2[n4];
                ++n6;
            }
            n6 = 63;
            string = new String(Double.toString(UtilFncs.adjustDoublePresision(this.getMeanNumberOfSubRoutines(), n3)));
            cArray2 = string.toCharArray();
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                cArray[n6] = cArray2[n4];
                ++n6;
            }
            n6 = 81;
            string = UtilFncs.getOutputString(n, this.getMeanUserSecPerCall(n2), n3);
            cArray2 = string.toCharArray();
            for (n4 = 0; n4 < cArray2.length; ++n4) {
                cArray[n6] = cArray2[n4];
                ++n6;
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GTDE01");
            return "An error occured pocessing this string!";
        }
    }

    public void setMeanValuesSet(boolean bl) {
        this.meanValuesSet = bl;
    }

    public boolean getMeanValuesSet() {
        return this.meanValuesSet;
    }

    public void setTotalInclusiveValue(int n, double d) {
        this.insertDouble(n, 10, d);
    }

    public void incrementTotalInclusiveValue(int n, double d) {
        this.insertDouble(n, 10, this.getDouble(n, 10) + d);
    }

    public double getTotalInclusiveValue(int n) {
        return this.getDouble(n, 10);
    }

    public void setTotalExclusiveValue(int n, double d) {
        this.insertDouble(n, 11, d);
    }

    public void incrementTotalExclusiveValue(int n, double d) {
        this.insertDouble(n, 11, this.getDouble(n, 11) + d);
    }

    public double getTotalExclusiveValue(int n) {
        return this.getDouble(n, 11);
    }

    public void setTotalInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 12, d);
    }

    public double getTotalInclusivePercentValue(int n) {
        return this.getDouble(n, 12);
    }

    public void setTotalExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 13, d);
    }

    public double getTotalExclusivePercentValue(int n) {
        return this.getDouble(n, 13);
    }

    public void setTotalNumberOfCalls(int n) {
        this.totalNumberOfCalls = n;
    }

    public void incrementTotalNumberOfCalls(int n) {
        this.totalNumberOfCalls += n;
    }

    public double getTotalNumberOfCalls() {
        return this.totalNumberOfCalls;
    }

    public void setTotalNumberOfSubRoutines(int n) {
        this.totalNumberOfSubRoutines = n;
    }

    public void incrementTotalNumberOfSubRoutines(int n) {
        this.totalNumberOfSubRoutines += n;
    }

    public double getTotalNumberOfSubRoutines() {
        return this.totalNumberOfSubRoutines;
    }

    public void setTotalUserSecPerCall(int n, double d) {
        this.insertDouble(n, 14, d);
    }

    public double getTotalUserSecPerCall(int n) {
        return this.getDouble(n, 14);
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeg = n;
        this.xEnd = n2;
        this.yBeg = n3;
        this.yEnd = n4;
    }

    public int getXBeg() {
        return this.xBeg;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getYBeg() {
        return this.yBeg;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public int compareTo(Object object) {
        return this.mappingName.compareTo((String)object);
    }

    private void insertDouble(int n, int n2, double d) {
        try {
            this.doubleList[n * 14 + n2] = d;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GME01");
        }
    }

    private double getDouble(int n, int n2) {
        try {
            return this.doubleList[n * 14 + n2];
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GME02");
            return -1.0;
        }
    }

    private int insertSpaces(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[n] = 32;
            ++n;
        }
        return n;
    }
}

