/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.AtomicEvent;
import edu.uoregon.tau.dms.dss.AtomicLocationProfile;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.IntervalEvent;
import edu.uoregon.tau.dms.dss.IntervalLocationProfile;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.NCT;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.ParaProfObserver;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.Trial;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;

public abstract class ParaProfDataSession
extends DataSession
implements Runnable {
    protected Object initializeObject = null;
    private boolean firstMetric = true;
    private boolean groupCheck = false;
    private int totalNumberOfContexts = -1;
    private int totalNumberOfThreads = -1;
    private boolean profileStatsPresent = false;
    private boolean profileCallsPresent = false;
    private boolean aggregatesPresent = false;
    private boolean groupNamesPresent = false;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private int[] maxNCT = null;
    private boolean debug = false;
    private PrintWriter out = null;
    private Vector observers = new Vector();

    public ParaProfDataSession() {
        this.setGlobalMapping(new GlobalMapping());
        this.setNCT(new NCT());
    }

    public ParaProfDataSession(boolean bl) {
        this.debug = bl;
        this.setGlobalMapping(new GlobalMapping());
        this.setNCT(new NCT());
    }

    public void initialize(Object object) {
        this.initializeObject = object;
        java.lang.Thread thread = new java.lang.Thread(this);
        thread.start();
    }

    public void terminate() {
    }

    public ListIterator getApplicationList() {
        return null;
    }

    public ListIterator getExperimentList() {
        return null;
    }

    public ListIterator getTrialList() {
        return null;
    }

    public Application setApplication(int n) {
        return null;
    }

    public Application setApplication(String string, String string2) {
        return null;
    }

    public Experiment setExperiment(int n) {
        return null;
    }

    public Trial setTrial(int n) {
        return null;
    }

    public ListIterator getIntervalEvents() {
        return null;
    }

    public IntervalEvent setIntervalEvent(int n) {
        return null;
    }

    public IntervalEvent getIntervalEvent(int n) {
        return null;
    }

    public ListIterator getAtomicEvents() {
        return null;
    }

    public AtomicEvent setAtomicEvent(int n) {
        return null;
    }

    public AtomicEvent getAtomicEvent(int n) {
        return null;
    }

    public ListIterator getIntervalEventData() {
        return null;
    }

    public ListIterator getAtomicEventData() {
        return null;
    }

    public void getIntervalEventDetail(IntervalEvent intervalEvent) {
    }

    public void getAtomicEventDetail(AtomicEvent atomicEvent) {
    }

    public int saveTrial() {
        return -1;
    }

    public int saveTrial(Trial trial) {
        return -1;
    }

    public int saveIntervalEvent(IntervalEvent intervalEvent, int n, Hashtable hashtable) {
        return -1;
    }

    public void saveIntervalEventData(IntervalLocationProfile intervalLocationProfile, int n, Hashtable hashtable) {
    }

    public int saveAtomicEvent(AtomicEvent atomicEvent, int n) {
        return -1;
    }

    public void saveAtomicEventData(AtomicLocationProfile atomicLocationProfile, int n) {
    }

    public boolean profileStatsPresent() {
        return this.profileStatsPresent;
    }

    public boolean profileCallsPresent() {
        return this.profileCallsPresent();
    }

    public boolean aggregatesPresent() {
        return this.aggregatesPresent;
    }

    public boolean groupNamesPresent() {
        return this.groupNamesPresent;
    }

    public boolean userEventsPresent() {
        return this.userEventsPresent;
    }

    public boolean callPathDataPresent() {
        return this.callPathDataPresent;
    }

    public void setDebug(boolean bl) {
        try {
            this.debug = bl;
            if (bl && this.out == null) {
                Class<?> clazz = this.getClass();
                this.out = new PrintWriter(new FileWriter(new File(clazz.getName() + ".out")));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean debug() {
        return this.debug;
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.maxNCT[i] = 0;
            }
            Enumeration enumeration = this.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                if (node.getNodeID() > this.maxNCT[0]) {
                    this.maxNCT[0] = node.getNodeID();
                }
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    if (context.getContextID() > this.maxNCT[1]) {
                        this.maxNCT[1] = context.getContextID();
                    }
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        if (thread.getThreadID() <= this.maxNCT[2]) continue;
                        this.maxNCT[2] = thread.getThreadID();
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public void setMeanData(int n, int n2) {
        double d;
        if (this.debug()) {
            this.outputToFile("####################################");
            this.outputToFile("Setting mean data :: public void setMeanData(int mappingSelection, int metric)");
        }
        GlobalMapping globalMapping = this.getGlobalMapping();
        ListIterator listIterator = globalMapping.getMappingIterator(n);
        while (listIterator.hasNext()) {
            d = 0.0;
            double d2 = 0.0;
            int n3 = 0;
            int n4 = 0;
            double d3 = 0.0;
            int n5 = 0;
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)listIterator.next();
            int n6 = globalMappingElement.getMappingID();
            Enumeration enumeration = this.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        GlobalThreadDataElement globalThreadDataElement = thread.getFunction(n6);
                        if (globalThreadDataElement != null) {
                            d += globalThreadDataElement.getExclusiveValue(n2);
                            d2 += globalThreadDataElement.getInclusiveValue(n2);
                            n3 += globalThreadDataElement.getNumberOfCalls();
                            n4 += globalThreadDataElement.getNumberOfSubRoutines();
                            d3 += globalThreadDataElement.getUserSecPerCall(n2);
                        }
                        ++n5;
                    }
                }
            }
            if (n5 == 0) continue;
            double d4 = d / (double)n5;
            double d5 = d2 / (double)n5;
            double d6 = n3 / n5;
            double d7 = n4 / n5;
            double d8 = d3 / (double)n5;
            globalMappingElement.setMeanExclusiveValue(n2, d4);
            if (globalMapping.getMaxMeanExclusiveValue(n2) < d4) {
                globalMapping.setMaxMeanExclusiveValue(n2, d4);
            }
            globalMappingElement.setMeanInclusiveValue(n2, d5);
            if (globalMapping.getMaxMeanInclusiveValue(n2) < d5) {
                globalMapping.setMaxMeanInclusiveValue(n2, d5);
            }
            globalMappingElement.setMeanNumberOfCalls(d6);
            if (globalMapping.getMaxMeanNumberOfCalls() < d6) {
                globalMapping.setMaxMeanNumberOfCalls(d6);
            }
            globalMappingElement.setMeanNumberOfSubRoutines(d7);
            if (globalMapping.getMaxMeanNumberOfSubRoutines() < d7) {
                globalMapping.setMaxMeanNumberOfSubRoutines(d7);
            }
            globalMappingElement.setMeanUserSecPerCall(n2, d8);
            if (!(globalMapping.getMaxMeanUserSecPerCall(n2) < d8)) continue;
            globalMapping.setMaxMeanUserSecPerCall(n2, d8);
        }
        listIterator = globalMapping.getMappingIterator(n);
        d = globalMapping.getMaxMeanInclusiveValue(n2);
        while (listIterator.hasNext()) {
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)listIterator.next();
            double d9 = globalMappingElement.getMeanExclusiveValue(n2) / d * 100.0;
            globalMappingElement.setMeanExclusivePercentValue(n2, d9);
            if (globalMapping.getMaxMeanExclusivePercentValue(n2) < d9) {
                globalMapping.setMaxMeanExclusivePercentValue(n2, d9);
            }
            double d10 = globalMappingElement.getMeanInclusiveValue(n2) / d * 100.0;
            globalMappingElement.setMeanInclusivePercentValue(n2, d10);
            if (globalMapping.getMaxMeanInclusivePercentValue(n2) < d10) {
                globalMapping.setMaxMeanInclusivePercentValue(n2, d10);
            }
            globalMappingElement.setMeanValuesSet(true);
        }
        if (this.debug()) {
            this.outputToFile("Done - Setting mean data :: public void setMeanData(int mappingSelection, int metric)");
            this.outputToFile("####################################");
        }
    }

    public void setMeanDataAllMetrics(int n, int n2) {
        int n3;
        int n4;
        if (this.debug()) {
            this.outputToFile("####################################");
            this.outputToFile("Setting mean data :: public void setMeanDataAllMetrics(int mappingSelection, int numberOfMetrics)");
        }
        GlobalMapping globalMapping = this.getGlobalMapping();
        ListIterator listIterator = globalMapping.getMappingIterator(n);
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
            dArray2[i] = 0.0;
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        int n5 = 0;
        int n6 = 0;
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        double[] dArray9 = new double[n2];
        while (listIterator.hasNext()) {
            n5 = 0;
            n6 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                dArray3[n4] = 0.0;
                dArray4[n4] = 0.0;
                dArray5[n4] = 0.0;
                dArray6[n4] = 0.0;
                dArray7[n4] = 0.0;
                dArray8[n4] = 0.0;
            }
            n4 = 0;
            n3 = 0;
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)listIterator.next();
            int n7 = globalMappingElement.getMappingID();
            if (this.debug) {
                this.outputToFile("######");
                this.outputToFile("GlobalMappingElement: " + globalMappingElement.getMappingName());
            }
            Enumeration enumeration = this.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        GlobalThreadDataElement globalThreadDataElement = thread.getFunction(n7);
                        if (globalThreadDataElement != null) {
                            for (int i = 0; i < n2; ++i) {
                                int n8 = i;
                                dArray3[n8] = dArray3[n8] + globalThreadDataElement.getExclusiveValue(i);
                                int n9 = i;
                                dArray4[n9] = dArray4[n9] + globalThreadDataElement.getInclusiveValue(i);
                                if (i == 0) {
                                    n5 += globalThreadDataElement.getNumberOfCalls();
                                    n6 += globalThreadDataElement.getNumberOfSubRoutines();
                                }
                                int n10 = i;
                                dArray5[n10] = dArray5[n10] + globalThreadDataElement.getUserSecPerCall(i);
                                if (!this.debug) continue;
                                this.outputToFile("exclusiveTotal[" + i + "]: " + dArray3[i]);
                                this.outputToFile("inclusiveTotal[" + i + "]: " + dArray4[i]);
                                this.outputToFile("userSecPerCallValueTotal[" + i + "]: " + dArray5[i]);
                            }
                            ++n3;
                        }
                        ++n4;
                    }
                }
            }
            if (this.debug) {
                this.outputToFile("numberOfCallsTotal: " + n5);
                this.outputToFile("numberOfSubroutinesTotal: " + n6);
                this.outputToFile("count: " + n4);
                this.outputToFile("userSecPerCallCount: " + n3);
            }
            globalMappingElement.setTotalNumberOfCalls(n5);
            globalMappingElement.setTotalNumberOfSubRoutines(n6);
            for (int i = 0; i < n2; ++i) {
                globalMappingElement.setTotalExclusiveValue(i, dArray3[i]);
                globalMappingElement.setTotalInclusiveValue(i, dArray4[i]);
                globalMappingElement.setTotalUserSecPerCall(i, dArray5[i]);
                int n11 = i;
                dArray[n11] = dArray[n11] + dArray3[i];
                int n12 = i;
                dArray2[n12] = dArray2[n12] + dArray4[i];
            }
            if (n4 != 0) {
                int n13;
                double d = n5 / n4;
                double d2 = n6 / n4;
                globalMappingElement.setMeanNumberOfCalls(d);
                if (globalMapping.getMaxMeanNumberOfCalls() < d) {
                    globalMapping.setMaxMeanNumberOfCalls(d);
                }
                globalMappingElement.setMeanNumberOfSubRoutines(d2);
                if (globalMapping.getMaxMeanNumberOfSubRoutines() < d2) {
                    globalMapping.setMaxMeanNumberOfSubRoutines(d2);
                }
                for (n13 = 0; n13 < n2; ++n13) {
                    dArray6[n13] = dArray3[n13] / (double)n4;
                    dArray7[n13] = dArray4[n13] / (double)n4;
                    if (this.debug) {
                        this.outputToFile("meanExclusiveValue[" + n13 + "]: " + dArray6[n13]);
                        this.outputToFile("meanInclusiveValue[" + n13 + "]: " + dArray7[n13]);
                    }
                    globalMappingElement.setMeanExclusiveValue(n13, dArray6[n13]);
                    if (globalMapping.getMaxMeanExclusiveValue(n13) < dArray6[n13]) {
                        globalMapping.setMaxMeanExclusiveValue(n13, dArray6[n13]);
                    }
                    globalMappingElement.setMeanInclusiveValue(n13, dArray7[n13]);
                    if (!(globalMapping.getMaxMeanInclusiveValue(n13) < dArray7[n13])) continue;
                    globalMapping.setMaxMeanInclusiveValue(n13, dArray7[n13]);
                }
                if (n3 != 0) {
                    for (n13 = 0; n13 < n2; ++n13) {
                        dArray8[n13] = dArray5[n13] / (double)n3;
                        if (this.debug) {
                            this.outputToFile("meanUserSecPerCallValue[" + n13 + "]: " + dArray8[n13]);
                        }
                        globalMappingElement.setMeanUserSecPerCall(n13, dArray8[n13]);
                        if (!(globalMapping.getMaxMeanUserSecPerCall(n13) < dArray8[n13])) continue;
                        globalMapping.setMaxMeanUserSecPerCall(n13, dArray8[n13]);
                    }
                }
                if (this.debug) {
                    this.outputToFile("meanNumberOfCalls: " + d);
                    this.outputToFile("meanNumberOfSubroutines: " + d2);
                }
            }
            if (!this.debug) continue;
            this.outputToFile("Done - GlobalMappingElement: " + globalMappingElement.getMappingName());
            this.outputToFile("######");
        }
        for (n4 = 0; n4 < n2; ++n4) {
            dArray9[n4] = globalMapping.getMaxMeanInclusiveValue(n4);
            if (!this.debug) continue;
            this.outputToFile("maxMeanInclusiveValue[" + n4 + "]: " + dArray9[n4]);
        }
        listIterator = globalMapping.getMappingIterator(n);
        while (listIterator.hasNext()) {
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)listIterator.next();
            if (this.debug) {
                this.outputToFile("######");
                this.outputToFile("GlobalMappingElement: " + globalMappingElement.getMappingName() + "(Percent)");
            }
            for (n3 = 0; n3 < n2; ++n3) {
                double d = 0.0;
                if (dArray9[n3] != 0.0) {
                    d = globalMappingElement.getMeanExclusiveValue(n3) / dArray9[n3] * 100.0;
                }
                globalMappingElement.setMeanExclusivePercentValue(n3, d);
                if (globalMapping.getMaxMeanExclusivePercentValue(n3) < d) {
                    globalMapping.setMaxMeanExclusivePercentValue(n3, d);
                }
                double d3 = 0.0;
                if (dArray9[n3] != 0.0) {
                    d3 = globalMappingElement.getMeanInclusiveValue(n3) / dArray9[n3] * 100.0;
                }
                globalMappingElement.setMeanInclusivePercentValue(n3, d3);
                if (globalMapping.getMaxMeanInclusivePercentValue(n3) < d3) {
                    globalMapping.setMaxMeanInclusivePercentValue(n3, d3);
                }
                if (this.debug) {
                    this.outputToFile("meanExclusivePercentValue[" + n3 + "]: " + d);
                    this.outputToFile("meanInclusivePercentValue[" + n3 + "]: " + d3);
                }
                if (dArray[n3] != 0.0) {
                    globalMappingElement.setTotalExclusivePercentValue(n3, globalMappingElement.getTotalExclusiveValue(n3) / dArray[n3] * 100.0);
                } else {
                    globalMappingElement.setTotalExclusivePercentValue(n3, 0.0);
                }
                if (dArray2[n3] != 0.0) {
                    globalMappingElement.setTotalInclusivePercentValue(n3, globalMappingElement.getTotalInclusiveValue(n3) / dArray2[n3] * 100.0);
                    continue;
                }
                globalMappingElement.setTotalInclusivePercentValue(n3, 0.0);
            }
            globalMappingElement.setMeanValuesSet(true);
            if (!this.debug) continue;
            this.outputToFile("Done - GlobalMappingElement: " + globalMappingElement.getMappingName() + "(Percent)");
            this.outputToFile("######");
        }
        if (this.debug()) {
            this.outputToFile("Done - Setting mean data :: public void setMeanDataAllMetrics(int mappingSelection, int numberOfMetrics)");
            this.outputToFile("####################################");
        }
    }

    public void addObserver(ParaProfObserver paraProfObserver) {
        this.observers.add(paraProfObserver);
    }

    public void removeObserver(ParaProfObserver paraProfObserver) {
        this.observers.remove(paraProfObserver);
    }

    public void notifyObservers() {
        Enumeration enumeration;
        if (this.debug()) {
            System.out.println("######");
            System.out.println("ParaProfDataSession.notifyObservers()");
            System.out.println("Listening classes ...");
            enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                System.out.println(enumeration.nextElement().getClass());
            }
            System.out.println("######");
        }
        enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((ParaProfObserver)enumeration.nextElement()).update(this);
        }
    }

    protected Metric addMetric(String string) {
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    protected void setProfileStatsPresent(boolean bl) {
        this.profileStatsPresent = bl;
    }

    protected void setProfileCallsPresent(boolean bl) {
        this.profileCallsPresent = bl;
    }

    protected void setAggregatesPresent(boolean bl) {
        this.aggregatesPresent = bl;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    protected void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    protected void setFirstMetric(boolean bl) {
        this.firstMetric = bl;
    }

    protected boolean firstMetric() {
        return this.firstMetric;
    }

    protected void setGroupCheck(boolean bl) {
        this.groupCheck = bl;
    }

    protected boolean groupCheck() {
        return this.groupCheck;
    }

    protected void outputToFile(String string) {
        if (this.out != null) {
            this.out.println(string);
        }
    }

    protected void flushDebugFileBuffer() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected void closeDebugFile() {
        if (this.out != null) {
            this.out.close();
        }
    }
}

