/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import viewer.common.Const;
import viewer.common.Parameters;
import viewer.common.PreferenceFrame;
import viewer.common.TopWindow;

public class PreviewStateComboBox
extends JComboBox {
    private JButton canvas_redraw_btn;
    private PreferenceFrame pref_frame;

    public PreviewStateComboBox() {
        super.setFont(Const.FONT);
        super.setEditable(false);
        super.addItem("FitMostLegends");
        super.addItem("OverlapInclusionRatio");
        super.addItem("CumulativeInclusionRatio");
        super.addItem("OverlapExclusionRatio");
        super.addItem("CumulativeExclusionRatio");
        super.addItem("BaseAlignedCumulativeExclusionRatio");
        super.setToolTipText("Display options for the Preview state.");
        this.canvas_redraw_btn = null;
        this.pref_frame = null;
    }

    public void addRedrawListener(JButton jButton) {
        this.canvas_redraw_btn = jButton;
        super.addActionListener(new PreviewModeActionListener());
        this.pref_frame = (PreferenceFrame)TopWindow.Preference.getWindow();
    }

    public void init() {
        super.setSelectedItem(Parameters.PREVIEW_STATE_DISPLAY);
    }

    private class PreviewModeActionListener
    implements ActionListener {
        private PreviewModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Parameters.PREVIEW_STATE_DISPLAY = string = (String)PreviewStateComboBox.this.getSelectedItem();
            PreviewStateComboBox.this.pref_frame.updateAllFieldsFromParameters();
            PreviewStateComboBox.this.canvas_redraw_btn.doClick();
        }
    }
}

