/*
 * Decompiled with CFR 0.152.
 */
package TauIL.interpreter;

import TauIL.interpreter.DataSource;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.TauPprofDataSource;
import edu.uoregon.tau.dms.dss.Thread;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

class ProfileDataSource
extends DataSource {
    private Function event;
    private edu.uoregon.tau.dms.dss.DataSource data;
    private Vector files = new Vector();
    private File[] source_file = new File[1];
    private Iterator iterator;
    private boolean time_metric = true;
    private boolean loading = false;

    protected ProfileDataSource() {
        this("pprof.dat");
    }

    protected ProfileDataSource(String string) {
        this.setFile(string);
    }

    protected void setFile(String string) {
        this.source_file[0] = string == null || string.equals("") ? new File("pprof.dat") : new File(string);
    }

    protected void load() {
        this.files.add(this.source_file);
        this.data = new TauPprofDataSource((Object)this.files);
        try {
            this.data.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        this.iterator = this.data.getFunctions();
    }

    protected boolean isTimeMetric() {
        return this.time_metric;
    }

    protected boolean hasNext() {
        return this.iterator.hasNext();
    }

    protected void next() {
        this.event = (Function)this.iterator.next();
    }

    protected void reset() {
        this.iterator = this.data.getFunctions();
    }

    protected String getEventName() {
        return this.event.getName();
    }

    protected double getNumCalls() {
        double d = 0.0;
        Iterator iterator = this.data.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    FunctionProfile functionProfile = thread.getFunctionProfile(this.event);
                    if (functionProfile == null) continue;
                    d = Math.max(d, functionProfile.getNumCalls());
                }
            }
        }
        return d;
    }

    protected double getNumSubRS() {
        double d = 0.0;
        Iterator iterator = this.data.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    FunctionProfile functionProfile = thread.getFunctionProfile(this.event);
                    if (functionProfile == null) continue;
                    d = Math.max(d, functionProfile.getNumSubr());
                }
            }
        }
        return d;
    }

    protected double getPercent() {
        return this.event.getMeanInclusivePercent(0);
    }

    protected double getUsec() {
        return this.getExclusiveValue();
    }

    protected double getCount() {
        return this.getExclusiveValue();
    }

    protected double getExclusiveValue() {
        return this.event.getTotalExclusive(0);
    }

    protected double getCumUsec() {
        return this.getInclusiveValue();
    }

    protected double getTotCount() {
        return this.getInclusiveValue();
    }

    protected double getInclusiveValue() {
        return this.event.getTotalInclusive(0);
    }

    protected double getStdDev() {
        return 0.0;
    }

    protected double getUsecsPerCall() {
        return this.getPerCall();
    }

    protected double getCountsPerCall() {
        return this.getPerCall();
    }

    protected double getPerCall() {
        return this.event.getMeanInclusivePerCall(0);
    }
}

