/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.LineData;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class GprofOutputSession
extends ParaProfDataSession {
    private int indexStart = 0;
    private int percentStart = 0;
    private int selfStart = 0;
    private int descendantsStart = 0;
    private int calledStart = 0;
    private int nameStart = 0;
    private boolean fixNames = false;

    public GprofOutputSession(boolean bl) {
        this.setMetrics(new Vector());
        this.fixNames = bl;
    }

    public void initialize(Object object) {
        try {
            long l = System.currentTimeMillis();
            Object var4_4 = null;
            GlobalThreadDataElement globalThreadDataElement = null;
            Node node = null;
            Context context = null;
            Thread thread = null;
            int n = -1;
            String string = null;
            Object var11_11 = null;
            Object var12_12 = null;
            int n2 = -1;
            int n3 = -1;
            GlobalMappingElement globalMappingElement = null;
            Object var18_16 = null;
            Vector vector = null;
            File[] fileArray = null;
            System.out.println("In the GprofOutputSession");
            vector = (Vector)object;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                fileArray = (File[])enumeration.nextElement();
                for (int i = 0; i < Array.getLength(fileArray); ++i) {
                    System.out.println("Processing " + fileArray[i] + ", please wait ......");
                    FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                    InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    this.getGlobalMapping().increaseVectorStorage();
                    node = this.getNCT().addNode(++n);
                    context = node.addContext(0);
                    thread = context.addThread(0);
                    thread.setDebug(this.debug());
                    if (this.debug()) {
                        this.outputToFile("n,c,t: " + n + "," + 0 + "," + 0);
                    }
                    thread.initializeFunctionList(this.getGlobalMapping().getNumberOfMappings(0));
                    this.addMetric("Time");
                    if (this.debug()) {
                        System.out.println("metric name: Time");
                        this.outputToFile("metric name: Time");
                    }
                    boolean bl = false;
                    boolean bl2 = true;
                    Vector<LineData> vector2 = new Vector<LineData>();
                    LineData lineData = null;
                    Vector<LineData> vector3 = new Vector<LineData>();
                    while ((string = bufferedReader.readLine()) != null) {
                        int n4 = string.length();
                        if (n4 != 0) {
                            int n5 = string.indexOf("granularity: ");
                            if (n5 == 0 || n5 == 1) {
                                bl = !bl;
                            }
                            if (bl) {
                                if (string.indexOf("index") == 0 && string.indexOf("time") >= 0 && string.indexOf("self") >= 0 && string.indexOf("called") >= 0 && string.indexOf("name") >= 0) {
                                    this.getFieldLengths(string);
                                } else if (string.charAt(0) == '[') {
                                    lineData = this.getSelfLineData(string);
                                    bl2 = false;
                                } else if (string.charAt(0) == '-') {
                                    String string2;
                                    LineData lineData2;
                                    int n6;
                                    n2 = this.getGlobalMapping().addGlobalMapping(lineData.s0, 0, 1);
                                    globalMappingElement = this.getGlobalMapping().getGlobalMappingElement(n2, 0);
                                    globalThreadDataElement = new GlobalThreadDataElement(this.getGlobalMapping().getGlobalMappingElement(globalMappingElement.getMappingID(), 0), false);
                                    thread.addFunction(globalThreadDataElement, globalMappingElement.getMappingID());
                                    globalThreadDataElement.setInclusiveValue(0, lineData.d1 + lineData.d2);
                                    globalThreadDataElement.setExclusiveValue(0, lineData.d1);
                                    globalThreadDataElement.setNumberOfCalls(lineData.i0);
                                    globalThreadDataElement.setNumberOfSubRoutines(vector3.size());
                                    int n7 = vector2.size();
                                    for (n6 = 0; n6 < n7; ++n6) {
                                        lineData2 = (LineData)vector2.elementAt(n6);
                                        n2 = this.getGlobalMapping().addGlobalMapping(lineData2.s0, 0, 1);
                                        string2 = lineData2.s0 + " => " + lineData.s0 + "  ";
                                        n3 = this.getGlobalMapping().addGlobalMapping(lineData2.s0 + " => " + lineData.s0 + "  ", 0, 1);
                                        this.getGlobalMapping().getGlobalMappingElement(n3, 0).setCallPathObject(true);
                                        globalThreadDataElement = new GlobalThreadDataElement(this.getGlobalMapping().getGlobalMappingElement(n3, 0), false);
                                        thread.addFunction(globalThreadDataElement, n3);
                                        globalThreadDataElement.setInclusiveValue(0, lineData2.d0 + lineData2.d1);
                                        globalThreadDataElement.setExclusiveValue(0, lineData2.d0);
                                        globalThreadDataElement.setNumberOfCalls(lineData2.i0);
                                    }
                                    vector2.clear();
                                    n7 = vector3.size();
                                    for (n6 = 0; n6 < n7; ++n6) {
                                        lineData2 = (LineData)vector3.elementAt(n6);
                                        n2 = this.getGlobalMapping().addGlobalMapping(lineData2.s0, 0, 1);
                                        string2 = lineData.s0 + " => " + lineData2.s0 + "  ";
                                        n3 = this.getGlobalMapping().addGlobalMapping(lineData.s0 + " => " + lineData2.s0 + "  ", 0, 1);
                                        this.getGlobalMapping().getGlobalMappingElement(n3, 0).setCallPathObject(true);
                                        globalThreadDataElement = new GlobalThreadDataElement(this.getGlobalMapping().getGlobalMappingElement(n3, 0), false);
                                        thread.addFunction(globalThreadDataElement, n3);
                                        globalThreadDataElement.setInclusiveValue(0, lineData2.d0 + lineData2.d1);
                                        globalThreadDataElement.setExclusiveValue(0, lineData2.d0);
                                        globalThreadDataElement.setNumberOfCalls(lineData2.i0);
                                    }
                                    vector3.clear();
                                    bl2 = true;
                                } else if (string.charAt(n4 - 1) == ']') {
                                    if (string.indexOf("<cycle") >= 0) {
                                        if (bl2) {
                                            vector2.add(this.getParentChildLineData(string));
                                        } else {
                                            vector3.add(this.getParentChildLineData(string));
                                        }
                                    } else if (bl2) {
                                        vector2.add(this.getParentChildLineData(string));
                                    } else {
                                        vector3.add(this.getParentChildLineData(string));
                                    }
                                }
                            } else if (string.charAt(n4 - 1) == ']') {
                                // empty if block
                            }
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                    }
                }
            }
            this.generateDerivedData(0);
            if (CallPathUtilFuncs.isAvailable(this.getGlobalMapping().getMappingIterator(0))) {
                this.setCallPathDataPresent(true);
                CallPathUtilFuncs.buildRelations(this.getGlobalMapping());
            }
            l = System.currentTimeMillis() - l;
            System.out.println("Done processing data!");
            System.out.println("Time to process (in milliseconds): " + l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UtilFncs.systemError(exception, null, "GOS01");
        }
    }

    private void getFieldLengths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string3.compareTo("%") == 0) {
            string3 = string3 + " " + stringTokenizer.nextToken();
        }
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        this.indexStart = string.indexOf(string2);
        this.percentStart = string.indexOf(string3);
        this.selfStart = string.indexOf(string3) + string3.length() + 1;
        this.descendantsStart = string.indexOf(string4) + string4.length() + 1;
        this.calledStart = string.indexOf(string5) + string5.length() + 1;
        this.nameStart = string.indexOf(string7);
    }

    private LineData getSelfLineData(String string) {
        LineData lineData = new LineData();
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            int n = stringTokenizer.countTokens();
            stringTokenizer.nextToken();
            lineData.d0 = Double.parseDouble(stringTokenizer.nextToken());
            lineData.d1 = 1000.0 * Double.parseDouble(stringTokenizer.nextToken());
            lineData.d2 = 1000.0 * Double.parseDouble(stringTokenizer.nextToken());
            if (n < 7) {
                lineData.i0 = 1;
            } else {
                string2 = stringTokenizer.nextToken();
                if (string2.indexOf("+") < 0) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "+");
                    lineData.i0 = Integer.parseInt(stringTokenizer2.nextToken());
                }
            }
            lineData.s0 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.indexOf("[") == 0 || string2.endsWith("]")) continue;
                lineData.s0 = lineData.s0 + " " + string2;
            }
            lineData.s0 = this.fix(lineData.s0);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GOS02");
        }
        return lineData;
    }

    private LineData getParentChildLineData(String string) {
        LineData lineData = new LineData();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            String string2 = string.substring(this.selfStart, this.descendantsStart).trim();
            lineData.d0 = string2.length() > 0 ? Double.parseDouble(string2) : 0.0;
            string2 = string.substring(this.descendantsStart, this.calledStart).trim();
            lineData.d1 = string2.length() > 0 ? 1000.0 * Double.parseDouble(string2) : 0.0;
            String string3 = string.substring(this.calledStart, string.length()).trim();
            int n = string3.indexOf(" ");
            string2 = n > this.nameStart - this.calledStart ? string3.substring(0, n).trim() : string.substring(this.calledStart, this.nameStart).trim();
            if (string2.indexOf("/") >= 0) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
                lineData.i0 = Integer.parseInt(stringTokenizer2.nextToken());
                lineData.i1 = Integer.parseInt(stringTokenizer2.nextToken());
            } else {
                lineData.i1 = lineData.i0 = Integer.parseInt(string2);
            }
            if (n > this.nameStart - this.calledStart) {
                int n2 = string3.lastIndexOf("[") - 1;
                lineData.s0 = string3.substring(n, n2).trim();
            } else {
                int n3 = string.lastIndexOf("[") - 1;
                lineData.s0 = string.substring(this.nameStart, n3).trim();
            }
            lineData.s0 = this.fix(lineData.s0);
        }
        catch (Exception exception) {
            System.out.println("***\n" + string + "\n***");
            exception.printStackTrace();
            UtilFncs.systemError(exception, null, "GOS03");
        }
        return lineData;
    }

    private LineData getSummaryLineData(String string) {
        LineData lineData = new LineData();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            lineData.d0 = Double.parseDouble(stringTokenizer.nextToken());
            lineData.d1 = 1000.0 * Double.parseDouble(stringTokenizer.nextToken());
            lineData.d2 = 1000.0 * Double.parseDouble(stringTokenizer.nextToken());
            if (stringTokenizer.countTokens() > 5) {
                lineData.i0 = Integer.parseInt(stringTokenizer.nextToken());
                lineData.d3 = Double.parseDouble(stringTokenizer.nextToken());
                lineData.d4 = Double.parseDouble(stringTokenizer.nextToken());
            } else {
                lineData.i0 = 1;
                lineData.d3 = lineData.d2;
                lineData.d4 = lineData.d2;
            }
            lineData.s0 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.indexOf("[") == 0 || string2.endsWith("]")) continue;
                lineData.s0 = lineData.s0 + " " + string2;
            }
            lineData.s0 = this.fix(lineData.s0);
        }
        catch (Exception exception) {
            System.out.println(string);
            UtilFncs.systemError(exception, null, "GOS04");
        }
        return lineData;
    }

    private String fix(String string) {
        String string2 = string;
        if (this.fixNames) {
            if (string.indexOf(".") == 0) {
                string2 = string.substring(1, string.length());
            } else if (string.endsWith("_")) {
                string2 = string.substring(0, string.length() - 1);
            }
        }
        return string2;
    }
}

