/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.LineData;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class HPMToolkitDataSession
extends ParaProfDataSession {
    private int metric = 0;
    private GlobalMappingElement globalMappingElement = null;
    private GlobalThreadDataElement globalThreadDataElement = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private int timeMetric = -1;
    private String inputString = null;
    private String s1 = null;
    private String s2 = null;
    private String tokenString;
    private String groupNamesString = null;
    private StringTokenizer genericTokenizer;
    private int mappingID = -1;
    private Vector v = null;
    private File[] files = null;
    private BufferedReader br = null;
    boolean initialized = false;
    Hashtable eventNames = new Hashtable();
    private LineData header1 = new LineData();
    private LineData header2 = new LineData();
    private LineData header3 = new LineData();
    private LineData header4 = new LineData();
    private LineData header5 = new LineData();

    public HPMToolkitDataSession() {
        this.setMetrics(new Vector());
    }

    public void initialize(Object object) {
        boolean bl = true;
        try {
            this.v = (Vector)object;
            Enumeration enumeration = this.v.elements();
            while (enumeration.hasMoreElements()) {
                this.files = (File[])enumeration.nextElement();
                for (int i = 0; i < this.files.length; ++i) {
                    System.out.println("Processing data file, please wait ......");
                    long l = System.currentTimeMillis();
                    FileInputStream fileInputStream = new FileInputStream(this.files[i]);
                    InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                    this.br = new BufferedReader(inputStreamReader);
                    ++this.nodeID;
                    this.eventNames = new Hashtable();
                    this.inputString = this.br.readLine();
                    if (this.inputString == null) {
                        return;
                    }
                    while ((this.inputString = this.br.readLine()) != null && !this.inputString.trim().startsWith("Instrumented section:")) {
                    }
                    boolean bl2 = true;
                    boolean bl3 = false;
                    while (this.inputString != null) {
                        if (this.inputString.length() != 0) {
                            if (this.inputString.trim().startsWith("Instrumented section:")) {
                                if (!bl2 && !bl3) {
                                    this.globalThreadDataElement.setExclusiveValue(this.timeMetric, this.globalThreadDataElement.getInclusiveValue(this.timeMetric));
                                    if (this.globalThreadDataElement.getExclusiveValue(this.timeMetric) > this.globalMappingElement.getMaxExclusiveValue(this.timeMetric)) {
                                        this.globalMappingElement.setMaxExclusiveValue(this.timeMetric, this.globalThreadDataElement.getExclusiveValue(this.timeMetric));
                                    }
                                }
                                bl2 = false;
                                bl3 = false;
                                this.processHeaderLine1(this.inputString);
                            } else if (this.inputString.trim().startsWith("file:")) {
                                this.processHeaderLine2(this.inputString);
                            } else if (this.inputString.trim().startsWith("Count:")) {
                                this.processHeaderLine3(this.inputString);
                            } else if (this.inputString.trim().startsWith("Wall Clock Time:")) {
                                this.processTime(this.inputString, true);
                            } else if (this.inputString.trim().startsWith("Average duration:")) {
                                this.processHeaderLine4(this.inputString, 1);
                            } else if (this.inputString.trim().startsWith("Standard deviation:")) {
                                this.processHeaderLine4(this.inputString, 2);
                            } else if (this.inputString.trim().startsWith("Exclusive duration:")) {
                                this.processTime(this.inputString, false);
                                bl3 = true;
                            } else if (this.inputString.trim().startsWith("Total time in user mode:")) {
                                this.processHardwareCounter(this.inputString);
                            } else {
                                this.processHardwareCounter(this.inputString);
                            }
                        }
                        this.inputString = this.br.readLine();
                    }
                    if (!bl2 && !bl3) {
                        this.globalThreadDataElement.setExclusiveValue(this.timeMetric, this.globalThreadDataElement.getInclusiveValue(this.timeMetric));
                        if (this.globalThreadDataElement.getExclusiveValue(this.timeMetric) > this.globalMappingElement.getMaxExclusiveValue(this.timeMetric)) {
                            this.globalMappingElement.setMaxExclusiveValue(this.timeMetric, this.globalThreadDataElement.getExclusiveValue(this.timeMetric));
                        }
                    }
                    this.br.close();
                    if (UtilFncs.debug) {
                        System.out.println("The total number of threads is: " + this.getNCT().getTotalNumberOfThreads());
                        System.out.println("The number of mappings is: " + this.getGlobalMapping().getNumberOfMappings(0));
                        System.out.println("The number of user events is: " + this.getGlobalMapping().getNumberOfMappings(2));
                    }
                    this.setFirstMetric(false);
                    l = System.currentTimeMillis() - l;
                    System.out.println("Done processing data file!");
                    System.out.println("Time to process file (in milliseconds): " + l);
                }
            }
            this.generateDerivedData(0);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "SSD01");
        }
    }

    private void initializeThread() {
        this.mappingID = this.header2.s1 == null ? this.getGlobalMapping().addGlobalMapping(this.header1.s0 + ", " + this.header2.s0, 0, 1) : this.getGlobalMapping().addGlobalMapping(this.header1.s0 + ", " + this.header2.s0 + " lines " + this.header2.s1, 0, 1);
        this.globalMappingElement = this.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0);
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.node = this.getNCT().getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.getNCT().addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
            this.thread.setDebug(this.debug());
            this.thread.initializeFunctionList(this.getGlobalMapping().getNumberOfMappings(0));
            this.thread.initializeUsereventList(this.getGlobalMapping().getNumberOfMappings(2));
        }
        this.globalThreadDataElement = this.thread.getFunction(this.mappingID);
        if (this.globalThreadDataElement == null) {
            this.globalThreadDataElement = new GlobalThreadDataElement(this.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0), false);
            this.thread.addFunction(this.globalThreadDataElement, this.mappingID);
        }
        this.initialized = true;
    }

    private void processHeaderLine1(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
            string = stringTokenizer2.nextToken();
            this.header1.i0 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            string = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string, ":");
            string = stringTokenizer2.nextToken();
            this.header1.s0 = stringTokenizer2.nextToken().trim();
            string = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string, ":");
            string = stringTokenizer2.nextToken();
            this.header1.i1 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            if (this.eventNames.containsKey(this.header1.s0)) {
                Integer n = (Integer)this.eventNames.get(this.header1.s0);
                this.threadID = n;
                ++this.threadID;
                this.eventNames.put(this.header1.s0, new Integer(this.threadID));
            } else {
                this.threadID = 0;
                this.eventNames.put(this.header1.s0, new Integer(this.threadID));
            }
            this.initialized = false;
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processHeaderLine2(String string) {
        this.header2.s0 = null;
        this.header2.s1 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
            string = stringTokenizer2.nextToken();
            this.header2.s0 = stringTokenizer2.nextToken().trim();
            string = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string, ":");
            string = stringTokenizer2.nextToken();
            this.header2.s1 = stringTokenizer2.nextToken().trim();
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processHeaderLine3(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            string = stringTokenizer.nextToken();
            this.header3.i0 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processHeaderLine4(String string, int n) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
            if (n == 0) {
                this.header4.d0 = Double.parseDouble(stringTokenizer2.nextToken());
            } else if (n == 1) {
                this.header4.d1 = Double.parseDouble(stringTokenizer2.nextToken());
            } else if (n == 2) {
                this.header4.d2 = Double.parseDouble(stringTokenizer2.nextToken());
            } else if (n == 3) {
                this.header4.d3 = Double.parseDouble(stringTokenizer2.nextToken());
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processHeaderLine5(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
            this.header5.d0 = Double.parseDouble(stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
        this.initializeThread();
    }

    private void processHardwareCounter(String string) {
        if (!this.initialized) {
            if (this.header2.s0 == null) {
                this.header2.s0 = new String("Entire Program");
            }
            if (this.header3.i0 == 0) {
                this.header3.i0 = 1;
            }
            this.initializeThread();
        } else {
            this.globalMappingElement.incrementStorage();
            this.globalThreadDataElement.incrementStorage();
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            int n = 0;
            int n2 = 0;
            stringTokenizer = new StringTokenizer(string3, " ");
            double d = 0.0;
            int n3 = 0;
            string3 = stringTokenizer.nextToken().trim();
            boolean bl = false;
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + " (" + stringTokenizer.nextToken() + ")";
            }
            Metric metric = this.addMetric(string2);
            this.metric = metric.getID();
            n2 = this.getNumberOfMetrics();
            for (n = this.getNumberOfMetrics(); n < n2; ++n) {
                this.getGlobalMapping().increaseVectorStorage();
            }
            while (this.thread.getNumberOfMetrics() < n2) {
                this.thread.incrementStorage();
            }
            while (this.globalMappingElement.getStorageSize() < n2) {
                this.globalMappingElement.incrementStorage();
            }
            while (this.globalThreadDataElement.getStorageSize() < n2) {
                this.globalThreadDataElement.incrementStorage();
            }
            if (bl) {
                this.globalThreadDataElement.setExclusiveValue(this.metric, d);
                this.globalThreadDataElement.setInclusiveValue(this.metric, d);
                double d2 = d / (double)this.header3.i0;
                this.globalThreadDataElement.setUserSecPerCall(this.metric, d2);
                if (this.globalMappingElement.getMaxExclusiveValue(this.metric) < d) {
                    this.globalMappingElement.setMaxExclusiveValue(this.metric, d);
                    this.globalMappingElement.setMaxInclusiveValue(this.metric, d);
                }
                if (this.globalMappingElement.getMaxUserSecPerCall(this.metric) < d / (double)this.header3.i0) {
                    this.globalMappingElement.setMaxUserSecPerCall(this.metric, d / (double)this.header3.i0);
                }
            } else {
                this.globalThreadDataElement.setExclusiveValue(this.metric, n3);
                this.globalThreadDataElement.setInclusiveValue(this.metric, n3);
                double d3 = (double)n3 / (double)this.header3.i0;
                this.globalThreadDataElement.setUserSecPerCall(this.metric, d3);
                if (this.globalMappingElement.getMaxExclusiveValue(this.metric) < (double)n3) {
                    this.globalMappingElement.setMaxExclusiveValue(this.metric, n3);
                    this.globalMappingElement.setMaxInclusiveValue(this.metric, n3);
                }
                if (this.globalMappingElement.getMaxUserSecPerCall(this.metric) < (double)(n3 / this.header3.i0)) {
                    this.globalMappingElement.setMaxUserSecPerCall(this.metric, n3 / this.header3.i0);
                }
            }
            this.globalThreadDataElement.setExclusivePercentValue(this.metric, 0.0);
            this.globalThreadDataElement.setInclusivePercentValue(this.metric, 0.0);
            this.globalThreadDataElement.setNumberOfCalls(this.header3.i0);
            this.globalThreadDataElement.setNumberOfSubRoutines(0);
            this.globalMappingElement.setMaxExclusivePercentValue(this.metric, 0.0);
            this.globalMappingElement.setMaxInclusivePercentValue(this.metric, 0.0);
            if (this.globalMappingElement.getMaxNumberOfCalls() < this.header3.i0) {
                this.globalMappingElement.setMaxNumberOfCalls(this.header3.i0);
            }
            this.globalMappingElement.setMaxNumberOfSubRoutines(0);
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the callsite data!");
            exception.printStackTrace();
        }
    }

    private void processTime(String string, boolean bl) {
        if (!this.initialized) {
            if (this.header2.s0 == null) {
                this.header2.s0 = new String("Entire Program");
            }
            if (this.header3.i0 == 0) {
                this.header3.i0 = 1;
            }
            this.initializeThread();
        } else {
            this.globalMappingElement.incrementStorage();
            this.globalThreadDataElement.incrementStorage();
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string2 = stringTokenizer.nextToken().trim();
            string2 = "Time";
            String string3 = stringTokenizer.nextToken().trim();
            int n = 0;
            int n2 = 0;
            stringTokenizer = new StringTokenizer(string3, " ");
            double d = 0.0;
            boolean bl2 = false;
            string3 = stringTokenizer.nextToken().trim();
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            Metric metric = this.addMetric(string2);
            this.timeMetric = this.metric = metric.getID();
            n2 = this.getNumberOfMetrics();
            for (n = this.getNumberOfMetrics(); n < n2; ++n) {
                this.getGlobalMapping().increaseVectorStorage();
            }
            while (this.thread.getNumberOfMetrics() < n2) {
                this.thread.incrementStorage();
            }
            while (this.globalMappingElement.getStorageSize() < n2) {
                this.globalMappingElement.incrementStorage();
            }
            while (this.globalThreadDataElement.getStorageSize() < n2) {
                this.globalThreadDataElement.incrementStorage();
            }
            d = d * 1000.0 * 1000.0;
            if (bl) {
                this.globalThreadDataElement.setInclusiveValue(this.metric, d);
            } else {
                this.globalThreadDataElement.setExclusiveValue(this.metric, d);
            }
            double d2 = d / (double)this.header3.i0;
            this.globalThreadDataElement.setUserSecPerCall(this.metric, d2);
            if (bl) {
                if (this.globalMappingElement.getMaxInclusiveValue(this.metric) < d) {
                    this.globalMappingElement.setMaxInclusiveValue(this.metric, d);
                }
            } else if (this.globalMappingElement.getMaxExclusiveValue(this.metric) < d) {
                this.globalMappingElement.setMaxExclusiveValue(this.metric, d);
            }
            if (this.globalMappingElement.getMaxUserSecPerCall(this.metric) < d / (double)this.header3.i0) {
                this.globalMappingElement.setMaxUserSecPerCall(this.metric, d / (double)this.header3.i0);
            }
            this.globalThreadDataElement.setExclusivePercentValue(this.metric, 0.0);
            this.globalThreadDataElement.setInclusivePercentValue(this.metric, 0.0);
            this.globalThreadDataElement.setNumberOfCalls(this.header3.i0);
            this.globalThreadDataElement.setNumberOfSubRoutines(0);
            this.globalMappingElement.setMaxExclusivePercentValue(this.metric, 0.0);
            this.globalMappingElement.setMaxInclusivePercentValue(this.metric, 0.0);
            if (this.globalMappingElement.getMaxNumberOfCalls() < this.header3.i0) {
                this.globalMappingElement.setMaxNumberOfCalls(this.header3.i0);
            }
            this.globalMappingElement.setMaxNumberOfSubRoutines(0);
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the wall clock time!");
            exception.printStackTrace();
        }
    }

    private String getMetricName(String string) {
        try {
            String string2 = null;
            int n = string.indexOf("_MULTI_");
            if (n > 0) {
                string2 = string.substring(n + 7);
                return string2;
            }
            return string2;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "SSD26");
            return null;
        }
    }
}

