/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.MappingDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.UserEventWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class StatWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 800;
    private int yPanelSize = 600;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    private int startLocation = 0;
    private int maxFontAscent = 0;
    private int maxFontDescent = 0;
    private int spacing = 0;
    private ParaProfTrial trial = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private StatWindow sWindow = null;
    private int windowType = -1;
    private Vector list = null;
    private Font monoFont = null;
    private FontMetrics fmMonoFont = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;
    private boolean debug = false;

    public StatWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SWP01");
        }
    }

    public StatWindowPanel(ParaProfTrial paraProfTrial, int n, int n2, int n3, StatWindow statWindow, int n4, boolean bl) {
        try {
            JMenuItem jMenuItem;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.trial = paraProfTrial;
            this.nodeID = n;
            this.contextID = n2;
            this.threadID = n3;
            this.sWindow = statWindow;
            this.windowType = n4;
            this.debug = bl;
            this.addMouseListener(this);
            if (n4 == 2) {
                jMenuItem = new JMenuItem("Show Userevent Details");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem("Change Userevent Color");
                jMenuItem2.addActionListener(this);
                this.popup.add(jMenuItem2);
            } else {
                jMenuItem = new JMenuItem("Show Function Details");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                JMenuItem jMenuItem3 = new JMenuItem("Change Function Color");
                jMenuItem3.addActionListener(this);
                this.popup.add(jMenuItem3);
            }
            jMenuItem = new JMenuItem("Reset to Generic Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
            UtilFncs.systemError((Object)exception, null, (String)"SWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            if (this.debug()) {
                System.out.println("####################################");
                System.out.println("StatWindowPanel.renderIt(...)");
                System.out.println("####################################");
            }
            this.list = this.sWindow.getData();
            if (this.list.size() == 0) {
                return;
            }
            SMWThreadDataElement sMWThreadDataElement = null;
            int n2 = 0;
            String string = null;
            String string2 = "";
            int n3 = 0;
            int n4 = this.trial.getPreferences().getBarHeight();
            this.spacing = this.trial.getPreferences().getBarSpacing();
            this.monoFont = new Font("Monospaced", this.trial.getPreferences().getFontStyle(), n4);
            this.fmMonoFont = graphics2D.getFontMetrics(this.monoFont);
            this.maxFontAscent = this.fmMonoFont.getMaxAscent();
            this.maxFontDescent = this.fmMonoFont.getMaxDescent();
            graphics2D.setFont(this.monoFont);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
                ++this.spacing;
            }
            if (bl) {
                Insets insets = this.getInsets();
                n2 += this.spacing;
                String string3 = this.sWindow.getHeaderString();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "'\n'");
                while (stringTokenizer.hasMoreTokens()) {
                    AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                    attributedString.addAttribute(TextAttribute.FONT, this.monoFont);
                    AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                    float f = this.getSize().width - insets.left - insets.right;
                    float f2 = insets.left;
                    float f3 = insets.right;
                    while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                        TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                        textLayout.draw(graphics2D, f2, n2 += this.spacing);
                        f2 = insets.left;
                    }
                }
                this.lastHeaderEndPosition = n2;
            }
            switch (this.windowType) {
                case 0: {
                    if (this.trial.isTimeMetric()) {
                        string = GlobalThreadDataElement.getTStatStringHeading((String)"Time");
                        break;
                    }
                    string = GlobalThreadDataElement.getTStatStringHeading((String)"Counts");
                    break;
                }
                case 1: {
                    if (this.trial.isTimeMetric()) {
                        string = GlobalThreadDataElement.getTStatStringHeading((String)"Time");
                        break;
                    }
                    string = GlobalThreadDataElement.getTStatStringHeading((String)"Counts");
                    break;
                }
                case 2: {
                    string = GlobalThreadDataElement.getUserEventStatStringHeading();
                    break;
                }
                default: {
                    UtilFncs.systemError(null, null, (String)("Unexpected window type - SWP value: " + this.windowType));
                }
            }
            int n5 = this.fmMonoFont.stringWidth(string) + 20;
            string = string + "Name";
            int n6 = string.length();
            int n7 = 0;
            while (n7 < n6) {
                string2 = string2 + "-";
                ++n7;
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string2, 20, n2 += this.spacing);
            n2 = n2 + this.spacing + 10;
            graphics2D.drawString(string, 20, n2);
            n2 = n2 + this.spacing + 10;
            graphics2D.drawString(string2, 20, n2);
            if (n == 0) {
                this.startLocation = n2;
            }
            this.newYPanelSize = n2 + (this.list.size() + 1) * this.spacing;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n == 0 || n == 1) {
                if (n == 0) {
                    rectangle = graphics2D.getClipBounds();
                    n8 = (int)rectangle.getY();
                    n9 = (int)((double)n8 + rectangle.getHeight());
                } else {
                    rectangle2 = this.sWindow.getViewRect();
                    n8 = (int)rectangle2.getY();
                    n9 = (int)((double)n8 + rectangle2.getHeight());
                }
                n10 = (n8 - n2) / this.spacing - 1;
                n11 = (n9 - n2) / this.spacing + 1;
                if (n10 < 0) {
                    n10 = 0;
                }
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n10 > this.list.size() - 1) {
                    n10 = this.list.size() - 1;
                }
                if (n11 > this.list.size() - 1) {
                    n11 = this.list.size() - 1;
                }
                if (n == 0) {
                    n2 += n10 * this.spacing;
                }
            } else if (n == 2 || n == 3) {
                n10 = 0;
                n11 = this.list.size() - 1;
            }
            int n12 = n10;
            while (n12 <= n11) {
                sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(n12);
                switch (this.windowType) {
                    case 0: {
                        string = sMWThreadDataElement.getMeanTotalStatString(this.sWindow.units());
                        break;
                    }
                    case 1: {
                        string = sMWThreadDataElement.getTStatString(this.sWindow.units());
                        break;
                    }
                    case 2: {
                        string = sMWThreadDataElement.getUserEventStatString(ParaProf.defaultNumberPrecision);
                        break;
                    }
                    default: {
                        UtilFncs.systemError(null, null, (String)("Unexpected window type - SWP value: " + this.windowType));
                    }
                }
                n2 += this.spacing;
                graphics2D.setColor(Color.black);
                int n13 = -1;
                n13 = this.windowType == 2 ? this.trial.getColorChooser().getUserEventHightlightColorID() : this.trial.getColorChooser().getHighlightColorID();
                if (sMWThreadDataElement.getMappingID() == n13) {
                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                    new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, 20.0f, n2);
                    graphics2D.setColor(sMWThreadDataElement.getColor());
                    new TextLayout(sMWThreadDataElement.getMappingName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                } else if (this.windowType != 2 && sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGroupHighlightColorID())) {
                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                    new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, 20.0f, n2);
                    graphics2D.setColor(sMWThreadDataElement.getColor());
                    new TextLayout(sMWThreadDataElement.getMappingName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                } else {
                    new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, 20.0f, n2);
                    graphics2D.setColor(sMWThreadDataElement.getColor());
                    new TextLayout(sMWThreadDataElement.getMappingName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                }
                if (n3 < 20 + n5 + this.fmMonoFont.stringWidth(sMWThreadDataElement.getMappingName())) {
                    n3 = 20 + n5 + this.fmMonoFont.stringWidth(sMWThreadDataElement.getMappingName());
                }
                ++n12;
            }
            if (this.newYPanelSize >= this.yPanelSize || n3 >= this.xPanelSize) {
                this.yPanelSize = this.newYPanelSize + 1;
                this.xPanelSize = n3 + 1;
                this.revalidate();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TSWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            if (object instanceof JMenuItem) {
                JFrame jFrame;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details") && this.clickedOnObject instanceof SMWThreadDataElement) {
                    sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                    this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                    jFrame = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.trial.getStaticMainWindow().getSMWData(), this.debug());
                    this.trial.getSystemEvents().addObserver((Observer)((Object)jFrame));
                    jFrame.show();
                }
                if (string.equals("Show Userevent Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setUserEventHighlightColorID(sMWThreadDataElement.getMappingID());
                        jFrame = new UserEventWindow(this.trial, sMWThreadDataElement.getMappingID(), this.trial.getStaticMainWindow().getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver((Observer)((Object)jFrame));
                        jFrame.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    int n = -1;
                    GlobalMappingElement globalMappingElement = null;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    Color color = globalMappingElement.getColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Change Userevent Color")) {
                    int n = -1;
                    GlobalMappingElement globalMappingElement = null;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMappingElement = globalMapping.getGlobalMappingElement(n, 2);
                    Color color = globalMappingElement.getColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    GlobalMappingElement globalMappingElement = null;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    globalMappingElement = this.windowType == 2 ? globalMapping.getGlobalMappingElement(n, 2) : globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TSWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            SMWThreadDataElement sMWThreadDataElement = null;
            Object var3_4 = null;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.trial.getPreferences().getBarHeight();
            int n4 = mouseEvent.getClickCount();
            int n5 = n2 - this.startLocation;
            int n6 = n5 / this.spacing;
            int n7 = (n6 + 1) * this.spacing;
            int n8 = n7 - this.maxFontAscent;
            if (n5 >= n8 && n5 <= n7 && n6 < this.list.size()) {
                sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(n6);
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = sMWThreadDataElement;
                    this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                } else if (this.windowType == 2) {
                    if (this.trial.getColorChooser().getUserEventHightlightColorID() == -1) {
                        this.trial.getColorChooser().setUserEventHighlightColorID(sMWThreadDataElement.getMappingID());
                    } else if (this.trial.getColorChooser().getHighlightColorID() != sMWThreadDataElement.getMappingID()) {
                        this.trial.getColorChooser().setUserEventHighlightColorID(sMWThreadDataElement.getMappingID());
                    } else {
                        this.trial.getColorChooser().setUserEventHighlightColorID(-1);
                    }
                } else if (this.trial.getColorChooser().getHighlightColorID() == -1) {
                    this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                } else if (this.trial.getColorChooser().getHighlightColorID() != sMWThreadDataElement.getMappingID()) {
                    this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                } else {
                    this.trial.getColorChooser().setHighlightColorID(-1);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TSWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.sWindow.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

