/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import translator.GlobalMappingElement;

public class GlobalMapping
implements Serializable {
    Vector nameIDMapping = new Vector();
    int numberOfGlobalFunctions = 0;

    public void addGlobalFunction(String inFunctionName) {
        GlobalMappingElement tmpGME = new GlobalMappingElement();
        tmpGME.setFunctionName(inFunctionName);
        tmpGME.setGlobalID(this.numberOfGlobalFunctions);
        this.nameIDMapping.addElement(tmpGME);
        ++this.numberOfGlobalFunctions;
    }

    public boolean setFunctionNameAt(String inFunctionName, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setFunctionName(inFunctionName);
        return true;
    }

    public boolean setFunctionGroupAt(String functionGroup, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setFunctionGroup(functionGroup);
        return true;
    }

    public boolean setMeanExclusiveValueAt(double inMeanExclusiveValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setMeanExclusiveValue(inMeanExclusiveValue);
        return true;
    }

    public boolean setMeanExclusivePercentValueAt(double inMeanExclusivePercentValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setMeanExclusivePercentValue(inMeanExclusivePercentValue);
        return true;
    }

    public boolean setMeanInclusiveValueAt(double inMeanInclusiveValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setMeanInclusiveValue(inMeanInclusiveValue);
        return true;
    }

    public boolean setMeanInclusivePercentValueAt(double inMeanInclusivePercentValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setMeanInclusivePercentValue(inMeanInclusivePercentValue);
        return true;
    }

    public boolean setTotalExclusiveValueAt(double inTotalExclusiveValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setTotalExclusiveValue(inTotalExclusiveValue);
        return true;
    }

    public boolean setTotalExclusivePercentValueAt(double inTotalExclusivePercentValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setTotalExclusivePercentValue(inTotalExclusivePercentValue);
        return true;
    }

    public boolean setTotalInclusiveValueAt(double inTotalInclusiveValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setTotalInclusiveValue(inTotalInclusiveValue);
        return true;
    }

    public boolean setTotalInclusivePercentValueAt(double inTotalInclusivePercentValue, int inPosition) {
        if (inPosition > this.getNumberOfFunctions() - 1) {
            return false;
        }
        GlobalMappingElement tmpGME = (GlobalMappingElement)this.nameIDMapping.elementAt(inPosition);
        tmpGME.setTotalInclusivePercentValue(inTotalInclusivePercentValue);
        return true;
    }

    public boolean isFunctionPresent(String inFunctionName) {
        Enumeration e = this.nameIDMapping.elements();
        while (e.hasMoreElements()) {
            GlobalMappingElement tmpElement = (GlobalMappingElement)e.nextElement();
            String tmpString = tmpElement.getFunctionName();
            if (!inFunctionName.equals(tmpString)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfFunctions() {
        return this.numberOfGlobalFunctions;
    }

    public GlobalMappingElement getGlobalMappingElement(int functionID) {
        if (functionID > this.getNumberOfFunctions() - 1) {
            return null;
        }
        return (GlobalMappingElement)this.nameIDMapping.elementAt(functionID);
    }

    public int getFunctionId(String inFunctionName) {
        int count = 0;
        GlobalMappingElement tmpGlobalMappingElement = null;
        Enumeration e1 = this.nameIDMapping.elements();
        while (e1.hasMoreElements()) {
            tmpGlobalMappingElement = (GlobalMappingElement)e1.nextElement();
            if (tmpGlobalMappingElement.getFunctionName().equals(inFunctionName)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public GlobalMappingElement getGlobalMappingElement(String inFunctionName) {
        GlobalMappingElement tmpGlobalMappingElement = null;
        Enumeration e1 = this.nameIDMapping.elements();
        while (e1.hasMoreElements()) {
            tmpGlobalMappingElement = (GlobalMappingElement)e1.nextElement();
            if (!tmpGlobalMappingElement.getFunctionName().equals(inFunctionName)) continue;
            return tmpGlobalMappingElement;
        }
        return null;
    }

    public Vector getNameIDMapping() {
        return this.nameIDMapping;
    }
}

