/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.CustomCellRenderer;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.colorchooser.ColorSelectionModel;

class ColorChooserFrame
extends JFrame
implements ActionListener {
    private ParaProfTrial trial = null;
    private ColorChooser colorChooser;
    private ColorSelectionModel clrModel;
    private JColorChooser clrChooser;
    private DefaultListModel listModel;
    private JList colorList;
    private JButton addColorButton;
    private JButton addGroupColorButton;
    private JButton deleteColorButton;
    private JButton updateColorButton;
    private JButton restoreDefaultsButton;
    private int numberOfColors = -1;

    public ColorChooserFrame(ParaProfTrial paraProfTrial, ColorChooser colorChooser) {
        try {
            this.trial = paraProfTrial;
            this.colorChooser = colorChooser;
            this.numberOfColors = paraProfTrial.getColorChooser().getNumberOfColors();
            this.setLocation(new Point(100, 100));
            this.setSize(new Dimension(850, 450));
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit ParaProf!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            jMenuBar.add(jMenu);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.clrChooser = new JColorChooser();
            this.clrModel = this.clrChooser.getSelectionModel();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            JLabel jLabel = new JLabel("ParaProf Color Set.");
            jLabel.setFont(new Font("SansSerif", 2, 14));
            this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.listModel = new DefaultListModel();
            this.colorList = new JList(this.listModel);
            this.colorList.setSelectionMode(0);
            this.colorList.setCellRenderer(new CustomCellRenderer(paraProfTrial));
            JScrollPane jScrollPane = new JScrollPane(this.colorList);
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addColorButton = new JButton("Add Color");
            this.addColorButton.addActionListener(this);
            this.addCompItem(this.addColorButton, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addGroupColorButton = new JButton("Add Mapping Gr. Color");
            this.addGroupColorButton.addActionListener(this);
            this.addCompItem(this.addGroupColorButton, gridBagConstraints, 1, 2, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.deleteColorButton = new JButton("Delete Selected Color");
            this.deleteColorButton.addActionListener(this);
            this.addCompItem(this.deleteColorButton, gridBagConstraints, 1, 3, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.updateColorButton = new JButton("Update Selected Color");
            this.updateColorButton.addActionListener(this);
            this.addCompItem(this.updateColorButton, gridBagConstraints, 1, 4, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.restoreDefaultsButton = new JButton("Restore Defaults");
            this.restoreDefaultsButton.addActionListener(this);
            this.addCompItem(this.restoreDefaultsButton, gridBagConstraints, 1, 5, 1, 1);
            this.addCompItem(this.clrChooser, gridBagConstraints, 2, 0, 1, 6);
            this.populateColorList();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CCF01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof JMenuItem) {
            if (string.equals("Exit ParaProf!")) {
                this.setVisible(false);
                this.dispose();
                ParaProf.exitParaProf(0);
            } else if (string.equals("Close This Window")) {
                this.setVisible(false);
            }
        } else if (object instanceof JButton) {
            if (string.equals("Add Color")) {
                Color color = this.clrModel.getSelectedColor();
                this.colorChooser.getColors().add(color);
                this.listModel.clear();
                this.populateColorList();
                this.colorChooser.setColors(this.trial.getGlobalMapping(), 0);
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Add Mapping Gr. Color")) {
                Color color = this.clrModel.getSelectedColor();
                this.colorChooser.getGroupColors().add(color);
                this.listModel.clear();
                this.populateColorList();
                this.colorChooser.setColors(this.trial.getGlobalMapping(), 1);
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Delete Selected Color")) {
                int[] nArray = this.colorList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < this.trial.getColorChooser().getNumberOfColors()) {
                        System.out.println("The value being deleted is: " + nArray[i]);
                        this.listModel.removeElementAt(nArray[i]);
                        this.colorChooser.getColors().removeElementAt(nArray[i]);
                        this.colorChooser.setColors(this.trial.getGlobalMapping(), 0);
                        continue;
                    }
                    if (nArray[i] >= this.trial.getColorChooser().getNumberOfColors() + this.trial.getColorChooser().getNumberOfMappingGroupColors()) continue;
                    System.out.println("The value being deleted is: " + nArray[i]);
                    this.listModel.removeElementAt(nArray[i]);
                    this.colorChooser.getGroupColors().removeElementAt(nArray[i] - this.trial.getColorChooser().getNumberOfColors());
                    this.colorChooser.setColors(this.trial.getGlobalMapping(), 1);
                }
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Update Selected Color")) {
                Color color = this.clrModel.getSelectedColor();
                int[] nArray = this.colorList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    this.listModel.setElementAt(color, nArray[i]);
                    int n = this.trial.getColorChooser().getNumberOfColors() + this.trial.getColorChooser().getNumberOfMappingGroupColors();
                    if (nArray[i] == n) {
                        this.trial.getColorChooser().setHighlightColor(color);
                        continue;
                    }
                    if (nArray[i] == n + 1) {
                        this.trial.getColorChooser().setGroupHighlightColor(color);
                        continue;
                    }
                    if (nArray[i] == n + 2) {
                        this.trial.getColorChooser().setUserEventHightlightColor(color);
                        continue;
                    }
                    if (nArray[i] == n + 3) {
                        this.trial.getColorChooser().setMiscMappingsColor(color);
                        continue;
                    }
                    if (nArray[i] < this.trial.getColorChooser().getNumberOfColors()) {
                        this.colorChooser.setColor(color, nArray[i]);
                        this.colorChooser.setColors(this.trial.getGlobalMapping(), 0);
                        continue;
                    }
                    this.colorChooser.setGroupColor(color, nArray[i] - this.trial.getColorChooser().getNumberOfColors());
                    this.colorChooser.setColors(this.trial.getGlobalMapping(), 1);
                }
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            } else if (string.equals("Restore Defaults")) {
                this.colorChooser.setDefaultColors();
                this.colorChooser.setDefaultGroupColors();
                this.colorChooser.setHighlightColor(Color.red);
                this.colorChooser.setGroupHighlightColor(new Color(0, 255, 255));
                this.colorChooser.setUserEventHightlightColor(new Color(255, 255, 0));
                this.colorChooser.setMiscMappingsColor(Color.black);
                this.listModel.clear();
                this.populateColorList();
                this.colorChooser.setColors(this.trial.getGlobalMapping(), 0);
                this.colorChooser.setColors(this.trial.getGlobalMapping(), 1);
                this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
            }
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void populateColorList() {
        Color color;
        Enumeration enumeration = this.colorChooser.getColors().elements();
        while (enumeration.hasMoreElements()) {
            color = (Color)enumeration.nextElement();
            this.listModel.addElement(color);
        }
        enumeration = this.colorChooser.getGroupColors().elements();
        while (enumeration.hasMoreElements()) {
            color = (Color)enumeration.nextElement();
            this.listModel.addElement(color);
        }
        color = this.trial.getColorChooser().getHighlightColor();
        this.listModel.addElement(color);
        color = this.trial.getColorChooser().getGroupHighlightColor();
        this.listModel.addElement(color);
        color = this.trial.getColorChooser().getUserEventHightlightColor();
        this.listModel.addElement(color);
        color = this.trial.getColorChooser().getMiscMappingsColor();
        this.listModel.addElement(color);
    }
}

