/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThread;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class StaticMainWindowData {
    private ParaProfTrial trial = null;
    private boolean debug = false;

    public StaticMainWindowData(ParaProfTrial paraProfTrial, boolean bl) {
        this.trial = paraProfTrial;
        this.debug = bl;
    }

    public Vector getAllThreadData(int n) {
        GlobalMapping globalMapping = this.trial.getGlobalMapping();
        Vector<SMWThread> vector = new Vector<SMWThread>();
        Enumeration enumeration = this.trial.getNCT().getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Enumeration enumeration2 = node.getContexts().elements();
            while (enumeration2.hasMoreElements()) {
                Context context = (Context)enumeration2.nextElement();
                Enumeration enumeration3 = context.getThreads().elements();
                while (enumeration3.hasMoreElements()) {
                    int n2 = 0;
                    Thread thread = (Thread)enumeration3.nextElement();
                    SMWThread sMWThread = new SMWThread(thread);
                    Enumeration enumeration4 = thread.getFunctionList().elements();
                    while (enumeration4.hasMoreElements()) {
                        GlobalThreadDataElement globalThreadDataElement = (GlobalThreadDataElement)enumeration4.nextElement();
                        if (globalThreadDataElement == null || !globalMapping.displayMapping(globalThreadDataElement.getMappingID())) continue;
                        SMWThreadDataElement sMWThreadDataElement = new SMWThreadDataElement(this.trial, node.getNodeID(), context.getContextID(), thread.getThreadID(), globalThreadDataElement);
                        sMWThreadDataElement.setSortType(n);
                        sMWThread.addFunction(sMWThreadDataElement);
                        ++n2;
                    }
                    if (n2 == 0) continue;
                    Collections.sort(sMWThread.getFunctionList());
                    vector.add(sMWThread);
                }
            }
        }
        return vector;
    }

    public Vector getThreadData(int n, int n2, int n3, int n4, int n5) {
        GlobalMapping globalMapping = this.trial.getGlobalMapping();
        Vector vector = null;
        Vector<SMWThreadDataElement> vector2 = null;
        GlobalThreadDataElement globalThreadDataElement = null;
        SMWThreadDataElement sMWThreadDataElement = null;
        switch (n4) {
            case 1: {
                vector = this.trial.getNCT().getThread(n, n2, n3).getFunctionList();
                break;
            }
            case 2: {
                vector = this.trial.getNCT().getThread(n, n2, n3).getUsereventList();
                break;
            }
            default: {
                UtilFncs.systemError(null, null, (String)("Unexpected list type - SMWD value: " + n4));
            }
        }
        vector2 = new Vector<SMWThreadDataElement>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            globalThreadDataElement = (GlobalThreadDataElement)enumeration.nextElement();
            if (globalThreadDataElement == null || !globalMapping.displayMapping(globalThreadDataElement.getMappingID())) continue;
            sMWThreadDataElement = new SMWThreadDataElement(this.trial, n, n2, n3, globalThreadDataElement);
            sMWThreadDataElement.setSortType(n5);
            vector2.addElement(sMWThreadDataElement);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public Vector getMappingData(int n, int n2, int n3) {
        Vector<SMWThreadDataElement> vector = new Vector<SMWThreadDataElement>();
        try {
            Enumeration enumeration = this.trial.getNCT().getNodes().elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        Thread thread = (Thread)enumeration3.nextElement();
                        GlobalThreadDataElement globalThreadDataElement = n2 == 1 ? thread.getFunction(n) : thread.getUserevent(n);
                        if (globalThreadDataElement == null) continue;
                        SMWThreadDataElement sMWThreadDataElement = new SMWThreadDataElement(this.trial, node.getNodeID(), context.getContextID(), thread.getThreadID(), globalThreadDataElement);
                        sMWThreadDataElement.setSortType(n3);
                        vector.add(sMWThreadDataElement);
                    }
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMWD01");
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getMeanData(int n) {
        GlobalMapping globalMapping = this.trial.getGlobalMapping();
        Vector vector = null;
        Vector<SMWThreadDataElement> vector2 = null;
        SMWThreadDataElement sMWThreadDataElement = null;
        vector = globalMapping.getMapping(0);
        vector2 = new Vector<SMWThreadDataElement>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
            if (!globalMappingElement.getMeanValuesSet() || !globalMapping.displayMapping(globalMappingElement.getMappingID())) continue;
            sMWThreadDataElement = new SMWThreadDataElement(this.trial, -1, -1, -1, globalMappingElement);
            sMWThreadDataElement.setSortType(n);
            vector2.addElement(sMWThreadDataElement);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

