.\" You can view this file with:
.\" nroff -man [file]
.\" Adapted from libcurl docs by fandom@retemail.es
.TH TclCurl n "4 Febrary 2004" "TclCurl 0.11.0" "TclCurl Multi Interface"
.SH NAME
TclCurl: - get  a  URL with FTP, TELNET, LDAP, GOPHER, DICT, FILE, HTTP or HTTPS syntax.
.SH SYNOPSIS
.BI "curl::multiinit"
.sp
.IB multiHandle " addhandle"
.sp
.IB multiHandle " removehandle"
.sp
.IB multiHandle " perform"
.sp
.IB multiHandle " active"
.sp
.IB multiHandle " getinfo "
.sp
.IB multihandle " cleanup"
.sp
.SH DESCRIPTION
TclCurl's multi interface introduces several new abilities that the easy interface refuses
to offer. They are mainly: 
.TP
Enable a "pull" interface. The application that uses TclCurl decides where and when to get/send data.
.TP
Enable multiple simultaneous transfers in the same thread without making it complicated for the application.
.TP
Keep Tk GUIs 'alive' while transfers are taking place.
.SH curl::multiinit
This procedure must be the first one to call, it returns a
.I multiHandle
that you need to use to invoke TclCurl procedures. The init MUST have a corresponding call to
.I cleanup
when the operation is completed.
.sp
.B RETURN VALUE
.sp
.I multiHandle
to use.
.sp
.SH multiHandle addhandle ?easyHandle?
.sp
Each single transfer is built up with an 'easy' handle, the kind we have been using so far with
TclCurl, you must create them and setup the appropriate options for each of them. Then we add them
to the 'multi stack' using the
.I addhandle
command. 
.sp
.I "multiHandle"
is the return code from the
.I "curl::multiinit"
call.
.sp
.B RETURN VALUE
The possible return values are:
.IP -1
Handle added to the multi stack, please call
.I perform
soon
.IP 0
Handle added ok.
.IP 1
Invalid multi handle.
.IP 2
Invalid 'easy' handle.
.IP 3
Out of memory, you should never get this.
.IP 4
You found a bug in TclCurl.
.sp
.SH multiHandle removehandle ?easyHandle?
.sp
When a transfer is done or if we want to stop a transfer before it is completed, we can use the
.I removehandle
command. Once removed from the multi handle, we can again use other easy interface functions on it.
.sp
.B RETURN VALUE
The possible return values are:
.IP 0
Handle removed ok.
.IP 1
Invalid multi handle.
.IP 2
Invalid 'easy' handle.
.IP 3
Out of memory, you should never get this.
.IP 4
You found a bug in TclCurl.
.sp
.SH multiHandle perform
Adding the easy handles to the multi stack does not start any transfer.
Remember that one of the main ideas with this interface is to let your
application drive. You drive the transfers by invoking
.I perform.
TclCurl will then transfer data if there is anything available to transfer.
It'll use the callbacks and everything else we have setup in the individual
easy handles. It'll transfer data on all current transfers in the multi stack
that are ready to transfer anything. It may be all, it may be none. 
.sp
.B RETURN VALUE
If everything goes well, it returns the number of running handles, '0' if all
are done. In case of error, it will return the error code.
.sp
.SH multiHandle active
In order to know if any of the easy handles are ready to transfer data before
invoking
.I perform
you can use the 
.I active
command, it will return the number of transfers currently active.
.sp
.B RETURN VALUE
The number of active transfers or '-1' in case of error.

.SH multiHandle getinfo
This procedure returns very simple information about the transfers, you
can get more detail information using the 
.I getinfo
command on each of the easy handles.
.sp
.B RETURN VALUE
A list with the following elements:
.TP
easyHandle about which the info is about.
.TP
state of the transfer, '1' if it is done.
.TP
exit code of the transfer, '0' if there was no error,...
.TP
Number of messages still in the info queue.
.TP
In case there are no messages in the queue it will return {"" 0 0 0}.

.SH multiHandle cleanup
This procedure must be the last one to call for a multi stack, it is the opposite of the
.I curl::multiinit
procedure and must be called with the same
.I multiHandle
as input as the
.B curl::multiinit
call returned.


.SH "SEE ALSO"
.I tclcurl, curl.
