[comment {-*- text -*- doctools manpage}]
[manpage_begin fileutil_traverse n 0.4]
[moddesc   {file utilities}]
[titledesc {Iterative directory traversal}]
[require Tcl 8.3]
[require fileutil::traverse [opt 0.4]]
[description]
[keywords {directory traversal} traversal]
[para]

This package provides objects for the programmable traversal of
directory hierarchies.

The main command exported by the package is:

[list_begin definitions]

[call [cmd ::fileutil::traverse] [opt [arg objectName]] \
      [arg path] [opt "[arg option] [arg value]..."]]

The command creates a new traversal object with an associated global
Tcl command whose name is [arg objectName]. This command may be used
to invoke various operations on the traverser.

If the string [const %AUTO%] is used as the [arg objectName] then a
unique name will be generated by the package itself.

[para]

Regarding the recognized options see section [sectref OPTIONS]. Note
that all these options can be set only during the creation of the
traversal object. Changing them later is not possible and causes
errors to be thrown if attempted.

[para]

The object command has the following general form:

[list_begin definitions]
[call [cmd \$traverser] [method command] [opt [arg "arg arg ..."]]]

[arg Command] and its [arg arg]uments determine the exact behavior of
the object.

[list_end]
[list_end]

The following commands are possible for traversal objects:

[list_begin definitions]

[call [cmd \$traverser] [method files]]

This method is the most highlevel one provided by traversal
objects. When invoked it returns a list containing the names of all
files and directories matching the current configuration of the
traverser.


[call [cmd \$traverser] [method foreach] [arg filevar] [arg script]]

The highlevel [method files] method (see above) is based on this
mid-level method. When invoked it finds all files and directories
matching per the current configuration and executes the [arg script]
for each path. The current path under consideration is stored in the
variable named by [arg filevar]. Both variable and script live / are
executed in the context of the caller of the method. In the method
[method files] the script simply saves the found paths into the list
to return.


[call [cmd \$traverser] [method next] [arg filevar]]

This is the lowest possible interface to the traverser, the core all
higher methods are built on. When invoked it returns a boolean value
indicating whether it found a path matching the current configuration
([const True]), or not ([const False]). If a path was found it is
stored into the variable named by [arg filevar], in the context of the
caller.

The [method foreach] method simply calls this method in a loop until
it returned [const False]. This method is exposed so that we are also
able to incrementally traverse a directory hierarchy in an event-based
manner.

[list_end]


[section OPTIONS]

[list_begin options]
[opt_def -prefilter command_prefix]

This callback is executed for directories. Its result determines if
the traverser recurses into the directory or not. The default is to
always recurse into all directories. The callback is invoked with a
single argument, the [emph absolute] path of the directory, and has to
return a boolean value, [const True] when the directory passes the
filter, and [const False] if not.

[opt_def -filter command_prefix]

This callback is executed for all paths. Its result determines if the
current path is a valid result, and returned by [method next]. The
default is to accept all paths as valid. The callback is invoked with
a single argument, the [emph absolute] path to check, and has to
return a boolean value, [const True] when the path passes the filter,
and [const False] if not.

[opt_def -errorcmd command_prefix]

This callback is executed for all paths the traverser has trouble
with. Like being unable to change into them, get their status,
etc. The default is to ignore any such problems. The callback is
invoked with a two arguments, the [emph absolute] path for which the
error occured, and the error message. Errors thrown by the filter
callbacks are handled through this callback too. Errors thrown by the
error callback itself are not caught and ignored, but allowed to pass
to the caller, i.e. however invoked the [method next]. Any other
results from the callback are ignored.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph fileutil] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[manpage_end]
