[manpage_begin tcllib_ip n 1.1.1]
[copyright {2004, Pat Thoyts}]
[copyright {2005 Aamer Akhter <aakhter@cisco.com>}]
[moddesc   {Domain Name Service}]
[titledesc {IPv4 and IPv6 address manipulation}]
[require Tcl 8.2]
[require ip [opt 1.1.1]]
[description]
[para]

This package provides a set of commands to help in parsing, displaying
and comparing internet addresses. The package can handle both IPv4 (1)
and IPv6 (2) address types.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::ip::version] [arg address]]

Returns the protocol version of the address (4 or 6) or 0 if the
address is neither IPv4 or IPv6.

[call [cmd ::ip::is] [arg class] [arg address]]

Returns true if the address is a member of the given protocol
class. The class parameter may be either [arg ipv4] or [arg ipv6]
This is effectively a boolean equivalent of the [cmd version]
command. The [arg class] argument may be shortened to [arg 4] or
[arg 6].

[call [cmd ::ip::equal] [arg address] [arg address]]

Compare two address specifications for equivalence. The arguments are
normalized and the address prefix determined (if a mask is
supplied). The normalized addresses are then compared bit-by-bit and
the procedure returns true if they match.

[call [cmd ::ip::normalize] [arg address]]

Convert an IPv4 or IPv6 address into a fully expanded version. There
are various shorthand ways to write internet addresses, missing out
redundant parts or digts.. This procedure is the opposite of 
[cmd contract].  

[call [cmd ::ip::contract] [arg address]]

Convert a [cmd normalize]d internet address into a more compact form
suitable for displaying to users.

[call [cmd ::ip::prefix] [arg address]]

Returns the address prefix generated by masking the address part with
the mask if provided. If there is no mask then it is equivalent to
calling [cmd normalize]

[call [cmd ::ip::type] [arg address]]

[call [cmd ::ip::mask] [arg address]]

If the address supplied includes a mask then this is returned
otherwise returns an empty string.


[call [cmd ::ip::prefixToNative] [arg prefix]]

This command converts the string [arg prefix] from dotted form
(<ipaddr>/<mask> format) to native (hex) form. Returns a list
containing two elements, ipaddress and mask, in this order, in
hexadecimal notation.

[nl]
[example {
   % ip::prefixToNative 1.1.1.0/24
   0x01010100 0xffffff00
}]


[call [cmd ::ip::nativeToPrefix] [arg nativeList]|[arg native] \
	[opt [option -ipv4]]]

This command converts from native (hex) form to dotted form.
It is the complement of [cmd ::ip::prefixToNative].

[nl]
[list_begin arg]
[arg_def list nativeList in]

List of several ip addresses in native form. The native form is a list
as returned by [cmd ::ip::prefixToNative].

[arg_def list native in]

A list as returned by [cmd ::ip::prefixToNative].

[list_end]
[nl]

The command returns a list of addresses in dotted form if it was
called with a list of addresses. Otherwise a single address in dotted
form is returned.

[nl]
[example {
   % ip::nativeToPrefix {0x01010100 0xffffff00} -ipv4
   1.1.1.0/24
}]


[call [cmd ::ip::intToString] [arg number] [opt [option -ipv4]]]

This command converts from an ip address specified as integer number
to dotted form.

[nl]
[example {
       ip::intToString 4294967295
       255.255.255.255
}]


[call [cmd ::ip::toInteger] [arg ipaddr]]

This command converts a dotted form ip into an integer number.

[nl]
[example {
   % ::ip::toInteger 1.1.1.0
   16843008
}]


[call [cmd ::ip::toHex] [arg ipaddr]]

This command converts dotted form ip into a hexadecimal number.

[nl]
[example {
   % ::ip::toHex 1.1.1.0
   0x01010100
}]


[call [cmd ::ip::maskToInt] [arg ipmask]]

This command convert an ipmask in either dotted (255.255.255.0) form
or mask length form (24) into an integer number.

[nl]
[example {
   ::ip::maskToInt 24
   4294967040
}]


[call [cmd ::ip::broadcastAddress] [arg prefix] [opt [option -ipv4]]]

This commands returns a broadcast address in dotted form for the given
route [arg prefix], either in the form "addr/mask", or in native
form. The result is in dotted form.

[nl]
[example {
   ::ip::broadcastAddress 1.1.1.0/24
   1.1.1.255

   ::ip::broadcastAddress {0x01010100 0xffffff00}
   0x010101ff
}]   


[call [cmd ::ip::maskToLength] \
	[arg dottedMask]|[arg integerMask]|[arg hexMask] \
	[opt [option -ipv4]]]

This command converts the dotted or integer form of an ipmask to
the mask length form.

[nl]
[example {
   ::ip::maskToLength 0xffffff00 -ipv4
   24

   % ::ip::maskToLength 255.255.255.0
   24
}]

[call [cmd ::ip::lengthToMask] [arg maskLength] \
	[opt [option -ipv4]]]

This command converts an ipmask in mask length form to its dotted
form.

[nl]
[example {
   ::ip::lengthToMask 24
   255.255.255.0
}]


[call [cmd ::ip::nextNet] [arg ipaddr] [arg ipmask] \
	[opt [arg count]] \
	[opt [option -ipv4]]]

This command returns an ipaddress in the same position in the
[arg count] next network. The default value for [arg count] is
[const 1].

[nl]

The address can be specified as either integer number or in dotted
form. The mask can be specified as either integer number, dotted form,
or mask length form.

[nl]

The result is in hex form.


[call [cmd ::ip::isOverlap] [arg prefix] [arg prefix]...]

This command checks if the given ip prefixes overlap.  All arguments
are in dotted "addr/mask" form. All arguments after the first prefix
are compared against the first prefix. The result is a boolean
value. It is true if an overlap was found for any of the prefixes.

[nl]
[example {
  % ::ip::isOverlap 1.1.1.0/24 2.1.0.1/32
  0

  ::ip::isOverlap 1.1.1.0/24 2.1.0.1/32 1.1.1.1/32
  1
}]


[call [cmd ::ip::isOverlapNative] \
	[opt [option -all]] \
	[opt [option -inline]] \
	[opt [option -ipv4]] \
	[arg hexipaddr] [arg hexipmask] [arg hexiplist]]

This command is similar to [cmd ::ip::isOverlap], however the
arguments are in the native form, and the form of the result is under
greater control of the caller.

If the option [option -all] is specified it checks all addresses for
overlap, not only until the first one is found.

If the option [option -inline] is specified the command returns the
overlapping prefix instead of index values.

[nl]

The result of the command is, depending on the specified options,

[list_begin definitions]
[lst_item {no options}]

The index of the first overlap found, or 0 if there is none.

[lst_item -all]

A list containing the indices of all overlaps found, or an empty list

if there are none.

[lst_item -inline]

The first overlapping prefix, or an empoty string if there is none.

[lst_item {-all -inline}]

A list containing the prefixes of all overlaps found, or an empty list
if there are none.

[list_end]

[nl]
[example {
  % ::ip::isOverlapNative 0x01010100 0xffffff00 {{0x02010001 0xffffffff}}
  0

  % ::ip::isOverlapNative 0x01010100 0xffffff00 {{0x02010001 0xffffffff} {0x01010101 0xffffffff}}
  2
}]


[call [cmd ::ip::ipToLayer2Multicast] [arg ipaddr]]

This command an converts ipv4 address in dotted form into a layer 2
multicast address, also in dotted form.

[nl]
[example {
  % ::ip::ipToLayer2Multicast 224.0.0.2
  01.00.5e.00.00.02
}]


[call [cmd ::ip::ipHostFromPrefix] [arg prefix] \
	[opt "[option -exclude] [arg prefixExcludeList]"]]

This command returns a host address from a prefix in the form
"ipaddr/masklen", also making sure that the result is not an address
found in the [arg prefixExcludeList].

The result is an ip address in dotted form.

[nl]
[example {
  %::ip::ipHostFromPrefix  1.1.1.5/24
  1.1.1.1

  %::ip::ipHostFromPrefix  1.1.1.1/32
  1.1.1.1
}]


[call [cmd ::ip::reduceToAggregates] [arg prefixlist]]

This command finds nets that overlap and filters out the more specifc
nets. The prefixes are in either addr/mask form or in native format.

The result is a list containing the non-overlapping ip prefixes from
the input.

[nl]
[example {
  % ::ip::reduceToAggregates {1.1.1.0/24 1.1.0.0/8  2.1.1.0/24 1.1.1.1/32 }
  1.0.0.0/8 2.1.1.0/24
}]


[call [cmd ::ip::longestPrefixMatch] [arg ipaddr] [arg prefixlist] \
	[opt [option -ipv4]]]

This command finds longest prefix match from set of prefixes, given a
specific host address. The prefixes in the list are in either native
or dotted form, whereas the host address is in either ipprefix format,
dotted form, or integer form.

The result is the prefix which is the most specific match to the host
address.

[nl]
[example {
  % ::ip::longestPrefixMatch 1.1.1.1 {1.1.1.0/24 1.0.0.0/8  2.1.1.0/24 1.1.1.0/28 }
  1.1.1.0/28
}]


[list_end]

[comment { -----------------------------------------------------------  }]

[section EXAMPLES]
[para]

[example {
% ip::version ::1
6
% ip::version 127.0.0.1
4
}]

[example {
% ip::normalize 127/8
127.0.0.0/8
% ip::contract 192.168.0.0
192.168
%
% ip::normalize fec0::1
fec0:0000:0000:0000:0000:0000:0000:0001
% ip::contract fec0:0000:0000:0000:0000:0000:0000:0001
fec0::1
}]

[example {
% ip::equal 192.168.0.4/16 192.168.0.0/16
1
% ip::equal fec0::1/10 fec0::fe01/10
1
}]

[comment { -----------------------------------------------------------  }]

[section {REFERENCES}]

[list_begin enum]

[enum]
    Postel, J. "Internet Protocol." RFC 791,  September 1981,
    ([uri http://www.ietf.org/rfc/rfc791.txt])

[enum]
    Hinden, R. and Deering, S.,
    "Internet Protocol Version 6 (IPv6) Addressing Architecture",
    RFC 3513, April 2003
    ([uri http://www.ietf.org/rfc/rfc3513.txt])

[list_end]

[see_also inet(3) ip(7) ipv6(7)]
[section AUTHORS]
Pat Thoyts

[keywords {internet address} ip ipv4 ipv6 {rfc 3513}]
[manpage_end]
