'\"
'\" Copyright (c) 2004 Zveno Pty Ltd
'\" http://www.zveno.com/
'\"
Zveno makes this software and all associated data and documentation
('Software') available free of charge for any purpose.  Copies may be made
of this Software but all of this notice must be included on any copy.
'\"
The Software was developed for research purposes and Zveno does not
warrant that it is error free or fit for any purpose.  Zveno disclaims any
liability for all claims, expenses, losses, damages and costs any user may
incur as a result of using, copying or modifying the Software.
'\"
'\"
'\" RCS: @(#) $Id: nroff.xsl,v 1.3 2003/12/03 20:06:33 balls Exp $
'\" 
.so man.macros
.TH TclXML n 3.0 TclXML "TclXML Package Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::xml::parser ::xml::parserclass \- XML parser support for Tcl
.BE

.SH SYNOPSIS
\fBpackage require xml\fP
.sp
\fBpackage require \fIparserclass\fR
.sp
\fB::xml::parserclass\fI option\fR ?\fI arg\fI arg ... ?\fP
.sp
\fB::xml::parser ?\fI \fIname\fR? ?\fI -option\fR\fI \fIvalue\fR ... ?\fP
.sp
\fB\fIparser\fR\fI \fIoption\fR\fI \fIarg\fR
.BE

.SH DESCRIPTION

.PP
TclXML provides event-based parsing of XML documents.  The application may register callback scripts for certain document features, and when the parser encounters those features while parsing the document the callback is evaluated.

.PP
The parser may also perform other functions, such as normalisation, validation and/or entity expansion.  Generally, these functions are under the control of configuration options.  Whether these functions can be performed at all depends on the parser implementation.

.PP
The TclXML package provides a generic interface for use by a Tcl application, along with a low-level interface for use by a parser implementation.  Each implementation provides a class of XML parser, and these register themselves using the \fB::xml::parserclass create\fR command.  One of the registered parser classes will be the default parser class.

.PP
Loading the package with the generic \fBpackage require xml\fR command allows the package to automatically determine the default parser class.  In order to select a particular parser class as the default, that class' package may be loaded directly, eg. \fBpackage require expat\fR.  In all cases, all available parser classes are registered with the TclXML package, the difference is simply in which one becomes the default.

.SH COMMANDS
.SS \fB::xml::parserclass\fR

.PP
The \fB::xml::parserclass\fR command is used to manage XML parser classes.
.SS Command Options

.PP
The following command options may be used:

.RS
.TP
\fI\fB\fBcreate\fR\fR\fP 
\fI create\fI \fIname\fR ?\fI -createcommand\fR\fI \fIscript\fR? ?\fI -createentityparsercommand\fR\fI \fIscript\fR? ?\fI -parsecommand\fR\fI \fIscript\fR? ?\fI -configurecommand\fR\fI \fIscript\fR? ?\fI -getcommand\fR\fI \fIscript\fR? ?\fI -deletecommand\fR\fI \fIscript\fR?\fP
.PP
Creates an XML parser class with the given name.

.TP
\fI\fB\fBdestroy\fR\fR\fP 
\fI destroy\fI \fIname\fR\fP
.PP
Destroys an XML parser class.

.TP
\fI\fB\fBinfo\fR\fR\fP 
\fI info\fR\fI names\fP
.PP
Returns information about registered XML parser classes.

.RE
.SS \fB::xml::parser\fR

.PP
The \fB::xml::parser\fR command creates an XML parser object.  The return value of the command is the name of the newly created parser.

.PP
The parser scans an XML document's syntactical structure, evaluating callback scripts for each feature found.  At the very least the parser will normalise the document and check the document for well-formedness.  If the document is not well-formed then the \fI -errorcommand\fR option will be evaluated.  Some parser classes may perform additional functions, such as validation.  Additional features provided by the various parser classes are described in the section Parser Classes

.PP
Parsing is performed synchronously.  The command blocks until the entire document has been parsed.  Parsing may be terminated by an application callback, see the section Callback Return Codes.  Incremental parsing is also supported by using the \fI -final\fR configuration option.
.SS Configuration Options

.PP
The \fB::xml::parser\fR command accepts the following configuration options:

.RS
.TP
\fI\fB\fI -attlistdeclcommand\fR\fR\fP 
\fI -attlistdeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated whenever an attribute list declaration is encountered in the DTD subset of an XML document.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIattrname\fR\fI \fItype\fR\fI \fIdefault\fR\fI \fIvalue\fR
.PP
where:

.RS
.TP
\fIname\fP Element type name
.TP
\fIattrname\fP Attribute name being declared
.TP
\fItype\fP Attribute type
.TP
\fIdefault\fP Attribute default, such as #IMPLIED
.TP
\fIvalue\fP Default attribute value.  Empty string if none given.
.RE

.TP
\fI\fB\fI -baseuri\fR\fR\fB\fI -baseurl\fR\fR\fP 
\fI -baseuri\fR\fI \fIURI\fR\fP
.sp
\fI -baseurl\fR\fI \fIURI\fR\fP
.PP
Specifies the base URI for resolving relative URIs that may be used in the XML document to refer to external entities.

.PP
\fI -baseurl\fR is deprecated in favour of \fI -baseuri\fR.

.TP
\fI\fB\fI -characterdatacommand\fR\fR\fP 
\fI -characterdatacommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated whenever character data is encountered in the XML document being parsed.  The command evaluated is:
\fB\fIscript\fR\fI \fIdata\fR
.PP
where:

.RS
.TP
\fIdata\fP Character data in the document
.RE

.TP
\fI\fB\fI -commentcommand\fR\fR\fP 
\fI -commentcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated whenever a comment is encountered in the XML document being parsed.  The command evaluated is:
\fB\fIscript\fR\fI \fIdata\fR
.PP
where:

.RS
.TP
\fIdata\fP Comment data
.RE

.TP
\fI\fB\fI -defaultcommand\fR\fR\fP 
\fI -defaultcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when no other callback has been defined for a document feature which has been encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIdata\fR
.PP
where:

.RS
.TP
\fIdata\fP Document data
.RE

.TP
\fI\fB\fI -defaultexpandinternalentities\fR\fR\fP 
\fI -defaultexpandinternalentities\fR\fI \fIboolean\fR\fP
.PP
Specifies whether entities declared in the internal DTD subset are expanded with their replacement text.  If entities are not expanded then the entity references will be reported with no expansion.

.TP
\fI\fB\fI -doctypecommand\fR\fR\fP 
\fI -doctypecommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when the document type declaration is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIpublic\fR\fI \fIsystem\fR\fI \fIdtd\fR
.PP
where:

.RS
.TP
\fIname\fP The name of the document element
.TP
\fIpublic\fP Public identifier for the external DTD subset
.TP
\fIsystem\fP System identifier for the external DTD subset.  Usually a URI.
.TP
\fIdtd\fP The internal DTD subset
.RE

.PP
See also \fI -startdoctypedeclcommand\fR and \fI -enddoctypedeclcommand\fR.

.TP
\fI\fB\fI -elementdeclcommand\fR\fR\fP 
\fI -elementdeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when an element markup declaration is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fImodel\fR
.PP
where:

.RS
.TP
\fIname\fP The element type name
.TP
\fImodel\fP Content model specification
.RE

.TP
\fI\fB\fI -elementendcommand\fR\fR\fP 
\fI -elementendcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when an element end tag is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIargs\fR
.PP
where:

.RS
.TP
\fIname\fP The element type name that has ended
.TP
\fIargs\fP Additional information about this element
.RE

.PP
Additional information about the element takes the form of configuration options.  Possible options are:

.RS
.TP
\fI-empty boolean\fP The empty element syntax was used for this element
.TP
\fI-namespace uri\fP The element is in the XML namespace associated with the given URI
.RE

.TP
\fI\fB\fI -elementstartcommand\fR\fR\fP 
\fI -elementstartcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when an element start tag is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIattlist\fR\fI \fIargs\fR
.PP
where:

.RS
.TP
\fIname\fP The element type name that has started
.TP
\fIattlist\fP A Tcl list containing the attributes for this element.  The list of attributes is formatted as pairs of attribute names and their values.  
.TP
\fIargs\fP Additional information about this element
.RE

.PP
Additional information about the element takes the form of configuration options.  Possible options are:

.RS
.TP
\fI-empty boolean\fP The empty element syntax was used for this element
.TP
\fI-namespace uri\fP The element is in the XML namespace associated with the given URI
.TP
\fI-namespacedecls list\fP The start tag included one or more XML Namespace declarations.  list is a Tcl list giving the namespaces declared.  The list is formatted as pairs of values, the first value is the namespace URI and the second value is the prefix used for the namespace in this document.  A default XML namespace declaration will have an empty string for the prefix.
.RE

.TP
\fI\fB\fI -encoding\fR\fR\fP 
\fI -encoding\fR\fI \fIvalue\fR\fP
.PP
Gives the character encoding of the document.  This option only has an effect before a document is parsed.  The default character encoding is .  If the value  is given, or any value other than , then the document text is treated as binary data.  If the value is given as  then the parser will attempt to automatically determine the character encoding of the document (using byte-order-marks, etc).  If any value other than  or  is given then the parser will read the document text using that character encoding.

.TP
\fI\fB\fI -endcdatasectioncommand\fR\fR\fP 
\fI -endcdatasectioncommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when end of a CDATA section is encountered.  The command is evaluated with no further arguments.

.TP
\fI\fB\fI -enddoctypedeclcommand\fR\fR\fP 
\fI -enddoctypedeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when end of the document type declaration is encountered.  The command is evaluated with no further arguments.

.TP
\fI\fB\fI -entitydeclcommand\fR\fR\fP 
\fI -entitydeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when an entity declaration is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIargs\fR
.PP
where:

.RS
.TP
\fIname\fP The name of the entity being declared
.TP
\fIargs\fP Additional information about the entity declaration.  An internal entity shall have a single argument, the replacement text.  An external parsed entity shall have two additional arguments, the public and system indentifiers of the external resource.  An external unparsed entity shall have three additional arguments, the public and system identifiers followed by the notation name.
.RE

.TP
\fI\fB\fI -entityreferencecommand\fR\fR\fP 
\fI -entityreferencecommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when an entity reference is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR
.PP
where:

.RS
.TP
\fIname\fP The name of the entity being referenced
.RE

.TP
\fI\fB\fI -errrocommand\fR\fR\fP 
\fI -errorcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a fatal error is detected.  The error may be due to the XML document not being well-formed.  In the case of a validating parser class, the error may also be due to the XML document not obeying validity constraints.  By default, a callback script is provided which causes an error return code, but an application may supply a script which attempts to continue parsing.  The command evaluated is:
\fB\fIscript\fR\fI \fIerrorcode\fR\fI \fIerrormsg\fR
.PP
where:

.RS
.TP
\fIerrorcode\fP A single word description of the error, intended for use by an application
.TP
\fIerrormsg\fP A human-readable description of the error
.RE

.TP
\fI\fB\fI -externalentitycommand\fR\fR\fP 
\fI -externalentitycommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated to resolve an external entity reference.  If the parser has been configured to validate the XML document, a default script is supplied that resolves the URI given as the system identifier of the external entity and recursively parses the entity's data.  If the parser has been configured as a non-validating parser, then by default external entities are not resolved.  This option can be used to override the default behaviour.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIbaseuri\fR\fI \fIuri\fR\fI \fIid\fR
.PP
where:

.RS
.TP
\fIname\fP The Tcl command name of the current parser
.TP
\fIbaseuri\fP An absolute URI for the current entity which is to be used to resolve relative URIs
.TP
\fIuri\fP The system identifier of the external entity, usually a URI
.TP
\fIid\fP The public identifier of the external entity.  If no public identifier was given in the entity declaration then id will be an empty string.
.RE

.TP
\fI\fB\fI -final\fR\fR\fP 
\fI -final\fR\fI \fIboolean\fR\fP
.PP
Specifies whether the XML document being parsed is complete.  If the document is to be incrementally parsed then this option will be set to false, and when the last fragment of document is parsed it is set to true.  For example,
.PP
.CS

set parser [::xml::parser -final 0]
$parser parse $data1
.
.
.
$parser parse $data2
.
.
.
$parser configure -final 1
$parser parse $finaldata
		
.CE

.TP
\fI\fB\fI -ignorewhitespace\fR\fR\fP 
\fI -ignorewhitespace\fR\fI \fIboolean\fR\fP
.PP
If this option is set to true then spans of character data in the XML document which are composed only of white-space (CR, LF, space, tab) will not be reported to the application.  In other words, the data passed to every invocation of the \fI -characterdatacommand\fR script will contain at least one non-white-space character.

.TP
\fI\fB\fI -notationdeclcommand\fR\fR\fP 
\fI -notationdeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a notation declaration is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIuri\fR
.PP
where:

.RS
.TP
\fIname\fP The name of the notation
.TP
\fIuri\fP An external identifier for the notation, usually a URI.
.RE

.TP
\fI\fB\fI -notstandalonecommand\fR\fR\fP 
\fI -notstandalonecommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when the parser determines that the XML document being parsed is not a standalone document.

.TP
\fI\fB\fI -paramentityparsing\fR\fR\fP 
\fI -paramentityparsing\fR\fI \fIboolean\fR\fP
.PP
Controls whether external parameter entities are parsed.

.TP
\fI\fB\fI -parameterentitydeclcommand\fR\fR\fP 
\fI -parameterentitydeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a parameter entity declaration is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIname\fR\fI \fIargs\fR
.PP
where:

.RS
.TP
\fIname\fP The name of the parameter entity
.TP
\fIargs\fP For an internal parameter entity there is only one additional argument, the replacement text.  For external parameter entities there are two additional arguments, the system and public identifiers respectively.
.RE

.TP
\fI\fB\fI -parser\fR\fR\fP 
\fI -parser\fR\fI \fIname\fR\fP
.PP
The name of the parser class to instantiate for this parser object.  This option may only be specified when the parser instance is created.

.TP
\fI\fB\fI -processinginstructioncommand\fR\fR\fP 
\fI -processinginstructioncommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a processing instruction is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fItarget\fR\fI \fIdata\fR
.PP
where:

.RS
.TP
\fItarget\fP The name of the processing instruction target
.TP
\fIdata\fP Remaining data from the processing instruction
.RE

.TP
\fI\fB\fI -reportempty\fR\fR\fP 
\fI -reportempty\fR\fI \fIboolean\fR\fP
.PP
If this option is enabled then when an element is encountered that uses the special empty element syntax, additional arguments are appended to the \fI -elementstartcommand\fR and \fI -elementendcommand\fR callbacks.  The arguments \fI -empty 1 are appended.  For example:
\fB\fIscript\fR\fI -empty\fR\fI 1
.TP
\fI\fB\fI -startcdatasectioncommand\fR\fR\fP 
\fI -startcdatasectioncommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when the start of a CDATA section section is encountered.  No arguments are appended to the script.

.TP
\fI\fB\fI -startdoctypedeclcommand\fR\fR\fP 
\fI -startdoctypedeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated at the start of a document type declaration.  No arguments are appended to the script.

.TP
\fI\fB\fI -unknownencodingcommand\fR\fR\fP 
\fI -unknownencodingcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a character is encountered with an unknown encoding.  This option has not been implemented.

.TP
\fI\fB\fI -unparsedentitydeclcommand\fR\fR\fP 
\fI -unparsedentitydeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a declaration is encountered for an unparsed entity.  The command evaluated is:
\fB\fIscript\fR\fI \fIsystem\fR\fI \fIpublic\fR\fI \fInotation\fR
.PP
where:

.RS
.TP
\fIsystem\fP The system identifier of the external entity, usually a URI
.TP
\fIpublic\fP The public identifier of the external entity
.TP
\fInotation\fP The name of the notation for the external entity
.RE

.TP
\fI\fB\fI -validate\fR\fR\fP 
\fI -validate\fR\fI \fIboolean\fR\fP
.PP
Enables validation of the XML document to be parsed.  Any changes to this option are ignored after an XML document has started to be parsed, but the option may be changed after a reset.

.TP
\fI\fB\fI -warningcommand\fR\fR\fP 
\fI -warningcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when a warning condition is detected.  A warning condition is where the XML document has not been authored correctly, but is still well-formed and may be valid.  For example, the special empty element syntax may be used for an element which has not been declared to have empty content.  By default, a callback script is provided which silently ignores the warning.  The command evaluated is:
\fB\fIscript\fR\fI \fIwarningcode\fR\fI \fIwarningmsg\fR
.PP
where:

.RS
.TP
\fIwarningcode\fP A single word description of the warning, intended for use by an application
.TP
\fIwanringmsg\fP A human-readable description of the warning
.RE

.TP
\fI\fB\fI -xmldeclcommand\fR\fR\fP 
\fI -xmldeclcommand\fR\fI \fIscript\fR\fP
.PP
Specifies the prefix of a Tcl command to be evaluated when the XML declaration is encountered.  The command evaluated is:
\fB\fIscript\fR\fI \fIversion\fR\fI \fIencoding\fR\fI \fIstandalone\fR
.PP
where:

.RS
.TP
\fIversion\fP The version number of the XML specification to which this document purports to conform
.TP
\fIencoding\fP The character encoding of the document
.TP
\fIstandalone\fP A boolean declaring whether the document is standalone
.RE

.RE
.SS Parser Command

.PP
The \fB::xml::parser\fR command creates a new Tcl command with the same name as the parser.  This command may be used to invoke various operations on the parser object.  It has the following general form:
\fB\fIname\fR\fI \fIoption\fR\fR\fI \fIarg\fR
.PP
\fI \fIoption\fR\fR and the \fI \fIarg\fR determine the exact behaviour of the command.  The following commands are possible for parser objects:

.RS
.TP
\fI\fB\fI cget\fR\fR\fP 
\fI cget\fR\fI \fI-option\fR\fP
.PP
Returns the current value of the configuration option given by \fI \fIoption\fR\fR.  \fI \fIOption\fR\fR may have any of the values accepted by the parser object.

.TP
\fI\fB\fI configure\fR\fR\fP 
\fI configure\fR ?\fI \fI-option\fR\fI \fIvalue\fR ... ?\fP
.PP
Modify the configuration options of the parser object.  \fI \fIOption\fR\fR may have any of the values accepted by the parser object.

.TP
\fI\fB\fI entityparser\fR\fR\fP 
\fI entityparser\fR ?\fI \fIoption\fR\fI \fIvalue\fR ... ?\fP
.PP
Creates a new parser object.  The new object inherits the same configuration options as the parent parser object, but is able to parse XML data in a parsed entity.  The option \fI -dtdsubset\fR allows markup declarations to be treated as being in the internal or external DTD subset.

.TP
\fI\fB\fI free\fR\fR\fP 
\fI free\fR\fI \fIname\fR\fP
.PP
Frees all resources associated with the parser object.  The object is not usable after this command has been invoked.

.TP
\fI\fB\fI get\fR\fR\fP 
\fI get\fR\fI \fIname\fR\fI args\fP
.PP
Returns information about the XML document being parsed.  Each parser class provides different information, see the documentation for the parser class.

.TP
\fI\fB\fI parse\fR\fR\fP 
\fI parse\fR\fI \fIxml\fR\fI args\fP
.PP
Parses the XML document.  The usual desired effect is for various application callbacks to be evaluated.  Other functions will also be performed by the parser class, at the very least this includes checking the XML document for well-formedness.

.TP
\fI\fB\fI reset\fR\fR\fP 
\fI reset\fR\fP
.PP
Initialises the parser object in preparation for parsing a new XML document.

.RE

.SH CALLBACK RETURN CODES

.PP
Every callback script evaluated by a parser may return a return code other than \fI TCL_OK.  Return codes are interpreted as follows:

.RS
.TP
\fIbreak\fP Suppresses invocation of all further callback scripts.  The parse method returns the TCL_OK return code.
.TP
\fIcontinue\fP Suppresses invocation of further callback scripts until the current element has finished.
.TP
\fIerror\fP Suppresses invocation of all further callback scripts.  The parse method also returns the TCL_ERROR return code.
.TP
\fIdefault\fP Any other return code suppresses invocation of all further callback scripts.  The parse method returns the same return code.
.RE

.SH ERROR MESSAGES

.PP
If an error or warning condition is detected then an error message is returned.  These messages are structured as a Tcl list, as described below:
.PP
.CS
{domain level code node line message int1 int2 string1 string2 string3}
.CE

.RS
.TP
\fI\fB\fR\fP 

.PP
A code for the subsystem that detected the error.

.TP
\fI\fB\fR\fP 

.PP
Severity level of the problem.

.TP
\fI\fB\fR\fP 

.PP
A one word string describing the error.

.TP
\fI\fB\fR\fP 

.PP
If available, the token of the DOM node associated with the problem.

.TP
\fI\fB\fR\fP 

.PP
If known, the line number in the source XML document where the problem was detected.

.TP
\fI\fB\fR\fP 

.PP
A human-readable description of the problem.

.TP
\fI\fB\fR\fP 

.PP
Additional integer data.  For the parser domain, this is usually the column number where the problem was detected.

.TP
\fI\fB\fR\fP 

.PP
Additional integer data.

.TP
\fI\fB\fR\fP 

.PP
Additional string data.

.TP
\fI\fB\fR\fP 

.PP
Additional string data.

.TP
\fI\fB\fR\fP 

.PP
Additional string data.

.RE

.SH APPLICATION EXAMPLES

.PP
This script outputs the character data of an XML document read from stdin.
.PP
.CS

package require xml

proc cdata {data args} {
    puts -nonewline $data
}

set parser [::xml::parser -characterdatacommand cdata]
$parser parse [read stdin]
      
.CE

.PP
This script counts the number of elements in an XML document read from stdin.
.PP
.CS

package require xml

proc EStart {varName name attlist args} {
    upvar #0 $varName var
    incr var
}

set count 0
set parser [::xml::parser -elementstartcommand [list EStart count]]
$parser parse [read stdin]
puts "The XML document contains $count elements"
      
.CE

.SH PARSER CLASSES

.PP
This section will discuss how a parser class is implemented.
.SS Tcl Parser Class

.PP
The pure-Tcl parser class requires no compilation - it is a collection of Tcl scripts.  This parser implementation is non-validating, ie. it can only check well-formedness in a document.  However, by enabling the \fI -validate\fR option it will read the document's DTD and resolve external entities.  This parser class is referred to as TclXML/tcl.

.PP
This parser implementation aims to implement XML v1.0 and supports XML Namespaces.

.PP
Generally the parser produces XML Infoset information items.  That is, it gives the application a slightly higher-level view than the raw XML syntax.  For example, it does not report CDATA Sections.

.PP
TclXML/tcl is not able to handle character encodings other than UTF-8.
.SS Expat Parser Class

.PP
This section will discuss the Expat parser class.
.SS libxml2 Parser Class

.PP
The libxml2 parser class provides a Tcl interface to the libxml2 XML parser library.  This parser class is referred to as TclXML/libxml2.

.PP
When the package is loaded the variable  is set to the version number of the libxml2 library being used.
.SS get Method

.PP
TclXML/libxml2 provides the following arguments to the get method:

.RS
.TP
\fI\fB\fI document\fR\fP 

.PP
Returns the parsed document object.  libxml2 builds an in-memory data structure of the XML document it parses (a DOM tree).  This method returns a handle (or token) for that structure.

.PP
TclXML/libxml2 manages the document object as a Tcl object.  See the \fI -keep\fR for further information.

.RE
.SS Additional Options

.RS
.TP
\fI\fB\fI -keep\fR\fR\fP 
\fI -keep\fR\fI normal | implicit\fP
.PP
Controls how the TclXML/libxml2 packages manages the document object.  The default value is ; the document is destroyed when the Tcl Object's internal representation is freed.  If the option is given the value  then the document must be explicit destroyed.  The only way to explicitly destroy the document is by using the C API.

.TP
\fI\fB\fI -retainpath\fR\fR\fP 
\fI -retainpath\fR\fI \fIxpath\fR\fP
.PP
The given XPath location path specifies which part of the document is to be kept after the parsing operation has completed.  By default, all document data is discard after it has been parsed.

.TP
\fI\fB\fI -retainpathns\fR\fR\fP 
\fI -retainpathns\fR\fI \fIprefix ns ...\fR\fP
.PP
The value of this option is a list of pairs of XML Namespace prefixes and their corresponding namespace URIs.  These are used by the XPath location path given in the \fI -retainpath option.

.RE
.SS Limitations

.PP
The libxml2 parser classes has the following limitations:

.SH SEE ALSO

.PP
TclDOM, a Tcl interface for the W3C Document Object Model.

.SH KEYWORDS
