%
% intro.inc - tcng introduction
%
% Written 2002-2004 by Werner Almesberger
% Copyright 2002 Bivio Networks, Network Robots, Werner Almesberger
% Copyright 2003,2004 Werner Almesberger
%


%------------------------------------------------------------------------------


This document describes the ``next generation'' system for configuring
traffic control on the Linux platform. We give a general overview of
the system in this chapter, continue with a definition of the
\prog{tcng} configuration language in chapter \ref{chptcng}, with additional
background information in chapters \ref{chphood} and \ref{chphist},
describe the traffic control compiler \prog{tcc} and the simulation
framework \prog{tcsim} in chapters \ref{chptcc} and \ref{chptcsim},
respectively, and conclude with a description of the interface
\prog{tcc} uses to communicate with external programs (for specialized
traffic control mechanisms) in chapter \ref{chpext}.

Appendix \ref{appparam} contains a reference of all the parameters
used by traffic control elements.

This document describes version \emphasize{9m} of the \prog{tcng} system.


%------------------------------------------------------------------------------


\section{What is \prog{tcng} ?}

Traffic control ``next generation'' is a revision of the network traffic
control infrastructure of Linux. Its goals are to overcome shortcomings
of the existing architecture, and to make it more extensible. 

Perhaps the most important aspect of \prog{tcng} is that it provides a
compact and clean configuration language in which traffic control
systems can be expressed in an intuitive way. The \prog{tcng} language
is closely modeled after common programming languages like C, Perl, or
Java, which considerably reduces the learning effort for those already
familiar with these languages.

Another important goal of \prog{tcng} is to abstract the configuration
process sufficiently from the actual implementation that different types
of implementations can be configured with the same system. For example,
\prog{tcng} can configure the ``old'' software-based traffic control in
the Linux kernel as well as QoS on the Bivio Networks platform, which is
extensively based on hardware acceleration.

Last but not least, \prog{tcng} also provides information necessary for
interaction with network management and monitoring components.

The home page of the \prog{tcng} project is at
\url{http://tcng.sourceforge.net/}


%------------------------------------------------------------------------------


\section{System overview}

In this section, we describe the principal components of the \prog{tcng}
system: the traffic control compiler \prog{tcc} and the traffic control
simulator \prog{tcsim}.


% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


\subsection{Traffic control compiler}

\prog{tcc} translates configuration scripts from the \prog{tcng} language
into a multitude of output formats used to configure traffic control
subsystems.

\begin{figure}[ht]
\begin{center}
\epsfig{file=tccsys.eps}
\end{center}
\caption{Internal structure and interfaces of \prog{tcc}}
\label{tccsys}
\end{figure}

As shown in figure \ref{tccsys}, \prog{tcc} takes its input from a script
or program, invokes the appropriate input parser to translate the
configuration data into a common internal data structure, and then invokes
one or more output generators (called ``targets'') to issue commands to
 the corresponding output processor(s). 

Output processors translate the output from \prog{tcc} into actions
understood by lower-level components, e.g. with the \name{tc} target,
\prog{tc} sends configuration messages over the netlink interface.
For the \name{c} target, \prog{gcc} builds a customized loadable kernel
module, a \prog{tc} module, plus the \prog{tc} commands necessary to
activate the kernel module. For the \name{external} target, \prog{tcc}
generates a simplified representation of the configuration, and passes
this to an external program, which in turn may translate it to instructions
for hardware accelerators, such as a network processor.

\prog{tcc} currently only supports static configurations. Dynamic
configuration will be studied in the future.


% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


\subsection{Traffic control simulator}

\prog{tcsim} is used to simulate the behaviour of Linux Traffic Control
at a very high level of detail. This is used mainly for the following
purposes:
\begin{itemize}
  \item validation of configurations generated by \name{tcc}
  \item development of configuration scripts
  \item testing of traffic control components
\end{itemize}

\begin{figure}[ht]
\begin{center}
\epsfig{file=tcsimsys.eps}
\end{center}
\caption{\prog{tcsim} internals and helper programs.}
\label{tcsimsys}
\end{figure}

\prog{tcsim} directly supports configuration using the old (\prog{tc})
configuration
language, and it supports the new (\prog{tcng}) language by automatically
invoking \prog{tcc}, and integrating its output. 

\prog{tcsim} combines the original traffic control code from the Linux
kernel with the user-space code of the configuration utility \prog{tc},
and adds the framework for communication among the two, plus an
event-driven simulation engine. 

The resulting program runs entirely in user space, but executes almost
exactly the same code as a ``real'' system (it even mimics loadable kernel
modules), approximating the behaviour of traffic control in a Linux system
much more accurately than a more general simulator (e.g. ns-2) would. 

As shown in figure \ref{tcsimsys}, \prog{tcsim} processes a script
defining the system configuration and the data to send, and generates a
message trace, which can then be processed to obtain statistics or
graphs. Interaction among individual traffic control components can be
included in trace output. 
 
\prog{tcsim} is also useful when developing new traffic control
configurations, be it in the old or in the new language.


%------------------------------------------------------------------------------


\section{Installing \prog{tcng}}

The source code of \prog{tcng} can be downloaded from the project's
home page, \url{http://tcng.sourceforge.net/}

After extracting the archive, further build and installation instructions
can be found in the file \url{tcng/README}


%------------------------------------------------------------------------------


\section{Using all of \prog{tcng} in six easy steps}

This is a tiny example that shows how \prog{tcc} and \prog{tcsim} are
typically used with the traffic control subsystem in the Linux
kernel.

The configuration shall drop all packets leaving the router via the
interface \name{eth0}, unless they originate from the HTTP port.

\begin{description}
  \item[Step 1:] Write a file with the \prog{tcng} configuration.
    We shall call the file \url{example.tc}:
 
\begin{verbatim}
dev eth0 {
    egress {
        drop if tcp_sport != PORT_HTTP;
    }
}
\end{verbatim}

  \item[Step 2:] Run \prog{tcc} to convert the \prog{tcng}
    configuration to \prog{tc} commands. We save the output in
    a file called \url{example.sh}:

\begin{verbatim}
tcc -r example.tc >example.sh
\end{verbatim}

    The \raw{-r} switch tells \prog{tcc} to emit a command to remove
    any traffic control setup that may be in use at \name{eth0}
    before trying to add the new configuration.

    You can look at the resulting output with \verb"cat example.sh",
    but it will look rather cryptic.

  \item[Step 3:] It is frequently desirable to test more complicated
    configurations by simulation before using them. Although our
    example is quite simple, we shall use the simulator too.

    First, we create a file \url{example.tcsim}:

\begin{verbatim}
#include "packet.def"
#include "ports.tc"

dev eth0 100 Mbps {
    #include "example.tc"
}

send TCP_PCK($tcp_sport = PORT_HTTP);
send TCP_PCK($tcp_sport = PORT_SSH);
end
\end{verbatim}

    This defines a simulation environment with one interface called
    \name{eth0}, running at 100 Mbps, to which the example configuration
    is applied. The simulation consists of sending two packets, and
    waiting until the system is idle again.

  \item[Step 4:] Run the simulation with \prog{tcsim}:

\begin{verbatim}
tcsim -s 22 example.tcsim
\end{verbatim}

We use the \raw{-s} option to reduce the output generated by \prog{tcsim}.
The output looks like this:
{\scriptsize
\begin{verbatim}
0.000000 E : 0x80bd560 40 : eth0: 45000028 00000000 40060000 0a000001 0a000002 0050 ...
0.000000 D : 0x80bd560 40 : eth0: 45000028 00000000 40060000 0a000001 0a000002 0050 ...
0.000000 E : 0x80bd870 40 : eth0: 45000028 00000000 40060000 0a000001 0a000002 0016 ...
0.000000 * : 0x80bd870 40 : eth0: enqueue returns POLICED (3)
\end{verbatim}
}
  \item[Step 5:] We verify that the configuration did indeed work:
    The first packet was enqueued (``E''), and then dequeued (``D'').
    When trying to enqueue the second packet, it was rejected.

  \item[Step 6:] We are now ready to load the example on a live system.
    As super-user, execute the \prog{tc} commands to create the
    configuration in the kernel:

\begin{verbatim}
sh example.sh
\end{verbatim}

    Note: this step only works if traffic control is configured into the
    kernel and if a recent version of \path{iproute2/tc} with support for
    Differentiated Services is installed.\footnote{An error message like
    \raw{RTNETLINK answers: Invalid argument} indicates that the kernel
    does not contain support for traffic control, or that some elements
    are not enabled. A message like
    \raw{example.sh: tc: command not found} indicates that \path{iproute2/tc}
    is not installed at all, while a message like
    \raw{Unknown qdisc "dsmark", hence option "dev" is unparsable}
    indicates that \path{iproute2/tc} was built without support for
    Differentiated Services.}
\end{description}

More information about writing \prog{tcng} configurations can be
found in chapter \ref{chptcng} and the following chapters. \prog{tcc}
usage is described in detail in chapter \ref{chptcc}, and \prog{tcsim}
is described in chapter \ref{chptcsim}.


%==============================================================================
