/*
 * tcpick.c -- main project file
 * Part of the tcpick project
 *
 * Author: Francesco Stablum <duskdruid @ despammed.com>
 *
 * Copyright (C) 2003, 2004  Francesco Stablum
 * Licensed under the GPL
 *
 */

/* 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at you option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111,
 * USA.
 *
 * Please read the COPYING file for the license details!
 */

/*
 * tcpick project needs somebody suggesting me bugs and new features!
 * If you want to contribute sending patches, finding bugs, compilation
 * errors, platform-specific incompatibilies you are invited to the tcpick
 * mailing-list:
 *
 * email address: 
 *   <tcpick-project@lists.sourceforge.net>
 * Archive:
 *   http://sourceforge.net/mailarchive/forum.php?forum=tcpick-project
 * Subscribe:
 *   http://lists.sourceforge.net/lists/listinfo/tcpick-project
 */

/*
 * in the code you will find many (sooo many) FIXME's: it means that
 * I (or somebody else) should improve the code.
 */

#include "tcpick.h"
#include "globals.h"

struct flags_t flags;

char *errbuf[PCAP_ERRBUF_SIZE];
struct bpf_program filter_compiled;
bpf_u_int32 netp; /* ip */
bpf_u_int32 maskp; /* subnet mask */
struct in_addr addr;
char *other_args = NULL;
pcap_t *descr;
const u_char *packet;
u_char *curr_char;
int curr_pos = 0;
struct pcap_pkthdr hdr;

extern void got_packet();

int main(int argc, char **argv) 
{
	char tbuf[128];
	struct tm *tm;
	time_t now;
		
	parse_args(argc, argv);
	
	/* time stuff stolen by Fyodor's nmap */
	now = time(NULL);
	if (!(tm = localtime(&now)))
		fault("main", "Unable to get current localtime()");
	if (strftime(tbuf, sizeof(tbuf), "%Y-%m-%d %H:%M %Z", tm) <= 0)
		fault("main", "Unable to properly format time");
	
	msg( 1, c_WELCOME,
	     "Starting " PACKAGE_STRING " at %s", tbuf );
	
	if( flags.trackonly > -1 )
		msg( 1, c_SETTING,
		     "Number of connections that will be tracked: %i",
		     flags.trackonly );
	

	if( flags.exitclosed ) {
		if( flags.exitclosed_first )
			msg(1, c_SETTING, 
			    "when _the first_ %i tracked "
			    "connections will be closed, tcpick exits",
			    flags.exitclosed );
		else
			msg(1, c_SETTING, 
			    "when %i tracked connections "
			    "will be closed, tcpick exits",
			    flags.exitclosed );
	}
	/* I hope this was clear enough */
	
			
	/* making the filter working */
	if( ( dev == NULL ) && ( readfile == NULL ) ) {
		dev = pcap_lookupdev( (char*) errbuf );
	}

	if( ( dev == NULL ) && ( readfile == NULL ) )
		suicide( "main", errbuf );

	if( readfile != NULL ) {
		setuid(getuid());
		msg( 1, c_INTERFACE, 
		     "%s: reading from %s", 
		     TCPICK_NAME, readfile );
	}
	else
		msg( 1, c_INTERFACE, 
		     "%s: listening on %s", 
		     TCPICK_NAME, dev );

	if( dev != NULL) {
		/* ask pcap for the network address and mask of the device */
		ret = pcap_lookupnet( dev, &netp,
				      &maskp, (char *)errbuf);
		if( ret == -1 ) {
			netp = 0;
			maskp = 0;
			err( "%s", errbuf );
		}

		addr.s_addr = netp;
		net = (char *)strdup( inet_ntoa(addr) );
		if(! net )
			fault( "main", "inet_ntoa" );

		addr.s_addr = maskp;
		mask = (char *)strdup( inet_ntoa(addr) );
		if (! mask ) {
			fault( "main", "inet_ntoa" );
		}
	}

	if( ( dev != NULL ) && ( readfile != NULL) ) {
		suicide( "main",
			 "Please specify either a file (with -r <filename>)\n"
			 "\t or an interface (with -i <int>), not both" );
	}

	if( readfile == NULL)
		descr = pcap_open_live( dev, BUFSIZ, flags.notpromisc ? 0 : 1 , -1, (char *)errbuf );
	else
		descr = pcap_open_offline( readfile, (char *)errbuf );

	if( descr == NULL)
		suicide( "main", errbuf );

	/* compiling the filter */
	if( filter != NULL ) {
		msg(1, c_SETTING, "setting filter: \"%s\"",filter);
		
		if( ( pcap_compile( descr,
				    &filter_compiled,
				    filter, 
				    0, 
				    (int)net 
			      ) == -1) )
			err("error compiling filter \"%s\"",filter);

		pcap_setfilter( descr, &filter_compiled );
	}

/* FIXME: next lines SUCKS */
	dl_id = pcap_datalink( descr );
	dl_str = (char *)dl2str( dl_id );
	debug( "Using device: %s", dev );
	debug( "net: %s", mask );
	debug( "mask: %s", mask ); 
	debug( "datalink: %s", dl_str );
  
	dl_size = dl2off( dl_id );
	debug ( "datalink header size set at: +%d", dl_size );

	ip_size = 20;
	debug ( "ip header size set at: +%d", ip_size );

	tcp_size = 20;
	debug ( "tcp header offset set (temporary) at: +%d", tcp_size );

	first_conn = (conn_t *)S_calloc( sizeof(conn_t), 1 );
	last_conn = first_conn;

	pcap_loop( descr, -1, got_packet, NULL ); 
 
	if( readfile ) {
		msg( 1, c_DONE,
			 "%s: done reading from %s", TCPICK_NAME, readfile );
		exit ( TCPICK_SUCCESS );
	} else
		suicide( "main", "exited pcap loop" );

	/* UNREACHED */
	return TCPICK_FAILURE;
}

/*
  well the code of tcpick.c is not written very cleanly, i know :|
  I will improve it in the near future (I hope!)
  FIXME
*/
