/*
 * write.c -- chooses output data
 * Part of the tcpick project
 *
 * Author: Francesco Stablum <duskdruid @ despammed.com>
 *
 * Copyright (C) 2003, 2004  Francesco Stablum
 * Licensed under the GPL
 *
 */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "tcpick.h"
#include "extern.h"

extern struct flags_t flags;

__inline__ char * 
avail_filename(conn_t * conn_ptr, 
	       Part_t side)
/*
  finds an available name for the connection file,
  i.e. sometimes there are same filenames, this is useful
  to invent a different filename
*/
{
	char * base_file_name;
	char * file_name;
	char * ret;
	int num=0;
	struct stat stat_struct;
	/* this gets the name of the host */
	char * clientname;
	char * servername;
	int server_port=conn_ptr->server.port;
  
	base_file_name=(char *)S_calloc(512,1);
	file_name=(char *)S_calloc(512,1);

	clientname = (char *)lookup(conn_ptr->client.ip);
	sprintf(base_file_name,"%s",
		clientname
		);

	servername=(char *)lookup(conn_ptr->server.ip);
	sprintf(base_file_name,"%s_%s_%s",
		base_file_name,
		servername,
		getportname(server_port)
		);

	switch( side ) {
	case CLIENT:
		sprintf(file_name,"client_%s.tcpick",base_file_name);
		while(! stat( file_name, &stat_struct )) {
			num++;
			sprintf(file_name, "client_%s.%x.tcpick",
				base_file_name, num);	  
		}
		break;
		
	case SERVER:
		sprintf(file_name,"server_%s.tcpick",base_file_name);
		while(! stat( file_name, &stat_struct )) {
			num++;
			sprintf(file_name,"server_%s.%x.tcpick",base_file_name,num);	  
		}
		break;
	default:
		sprintf(file_name,"both_%s.tcpick",base_file_name);
		while(! stat( file_name, &stat_struct )) {
			num++;
			sprintf(file_name,"both_%s.%x.tcpick",base_file_name,num);	  
		}
		break;
	}

	/* returning the right pointer and freeing wasted memory */
	
#ifdef HAVE_STRNDUP
	ret = (char *)strndup( file_name, 512 );
#else
	ret = (char *)strdup( file_name );
#endif
	S_free( file_name );
	S_free( base_file_name );
	return ret;
}

FILE * open_file( conn_t * conn_ptr, 
		  struct host_descriptor_t * desc )
{
	char * s;

	/* preparing for the client file*/
	s = (char *)avail_filename( conn_ptr, desc->side );
	desc->file = fopen( s , "a" );
	if(! desc->file)
		fault("open_file", "fopen returned NULL");
	desc->filename = s;
}

__inline__ int
flowflush ( conn_t * conn_ptr, 
	    struct host_descriptor_t * desc, 
	    u_char * buf,
	    int buflen )
/* data that are acknowledged come here in order to be written to
   their file, or to stdout */
{
	/* -b set of options */
	if ( desc->side == flags.display_rebuild.side )
		
		out_flavour ( flags.display_rebuild.flavour,
			      stdout, buf, buflen );
	
	else if ( flags.display_rebuild.side == BOTH )
		
		out_flavour ( flags.display_rebuild.flavour,
			      stdout, buf, buflen );
	
	/* -w set of options */
	if ( desc->side == flags.writer.side ) {
		
		if(! desc->file ) 
			open_file( conn_ptr, desc ); 
		
		out_flavour ( flags.writer.flavour,
			      desc->file, buf, buflen );
	}
	else if ( flags.writer.side == BOTH ) {
		
		if(! desc->file )
			open_file( conn_ptr, desc ); 
		
		out_flavour ( flags.writer.flavour,
			      desc->file, buf, buflen );
	}
}

int 
out_flavour( Flavour_t flavour, 
	     FILE * out, 
	     u_char * buf, 
	     int buflen )
/* chooses the function to call, according to the specified flavour */
{
	if( flags.separator && ( out == stdout ) ) /* FIXME: sucks? */
		color( c_SEPARATOR, stdout, SEPARATOR "\n" );

	switch ( flavour ) {
	case HEX_ASCII_DUMP:
		out_xa( out, buf, buflen );
		break;
	case HEX_DUMP:
		out_x( out, buf, buflen );
		break;
	case RAW:
		fwrite( buf, sizeof(u_char), buflen, out );
		if( DISPLAY_NL )
			fprintf( out, "\n" );
		break;
	case PRINTABLE:
		out_p( out, buf, buflen );
		break;
	case HEX:
		out_h( out, buf, buflen );
		break;
	case HEX_NON_PRINT:
		out_hn( out, buf, buflen );
		break;
	default: /* SILENT ??? */
		break;
	}
}
