/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (flowreplay_opts.c)
 *  
 *  It has been AutoGen-ed  Sunday June 12, 2005 at 10:24:31 PM PDT
 *  From the definitions    flowreplay_opts.def
 *  and the template file   options
 */
#include <stdio.h>
#include <limits.h>
#define OPTION_CODE_COMPILE 1
#include "flowreplay_opts.h"

#ifdef  __cplusplus
extern "C" {
#endif
tSCC zCopyright[] =
       "flowreplay copyright (c) 2004-2005 Aaron Turner, all rights reserved";
tSCC zCopyrightNotice[] =
       "flowreplay is free software copyrighted by Aaron Turner.\n\n\
Redistribution and use in source and binary forms, with or without\n\
modification, are permitted provided that the following conditions\n\
are met:\n\
1. Redistributions of source code must retain the above copyright\n\
   notice, this list of conditions and the following disclaimer.\n\
2. Redistributions in binary form must reproduce the above copyright\n\
   notice, this list of conditions and the following disclaimer in the\n\
   documentation and/or other materials provided with the distribution.\n\
3. Neither the name ``Aaron Turner'' nor the name of any other\n\
   contributor may be used to endorse or promote products derived\n\
   from this software without specific prior written permission.\n\n\
flowreplay IS PROVIDED BY Aaron Turner ``AS IS'' AND ANY EXPRESS\n\
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n\
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n\
ARE DISCLAIMED.  IN NO EVENT SHALL Aaron Turner OR ANY OTHER CONTRIBUTORS\n\
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n\
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n\
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n\
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n\
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\n\
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\n\
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
extern tUsageProc optionUsage;

/*
 *  global included definitions
 */
#include "defines.h"
#include "flowreplay.h"
#include "common.h"
extern char pcap_version[];
extern flowreplay_opt_t options;


#ifndef NULL
#  define NULL 0
#endif
#ifndef EXIT_SUCCESS
#  define  EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#  define  EXIT_FAILURE 1
#endif
/*
 *  Dbug option description:
 */
tSCC    zDbugText[] =
        "Enable debugging output";
tSCC    zDbug_NAME[]               = "DBUG";
tSCC    zDbug_Name[]               = "dbug";
#define zDbugDefaultArg              ((tCC*)0)
#define DBUG_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Verbose option description:
 */
#ifdef HAVE_TCPDUMP
tSCC    zVerboseText[] =
        "Print decoded packets via tcpdump to STDOUT";
tSCC    zVerbose_NAME[]            = "VERBOSE";
tSCC    zVerbose_Name[]            = "verbose";
#define VERBOSE_FLAGS       (OPTST_DISABLED)

#else   /* disable Verbose */
#define VALUE_OPT_VERBOSE NO_EQUIVALENT
#define VERBOSE_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define zVerboseText       NULL
#define zVerbose_NAME      NULL
#define zVerbose_Name      NULL
#endif  /* HAVE_TCPDUMP */

/*
 *  Decode option description with
 *  "Must also have options" and "Incompatible options":
 */
#ifdef HAVE_TCPDUMP
tSCC    zDecodeText[] =
        "Arguments passed to tcpdump decoder";
tSCC    zDecode_NAME[]             = "DECODE";
tSCC    zDecode_Name[]             = "decode";
static const int
    aDecodeMustList[] = {
    INDEX_OPT_VERBOSE, NO_EQUIVALENT };
#define DECODE_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

#else   /* disable Decode */
#define VALUE_OPT_DECODE NO_EQUIVALENT
#define DECODE_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define aDecodeMustList   NULL
#define zDecodeText       NULL
#define zDecode_NAME      NULL
#define zDecode_Name      NULL
#endif  /* HAVE_TCPDUMP */

/*
 *  Mode option description:
 */
tSCC    zModeText[] =
        "Replay mode";
tSCC    zMode_NAME[]               = "MODE";
tSCC    zMode_Name[]               = "mode";
#define MODE_FLAGS       (OPTST_DISABLED | OPTST_MUST_SET \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Wait option description:
 */
tSCC    zWaitText[] =
        "Number of sec.usec to wait between client's turn to send";
tSCC    zWait_NAME[]               = "WAIT";
tSCC    zWait_Name[]               = "wait";
#define WAIT_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Targetip option description:
 */
tSCC    zTargetipText[] =
        "Target host to connect to";
tSCC    zTargetip_NAME[]           = "TARGETIP";
tSCC    zTargetip_Name[]           = "targetip";
#define TARGETIP_FLAGS       (OPTST_DISABLED | OPTST_MUST_SET \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Filter option description:
 */
tSCC    zFilterText[] =
        "BPF filter to limit which flows are replayed";
tSCC    zFilter_NAME[]             = "FILTER";
tSCC    zFilter_Name[]             = "filter";
#define FILTER_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Clientnet option description:
 */
tSCC    zClientnetText[] =
        "Client network(s)";
tSCC    zClientnet_NAME[]          = "CLIENTNET";
tSCC    zClientnet_Name[]          = "clientnet";
#define CLIENTNET_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Servernet option description:
 */
tSCC    zServernetText[] =
        "Server network(s)";
tSCC    zServernet_NAME[]          = "SERVERNET";
tSCC    zServernet_Name[]          = "servernet";
#define SERVERNET_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Nosyn option description:
 */
tSCC    zNosynText[] =
        "Disable Syn packet requirement to start connections";
tSCC    zNosyn_NAME[]              = "NOSYN";
tSCC    zNosyn_Name[]              = "nosyn";
#define NOSYN_FLAGS       (OPTST_DISABLED)

/*
 *  Slimit option description:
 */
tSCC    zSlimitText[] =
        "Service limit to proto/port";
tSCC    zSlimit_NAME[]             = "SLIMIT";
tSCC    zSlimit_Name[]             = "slimit";
#define SLIMIT_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Version option description:
 */
tSCC    zVersionText[] =
        "Print version information";
tSCC    zVersion_NAME[]            = "VERSION";
tSCC    zVersion_Name[]            = "version";
#define VERSION_FLAGS       (OPTST_DISABLED)

/*
 *  Less_Help option description:
 */
tSCC    zLess_HelpText[] =
        "Display less usage information and exit";
tSCC    zLess_Help_NAME[]          = "LESS_HELP";
tSCC    zLess_Help_Name[]          = "less-help";
#define LESS_HELP_FLAGS       (OPTST_DISABLED)

/*
 *  Help/More_Help option descriptions:
 */
tSCC zHelpText[]       = "Display usage information and exit";
tSCC zHelp_Name[]      = "help";

tSCC zMore_HelpText[]  = "Extended usage information passed thru pager";
tSCC zMore_Help_Name[] = "more-help";

/*
 *  Save/Load_Opts option description:
 */
tSCC zSave_OptsText[]     = "Save the option state to a config file";
tSCC zSave_Opts_Name[]    = "save-opts";

tSCC zLoad_OptsText[]     = "Load options from a config file";
tSCC zLoad_Opts_NAME[]    = "LOAD_OPTS";

tSCC zNotLoad_Opts_Name[] = "no-load-opts";
tSCC zNotLoad_Opts_Pfx[]  = "no";
#define zLoad_Opts_Name   (zNotLoad_Opts_Name + 3)
/*
 *  Declare option callback procedures
 */
extern tOptProc
    optionPagedUsage;
static tOptProc
    doOptClientnet, doOptDbug,      doOptLess_Help, doOptMode,
    doOptNosyn,     doOptServernet, doOptSlimit,    doOptTargetip,
    doOptVersion,   doOptWait,      doUsageOpt;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Flowreplay Option Descriptions.
 */
static tOptDesc optDesc[ OPTION_CT ] = {
  {  /* entry idx, value */ 0, VALUE_OPT_DBUG,
     /* equiv idx, value */ 0, VALUE_OPT_DBUG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DBUG_FLAGS, 0,
     /* last opt argumnt */ zDbugDefaultArg,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptDbug,
     /* desc, NAME, name */ zDbugText, zDbug_NAME, zDbug_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_VERBOSE,
     /* equiv idx, value */ 1, VALUE_OPT_VERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERBOSE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zVerboseText, zVerbose_NAME, zVerbose_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_DECODE,
     /* equiv idx, value */ 2, VALUE_OPT_DECODE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DECODE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aDecodeMustList, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zDecodeText, zDecode_NAME, zDecode_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_MODE,
     /* equiv idx, value */ 3, VALUE_OPT_MODE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 1, 1, 0,
     /* opt state flags  */ MODE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptMode,
     /* desc, NAME, name */ zModeText, zMode_NAME, zMode_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_WAIT,
     /* equiv idx, value */ 4, VALUE_OPT_WAIT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ WAIT_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptWait,
     /* desc, NAME, name */ zWaitText, zWait_NAME, zWait_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_TARGETIP,
     /* equiv idx, value */ 5, VALUE_OPT_TARGETIP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 1, 1, 0,
     /* opt state flags  */ TARGETIP_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptTargetip,
     /* desc, NAME, name */ zTargetipText, zTargetip_NAME, zTargetip_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 6, VALUE_OPT_FILTER,
     /* equiv idx, value */ 6, VALUE_OPT_FILTER,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ FILTER_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zFilterText, zFilter_NAME, zFilter_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 7, VALUE_OPT_CLIENTNET,
     /* equiv idx, value */ 7, VALUE_OPT_CLIENTNET,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CLIENTNET_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptClientnet,
     /* desc, NAME, name */ zClientnetText, zClientnet_NAME, zClientnet_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 8, VALUE_OPT_SERVERNET,
     /* equiv idx, value */ 8, VALUE_OPT_SERVERNET,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SERVERNET_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptServernet,
     /* desc, NAME, name */ zServernetText, zServernet_NAME, zServernet_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 9, VALUE_OPT_NOSYN,
     /* equiv idx, value */ 9, VALUE_OPT_NOSYN,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NOSYN_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptNosyn,
     /* desc, NAME, name */ zNosynText, zNosyn_NAME, zNosyn_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 10, VALUE_OPT_SLIMIT,
     /* equiv idx, value */ 10, VALUE_OPT_SLIMIT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SLIMIT_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptSlimit,
     /* desc, NAME, name */ zSlimitText, zSlimit_NAME, zSlimit_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 11, VALUE_OPT_VERSION,
     /* equiv idx, value */ 11, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERSION_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptVersion,
     /* desc, NAME, name */ zVersionText, zVersion_NAME, zVersion_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 12, VALUE_OPT_LESS_HELP,
     /* equiv idx, value */ 12, VALUE_OPT_LESS_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ LESS_HELP_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptLess_Help,
     /* desc, NAME, name */ zLess_HelpText, zLess_Help_NAME, zLess_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ zHelpText, NULL, zHelp_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ zMore_HelpText, NULL, zMore_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                          | OPTST_ARG_OPTIONAL, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zSave_OptsText, NULL, zSave_Opts_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_DISABLE_IMM | \
			OPTST_SET_ARGTYPE(OPARG_TYPE_STRING), 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ zLoad_OptsText, zLoad_Opts_NAME, zLoad_Opts_Name,
     /* disablement strs */ zNotLoad_Opts_Name, zNotLoad_Opts_Pfx }
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Flowreplay Option Environment
 */
tSCC   zPROGNAME[]   = "FLOWREPLAY";
tSCC   zUsageTitle[] =
"flowreplay - Connect to servers based on network traffic stored in pcap files\n\
USAGE:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... <pcap_file(s)>\n";
tSCC   zRcName[]     = ".flowreplayrc";
tSCC*  apzHomeList[] = {
       "$$/",
       NULL };

#define zBugsAddr NULL
tSCC   zExplain[]     = "\n\
flowreplay is a tool for using network traffic stored in pcap(3) files as\n\
the basis for replaying connections to servers.\n";
tSCC    zDetail[]     = "\n\
Please note that flowreplay is currently in *alpha*.  As such, it is still\n\
very much a work in progress and currently will not work for most uses.  If\n\
you have the skill and interest to help make flowreplay work better, please\n\
contact Aaron Turner.\n";
#define zFullVersion    NULL
/* extracted from /usr/local/share/autogen/optcode.tpl near line 309 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

tOptions flowreplayOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_ARGS_REQ
    + OPTPROC_GNUUSAGE
    + OPTPROC_HAS_IMMED ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zCopyrightNotice,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage,       /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP,
      INDEX_OPT_SAVE_OPTS,
      NO_EQUIVALENT /* index of '-#' option */,
      4 /* index of default opt */
    },
    OPTION_CT, 13 /* user option count */
};

/*
 *  Create the static procedure(s) declared above.
 */
static void
doUsageOpt(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    USAGE( EXIT_SUCCESS );
}

/* * * * * * *
 *
 *   For the dbug option.
 */
static void
doOptDbug(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 5 } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the mode option.
 */
static void
doOptMode(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

if (strcasecmp(OPT_ARG(MODE), "send") == 0) {
options.sendmode = MODE_SEND;
} else if (strcasecmp(OPT_ARG(MODE), "wait") == 0) {
options.sendmode = MODE_WAIT;
} else if (strcasecmp(OPT_ARG(MODE), "bytes") == 0) {
options.sendmode = MODE_BYTES;
} else if (strcasecmp(OPT_ARG(MODE), "user") == 0) {
options.sendmode = MODE_USER;
} else {
errx(1, "Invalid --mode: %s", OPT_ARG(MODE));
}

}

/* * * * * * *
 *
 *   For the wait option.
 */
static void
doOptWait(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

float2timer(atof(OPT_ARG(WAIT)), &options.timeout);

}

/* * * * * * *
 *
 *   For the targetip option.
 */
static void
doOptTargetip(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

#ifdef INET_ATON
if (inet_aton(OPT_ARG(TARGETIP), &options.targetaddr) == 0)
errx(1, "Invalid target IP address: %s", OPT_ARG(TARGETIP));
#else
if ((options.targetaddr.s_addr = inet_addr(OPT_ARG(TARGETIP))) == -1)
errx(1, "Invalid target IP address: %s", OPT_ARG(TARGETIP));
#endif

}

/* * * * * * *
 *
 *   For the clientnet option.
 */
static void
doOptClientnet(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
  
    char *cidr = safe_strdup(OPT_ARG(CLIENTNET));
    if (!parse_cidr(&options.clients, cidr, ","))
        errx(1, "Unable to parse CIDR: %s", OPT_ARG(CLIENTNET));
    free(cidr);

}

/* * * * * * *
 *
 *   For the servernet option.
 */
static void
doOptServernet(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

char *cidr = safe_strdup(OPT_ARG(SERVERNET));
if (!parse_cidr(&options.servers, cidr, ","))
errx(1, "Unable to parse CIDR: %s", OPT_ARG(SERVERNET));
free(cidr);

}

/* * * * * * *
 *
 *   For the nosyn option.
 */
static void
doOptNosyn(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

options.nosyn = 1;

}

/* * * * * * *
 *
 *   For the slimit option.
 */
static void
doOptSlimit(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

char *p_parse = NULL, *myarg;
myarg = safe_strdup(OPT_ARG(SLIMIT));

p_parse = strtok(myarg, "/");
if (strcasecmp(p_parse, "TCP") == 0) {
options.proto = IPPROTO_TCP;
} else if (strcasecmp(p_parse, "UDP") == 0) {
options.proto = IPPROTO_UDP;
} else {
errx(1, "Unsupported protocol: %s", p_parse);
}

/* if port is specified, set it */
if ((p_parse = strtok(NULL, "/")))
options.port = htons(atoi(p_parse));

}

/* * * * * * *
 *
 *   For the version option.
 */
static void
doOptVersion(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    fprintf(stderr, "flowreplay version: %s (build %s)", VERSION, svn_version());
#ifdef DEBUG
    fprintf(stderr, " (debug)");
#endif
    fprintf(stderr, "\n");
    fprintf(stderr, "Copyright 2001-2005 by Aaron Turner <aturner@pobox.com>\n");
    fprintf(stderr, "Compiled against libnet: %s\n", LIBNET_VERSION);
    fprintf(stderr, "Compiled against libpcap: %s\n", pcap_version);
#ifdef ENABLE_64BITS
    fprintf(stderr, "64 bit packet counters: enabled\n");
#else
    fprintf(stderr, "64 bit packet counters: disabled\n");
#endif
#ifdef HAVE_TCPDUMP
    fprintf(stderr, "Verbose printing via tcpdump: enabled\n");
#else
    fprintf(stderr, "Verbose printing via tcpdump: disabled\n");
#endif
    exit(0);
    
}

/* * * * * * *
 *
 *   For the less-help option.
 */
static void
doOptLess_Help(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
  
    USAGE(EXIT_FAILURE);

}

/* extracted from /usr/local/share/autogen/optcode.tpl near line 396 */

#if ENABLE_NLS
#include <string.h>
#include <stdio.h>
#include <autoopts/usage-txt.h>

static char*
AO_gettext( const char* pz )
{
    char* pzRes;
    if (pz == NULL)
        return NULL;
    pzRes = _(pz);
    if (pzRes == pz)
        return pzRes;
    pzRes = strdup( pzRes );
    if (pzRes == NULL) {
        fputs( _("No memory for duping translated strings\n"), stderr );
        exit( EXIT_FAILURE );
    }
    return pzRes;
}

/*
 *  This invokes the translation code (e.g. gettext(3)).
 */
static void
translate_option_strings( void )
{
    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_usage_text.field_ct == 0)
        return;
    /*
     *  Do the translations.  The first pointer follows the field count field.
     *  The field count field is the size of a pointer.
     */
    {
        char** ppz = (char**)(void*)&(option_usage_text);
        int    ix  = option_usage_text.field_ct;

        do {
            ppz++;
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
    }
    option_usage_text.field_ct = 0;

    {
        tOptDesc* pOD = flowreplayOptions.pOptDesc;
        int       ix  = flowreplayOptions.optCt;

        for (;;) {
            pOD->pzText           = AO_gettext(pOD->pzText);
            pOD->pz_NAME          = AO_gettext(pOD->pz_NAME);
            pOD->pz_Name          = AO_gettext(pOD->pz_Name);
            pOD->pz_DisableName   = AO_gettext(pOD->pz_DisableName);
            pOD->pz_DisablePfx    = AO_gettext(pOD->pz_DisablePfx);
            if (--ix <= 0)
                break;
            pOD++;
        }
    }
    flowreplayOptions.pzCopyright   = AO_gettext(flowreplayOptions.pzCopyright);
    flowreplayOptions.pzCopyNotice  = AO_gettext(flowreplayOptions.pzCopyNotice);
    flowreplayOptions.pzFullVersion = AO_gettext(flowreplayOptions.pzFullVersion);
    flowreplayOptions.pzUsageTitle  = AO_gettext(flowreplayOptions.pzUsageTitle);
    flowreplayOptions.pzExplain     = AO_gettext(flowreplayOptions.pzExplain);
    flowreplayOptions.pzDetail      = AO_gettext(flowreplayOptions.pzDetail);
}

#endif /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
