/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (tcpprep_opts.h)
 *  
 *  It has been AutoGen-ed  Tuesday June 28, 2005 at 10:04:40 AM PDT
 *  From the definitions    tcpprep_opts.def
 *  and the template file   options
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the tcpprep program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_TCPPREP_OPTS_H_GUARD
#define AUTOOPTS_TCPPREP_OPTS_H_GUARD

/*
 * tcpprep copyright 2000 - 2004 Aaron Turner - all rights reserved
 *
 * tcpprep is free software copyrighted by Aaron Turner.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name ``Aaron Turner'' nor the name of any other
 *    contributor may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 
 * tcpprep IS PROVIDED BY Aaron Turner ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Aaron Turner OR ANY OTHER CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"
#include <autoopts/options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_DBUG             =  0,
        INDEX_OPT_AUTO             =  1,
        INDEX_OPT_CIDR             =  2,
        INDEX_OPT_REGEX            =  3,
        INDEX_OPT_PORT             =  4,
        INDEX_OPT_COMMENT          =  5,
        INDEX_OPT_NO_ARG_COMMENT   =  6,
        INDEX_OPT_INCLUDE          =  7,
        INDEX_OPT_EXCLUDE          =  8,
        INDEX_OPT_CACHEFILE        =  9,
        INDEX_OPT_PCAP             = 10,
        INDEX_OPT_PRINT_COMMENT    = 11,
        INDEX_OPT_PRINT_INFO       = 12,
        INDEX_OPT_SERVICES         = 13,
        INDEX_OPT_NONIP            = 14,
        INDEX_OPT_RATIO            = 15,
        INDEX_OPT_MINMASK          = 16,
        INDEX_OPT_MAXMASK          = 17,
        INDEX_OPT_VERBOSE          = 18,
        INDEX_OPT_DECODE           = 19,
        INDEX_OPT_VERSION          = 20,
        INDEX_OPT_LESS_HELP        = 21,
        INDEX_OPT_HELP             = 22,
        INDEX_OPT_MORE_HELP        = 23,
        INDEX_OPT_SAVE_OPTS        = 24,
        INDEX_OPT_LOAD_OPTS        = 25
} teOptIndex;

#define OPTION_CT    26

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( DBUG )
 */
#define         DESC(n) tcpprepOptions.pOptDesc[INDEX_OPT_ ## n]
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_DBUG           'd'
#define OPT_VALUE_DBUG           (*(unsigned long*)(&DESC(DBUG).pzLastArg))
#define VALUE_OPT_AUTO           'a'
#define VALUE_OPT_CIDR           'c'
#define VALUE_OPT_REGEX          'r'
#define VALUE_OPT_PORT           'p'
#define VALUE_OPT_COMMENT        'C'
#define VALUE_OPT_NO_ARG_COMMENT 6
#define VALUE_OPT_INCLUDE        'x'
#define VALUE_OPT_EXCLUDE        'X'
#define VALUE_OPT_CACHEFILE      'o'
#define VALUE_OPT_PCAP           'i'
#define VALUE_OPT_PRINT_COMMENT  'P'
#define VALUE_OPT_PRINT_INFO     'I'
#define VALUE_OPT_SERVICES       's'
#define VALUE_OPT_NONIP          'N'
#define VALUE_OPT_RATIO          'R'
#define VALUE_OPT_MINMASK        'm'
#define OPT_VALUE_MINMASK        (*(unsigned long*)(&DESC(MINMASK).pzLastArg))
#define VALUE_OPT_MAXMASK        'M'
#define OPT_VALUE_MAXMASK        (*(unsigned long*)(&DESC(MAXMASK).pzLastArg))
#ifdef HAVE_TCPDUMP
#define VALUE_OPT_VERBOSE        'v'
#define SET_OPT_VERBOSE   STMTS( \
        DESC(VERBOSE).optActualIndex = 18; \
        DESC(VERBOSE).optActualValue = VALUE_OPT_VERBOSE; \
        DESC(VERBOSE).fOptState &= OPTST_PERSISTENT; \
        DESC(VERBOSE).fOptState |= OPTST_SET )
#endif /* HAVE_TCPDUMP */
#ifdef HAVE_TCPDUMP
#define VALUE_OPT_DECODE         'A'
#endif /* HAVE_TCPDUMP */
#define VALUE_OPT_VERSION        'V'
#define VALUE_OPT_LESS_HELP      'h'

#define VALUE_OPT_SAVE_OPTS     INDEX_OPT_SAVE_OPTS
#define VALUE_OPT_LOAD_OPTS     INDEX_OPT_LOAD_OPTS
#define VALUE_OPT_HELP          'H'
#define VALUE_OPT_MORE_HELP     '!'
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).pzLastArg  = (tCC*)(a) )

/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS( tcpprepOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define ERRSTOP_OPTERR  STMTS( tcpprepOptions.fOptSet |= OPTPROC_ERRSTOP )
#define RESTART_OPT(n)  STMTS( \
                tcpprepOptions.curOptIdx = (n); \
                tcpprepOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*tcpprepOptions.pUsageProc)( &tcpprepOptions, c )
/* extracted from /usr/local/share/autogen/opthead.tpl near line 246 */

/* * * * * *
 *
 *  Declare the tcpprep option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   tcpprepOptions;

#ifndef _
#  if ENABLE_NLS
#    include <stdio.h>
     static inline char* aoGetsText( const char* pz ) {
         if (pz == NULL) return NULL;
         return (char*)gettext( pz );
     }
#    define _(s)  aoGetsText(s)
#  else  /* ENABLE_NLS */
#    define _(s)  s
#  endif /* ENABLE_NLS */
#endif

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_TCPPREP_OPTS_H_GUARD */
