/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-message-bus.h:
 * D-Bus' message bus.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_MESSAGE_BUS_H__
#define __TI_MESSAGE_BUS_H__

#include <glib-object.h>

/*
 * Type macros.
 */

typedef struct _TIMessageBus TIMessageBus;
typedef struct _TIMessageBusClass TIMessageBusClass;

#define TI_TYPE_MESSAGE_BUS               ti_message_bus_get_type()
#define TI_MESSAGE_BUS(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_MESSAGE_BUS, TIMessageBus))
#define TI_MESSAGE_BUS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_MESSAGE_BUS, TIMessageBusClass))
#define TT_IS_CONN_MANAGER(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_MESSAGE_BUS))
#define TT_IS_CONN_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_MESSAGE_BUS))
#define TI_MESSAGE_BUS_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_MESSAGE_BUS, TIMessageBusClass))

struct _TIMessageBus {
  GObject parent;
  /* instance members */
};

struct _TIMessageBusClass {
  GObjectClass parent;
  /* class members */
};

typedef struct {
    gchar* conn_man;
    gchar* protocol;
    gchar* account;
} TIActiveConn;

GType ti_message_bus_get_type (void);


/**
 * Creates a new access wrapper for the specified connection manager.
 *
 * @return A new TIMessageBus or NULL if an error occurred.
 */
TIMessageBus* ti_message_bus_new ();

/**
 * List Names
 *
 * @return Array of service names. Must be freed after use.
 */
GStrv ti_message_bus_list_names (TIMessageBus* message_bus, GError** error);

/**
 * List Active Connections
 *
 * @return GArray of TIActiveConn. Must be freed after use.
 */
GArray* ti_message_bus_list_active_conns (TIMessageBus* message_bus, GError** error);

#endif // __TI_MESSAGE_BUS_H__
