/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-wdg-conn-param-priv.h:
 * Widgets Connection Parameter - Abstract Class - Protected Definitions
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_WDG_CONN_PARAM_PRIV_H__
#define __TI_WDG_CONN_PARAM_PRIV_H__

struct _TIWdgConnParamClass {
    GObjectClass parent;
    /* class members */

    // Implementation of ti_wdg_conn_param_get_value ()
    // Must be implemented by all derived classes.
    GValue* (*get_value) (TIWdgConnParam* conn_param);
};

/**
 * Must be called by the "derived_class_new" functions
 */
void _ti_wdg_conn_param_new (TIWdgConnParam* conn_param, const gchar* name);

#endif // __TI_WDG_CONN_PARAM_PRIV_H__
