/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-handles-list.h:
 * Dialog to set a list of handles.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_HANDLES_LIST_H__
#define __TI_DLG_HANDLES_LIST_H__

#include "ti-handle-mapper.h"

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgHandlesList TIDlgHandlesList;
typedef struct _TIDlgHandlesListClass TIDlgHandlesListClass;

#define TI_TYPE_DLG_HANDLES_LIST               ti_dlg_handles_list_get_type()
#define TI_DLG_HANDLES_LIST(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_HANDLES_LIST, TIDlgHandlesList))
#define TI_DLG_HANDLES_LIST_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_HANDLES_LIST, TIDlgHandlesListClass))
#define TI_IS_DLG_HANDLES_LIST(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_HANDLES_LIST))
#define TI_IS_DLG_HANDLES_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_HANDLES_LIST))
#define TI_DLG_HANDLES_LIST_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_HANDLES_LIST, TIDlgHandlesListClass))

struct _TIDlgHandlesList
{
    GObject parent;
};

struct _TIDlgHandlesListClass
{
    GObjectClass parent;
};

GType ti_dlg_handles_list_get_type (void);

TIDlgHandlesList* ti_dlg_handles_list_new (GtkWindow* parent, TIHandleMapper* handle_mapper, const gchar* title);

/**
 * Shows the dialog.
 *
 * @param handles Entered handles. An array of guint. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_handles_list_run (TIDlgHandlesList* dlg_handles_list, GArray** handles);

#endif
