/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-page-priv.h:
 * Abstract class for all TIPage* classes. Private functions and structures.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Originally by Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_PRIV_H__
#define __TI_PAGE_PRIV_H__

#include <glade/glade.h>

struct _TIPageClass {
    GObjectClass parent;

    /* Called only once, during page creation.
     * Implementation of this method is mandatory. */
    void (*setup_page) (TIPage *page, GladeXML *glade_xml);

    /* Called when a page is attached to a notebook (either through an
     * attach_to_notebook() call or on its creation, page_new()).
     * Implementation of this method is optional. */
    void (*restart_page) (TIPage *page);
};

struct _TIPagePrivate {
    gboolean disposed;

    GtkNotebook *parent_notebook;

    GtkWidget *page;
    GtkWidget *page_label;
};

#define TI_PAGE_GET_PRIVATE(object) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((object), TI_TYPE_PAGE, TIPagePrivate))

void _ti_page_new (TIPage **page, GtkNotebook *parent_notebook,
    const gchar *glade_file_name);

#endif /* __TI_PAGE_PRIV_H__ */
