/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * main.c:
 * Application entry point
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Originally by Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "config.h"

#include <stdlib.h>
#include <string.h>

#include <dbus/dbus-glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <telepathy-glib/debug.h>

#include "about.h"
#include "extensions/extensions.h"
#include "util.h"
#include "wnd-main.h"

/* Function prototypes */
static gboolean _ti_proccess_shell_arguments (int argc, char **argv);

/**
 * Application entry point
 */
int
main (int argc, char **argv)
{
  TIWndMain *wnd_main = NULL;
  gboolean keep_going;

  g_type_init ();

  g_set_prgname ("telepathy-inspector");
  g_set_application_name ("Telepathy Inspector");

  tp_debug_set_flags (g_getenv ("INSPECTOR_DEBUG"));

  if (argc > 0)
    ti_set_executable (argv[0]);

  keep_going = _ti_proccess_shell_arguments (argc, argv);
  if (!keep_going)
    goto CLEAN_UP;

  gtk_init (&argc, &argv);

  ti_cli_init ();
  dbus_g_type_specialized_init ();

  wnd_main = ti_wnd_main_new ();
  if (wnd_main == NULL)
    goto CLEAN_UP;

  ti_wnd_main_show (wnd_main);

  gtk_main ();

CLEAN_UP:
  if (wnd_main != NULL)
    g_object_unref (wnd_main);

  return 0;
}

/**
 * Process Shell Arguments
 *
 * @return Whether the application should start.
 */
static gboolean
_ti_proccess_shell_arguments (int argc, char **argv)
{
  gboolean run_application = TRUE;
  GOptionContext *option_context = NULL;
  gboolean display_version = FALSE;
  GError *error = NULL;

  GOptionEntry entries[] =
  {
      { "version", 0, 0, G_OPTION_ARG_NONE, &display_version, "Display application version.", NULL },
      { NULL }
  };

  option_context = g_option_context_new ("");
  g_option_context_set_summary (option_context, ti_about_comments);
  g_option_context_add_main_entries (option_context, entries, NULL);
  g_option_context_add_group (option_context, gtk_get_option_group (TRUE));
  g_option_context_parse (option_context, &argc, &argv, &error);

  if (error == NULL)
    {
      if (display_version)
        {
          g_printf ("Telepathy Inspector, version %s\n%s\n",
              PACKAGE_VERSION, ti_about_copyright);
          run_application = FALSE;
        }
    }
  else
    {
      g_printf ("%s\n", error->message);
      run_application = FALSE;
    }

  if (option_context != NULL)
    g_option_context_free (option_context);

  if (error != NULL)
    g_error_free (error);

  return run_application;
}
