/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by basysKom GmbH
 *  @author Tobias Hunger <tobias.hunger@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QTTELEPATHY_CHANNELTYPEROOMLIST_H
#define QTTELEPATHY_CHANNELTYPEROOMLIST_H

#include <QtCore/QMap>
#include <QtDBus/QDBusArgument>
#include <QtDBus/QDBusSignature>
#include <QtTelepathy/Common/BaseTypes>

namespace org {
namespace freedesktop {
namespace Telepathy {

class RoomInfo
{
public:
    uint id;
    QString dbusName;
    NVPairs data;
};
typedef QList<RoomInfo> RoomInfoList;

} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::RoomInfo)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::RoomInfoList)

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::RoomInfo &info);
QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::RoomInfo &info);

#endif

