/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QTTELEPATHY_TEST_H
#define QTTELEPATHY_TEST_H

#include <QtCore/QObject>
#include <QtDBus/QDBusConnection>
#include <QtTelepathy/Client/Connection>

class MessageFilter: public QObject
{
Q_OBJECT

public:
    MessageFilter(org::freedesktop::Telepathy::Connection *connection, const QDBusConnection &bus, QObject *parent = 0);
    ~MessageFilter();

public Q_SLOTS:
    void OnStatusChanged(uint status, uint reason);

private:
    org::freedesktop::Telepathy::Connection *conn;
    QDBusConnection bus;
};

#endif

