/***************************************************************************
 *  IConnection.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *	Kenneth Christiansen <kenneth.christiansen@gmail.com>
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using NDesk.DBus;
using org.freedesktop.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void NewChannelHandler (ObjectPath channel, string channel_type, HandleType handle_type, uint handle, bool suppress_handler);
	public delegate void StatusChangedHandler (ConnectionStatus status, ConnectionStatusReason reason);

	public enum HandleType : uint
	{
		None = 0,
		Contact = 1,
		Room = 2,
		List = 3,
	}

	public enum  ConnectionStatus : uint
	{
		Connected = 0,
		Connecting = 1,
		Disconnected = 2
	}

	public enum ConnectionStatusReason : uint
	{
		NoneSpecified = 0,
		Requested = 1,
		NetworkError = 2,
		AuthenticationFailed = 3,
		EncryptionError = 4,
		NameInUse = 5,
		CertificateNotProviede = 6,
		CertificateUntrusted = 7,
		CertificateExpired = 8,
		CertificateNotActivated	= 9,
		CertificateHostnameMismatch = 10,
		CertificateFigerprintMismatch = 11,
		CertificateSelfSigned = 12,
		CertificateOtherError = 13
	}

	public class ChannelType
	{
		public static readonly string ContactList = "org.freedesktop.Telepathy.Channel.Type.ContactList";
		public static readonly string ContactSearch = "org.freedesktop.Telepathy.Channel.Type.ContactSearch";
		public static readonly string StreamedMedia = "org.freedesktop.Telepathy.Channel.Type.StreamedMedia";
		public static readonly string RoomList = "org.freedesktop.Telepathy.Channel.Type.RoomList";
		public static readonly string Text = "org.freedesktop.Telepathy.Channel.Type.Text";
	}

	public struct ChannelInfo
	{
		public ObjectPath ObjectPath;
		public string InterfaceName;
		public HandleType HandleType;
		public uint Handle;
	}

	[Interface ("org.freedesktop.Telepathy.Connection")]
	public interface IConnection : IConnectionAliasing, IConnectionAvatars, IConnectionCapabilities, IConnectionContactInfo, IConnectionForwarding, IConnectionPresence, IConnectionPrivacy, IConnectionRenaming
	{
		event NewChannelHandler NewChannel;
		event StatusChangedHandler StatusChanged;

		void Connect ();
		void Disconnect ();
		string[] Interfaces { get; }
		string Protocol { get; }
		uint SelfHandle { get; }
		ConnectionStatus Status { get; }
		void HoldHandles (HandleType handle_type, uint[] handles);
		string[] InspectHandles (HandleType handle_type, uint[] handles);
		ChannelInfo[] ListChannels ();
		void ReleaseHandles (HandleType handle_type, uint[] handles);
		ObjectPath RequestChannel (string type, HandleType handle_type, uint handle, bool suppress_handler);
		uint[] RequestHandles (HandleType handle_type, string[] names);
	}
}
