/***************************************************************************
 *  IStreamEngine.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using NDesk.DBus;
using org.freedesktop.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void ReceivingHandler (ObjectPath channel_path, uint stream_id, bool state);

	[Interface ("org.freedesktop.Telepathy.ChannelHandler")]
	public interface IChannelHandler : Introspectable
	{
		void HandleChannel (string bus_name, ObjectPath connection, string channel_type, ObjectPath channel, uint handle_type, uint handle);
	}


	[Interface ("org.freedesktop.Telepathy.StreamEngine")]
	public interface IStreamEngine : Introspectable
	{
		event ReceivingHandler Receiving;

		void SetOutputVolume (ObjectPath channel_path, uint stream_id, uint volume);
		void MuteInput (ObjectPath channel_path, uint stream_id, bool mute_state);
		void MuteOutput (ObjectPath channel_path, uint stream_id, bool mute_state);
		void SetOutputWindow (ObjectPath channel_path, uint stream_id, uint window);
		void AddPreviewWindow (uint window);
		void RemovePreviewWindow (uint window);
		void Shutdown ();
	}
}
