/*

    File: file_jpg.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#ifdef HAVE_SETJMP_H
#include <setjmp.h>
#endif
#ifdef HAVE_JPEGLIB_H
#include <jpeglib.h>
#endif
#include "photorec.h"

static int header_check_jpg(const unsigned char *buffer, const unsigned int buffer_size);
static void file_check_jpg(t_file_recovery *file_recovery);
const t_file_hint file_hint_jpg= {
  .extension="jpg",
  .description="JPG picture",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=10*1024*1024,
  .stream=0,
  .recover=1,
  .header_check=&header_check_jpg,
  .data_check=NULL,
  .file_check=&file_check_jpg
};
static int header_check_jpg(const unsigned char *buffer, const unsigned int buffer_size)
{
  const unsigned char jpg_header[4]= { 0xff,0xd8,0xff,0xe1};
  const unsigned char jpg2_header[4]= { 0xff,0xd8,0xff,0xe0};
  return((memcmp(buffer,jpg_header,sizeof(jpg_header))==0)
      ||(memcmp(buffer,jpg2_header,sizeof(jpg2_header))==0));
}
int64_t test_jpeg(FILE *infile);

static void file_check_jpg(t_file_recovery *file_recovery)
{
  int64_t jpg_file_size=test_jpeg(file_recovery->handle);
  file_recovery->file_size=(jpg_file_size>0?jpg_file_size:0);
}

#ifdef HAVE_LIBJPEG
struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */

  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;
static void my_output_message (j_common_ptr cinfo);
static void my_error_exit (j_common_ptr cinfo);

static void my_output_message (j_common_ptr cinfo)
{
#ifdef DEBUG
  char buffermsg[JMSG_LENGTH_MAX];
  /* Create the message */
  (*cinfo->err->format_message) (cinfo, buffermsg);
  ecrit_rapport("test_jpeg error %s\n",buffermsg);
#endif
}

static void my_error_exit (j_common_ptr cinfo)
{
  my_error_ptr myerr = (my_error_ptr) cinfo->err;
  (*cinfo->err->output_message) (cinfo);
  /* Return control to the setjmp point */
  longjmp(myerr->setjmp_buffer, 1);
}

int64_t test_jpeg(FILE *infile)
{
  struct jpeg_decompress_struct cinfo;
  JSAMPARRAY buffer;		/* Output row buffer */
  int row_stride;		/* physical row width in output buffer */
  uint64_t jpeg_size=0;
  struct my_error_mgr jerr;
  fseek(infile,SEEK_SET,0);
  cinfo.err = jpeg_std_error(&jerr.pub);
  jerr.pub.output_message = my_output_message;
  jerr.pub.error_exit = my_error_exit;
  /* Establish the setjmp return context for my_error_exit to use. */
  if (setjmp(jerr.setjmp_buffer)) {
    /* If we get here, the JPEG code has signaled an error.
     * We need to clean up the JPEG object and return.
     */
/*    ecrit_rapport("JPG error at %llu\n",(long long unsigned)ftell(infile)); */
    jpeg_destroy_decompress(&cinfo);
    /* Not accurate */
    return -ftell(infile);
  }
  jpeg_create_decompress(&cinfo);
  cinfo.two_pass_quantize = FALSE;
  cinfo.dither_mode = JDITHER_NONE;
  cinfo.desired_number_of_colors = 2;
  cinfo.dct_method = JDCT_FASTEST;
  cinfo.do_fancy_upsampling = FALSE;
  cinfo.raw_data_out = TRUE;

  jpeg_stdio_src(&cinfo, infile);
  (void) jpeg_read_header(&cinfo, TRUE);
  (void) jpeg_start_decompress(&cinfo);
  row_stride = cinfo.output_width * cinfo.output_components;
  buffer = (*cinfo.mem->alloc_sarray)
		((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
  while (cinfo.output_scanline < cinfo.output_height) {
    (void) jpeg_read_scanlines(&cinfo, buffer, 1);
  }
  (void) jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);
  jpeg_size=ftell(infile);
  if(jerr.pub.num_warnings>0)
  {
    /* Not accurate */
    jpeg_size=-jpeg_size;
/*    ecrit_rapport("JPG error at %llu\n",(long long unsigned)ftell(infile)); */
  }
  return jpeg_size;
}
#else
int64_t test_jpeg(FILE *infile)
{
  return ftell(infile);
}
#endif


