/*

    File: photorec.h

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
typedef struct file_hint t_file_hint;
typedef struct file_recovery t_file_recovery;
typedef struct list_file_hint t_list_file_hint;
typedef struct struct_file_stat t_file_stat;

struct struct_file_stat
{
  unsigned int enable;
  unsigned int not_recovered;
  unsigned int recovered;
  const t_file_hint *file_hint;
};

struct file_recovery
{
  t_file_stat *file_stat;
  FILE *handle;
  char filename[2048];
  uint64_t header_distance;
  uint64_t file_size;
  uint64_t start;
};

struct file_hint
{
  const char *extension;
  const char *description;
  uint64_t min_filesize;
  /* don't try head_check if min_header_distance >0 and previous_header_distance <= min_header_distance */
  /* needed by tar header */
  uint64_t min_header_distance;
  uint64_t max_filesize;
  int stream;
  int recover;
  int (*header_check)(const unsigned char *buffer, const unsigned int buffer_size);
  int (*data_check)(const unsigned char*buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
  /* 0: bad, 1: EOF not found, 2: EOF*/
  void (*file_check)(t_file_recovery *file_recovery);
};

