/*

    File: file_zip.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the imzipied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static int header_check_zip(const unsigned char *buffer, const unsigned int buffer_size);
const t_file_hint file_hint_zip= {
  .extension="zip",
  .description="zip archive",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .stream=0,
  .recover=1,
  .header_check=&header_check_zip,
  .data_check=NULL,
  .file_check=NULL
};

static int header_check_zip(const unsigned char *buffer, const unsigned int buffer_size)
{
  const unsigned char zip_header[4]  = { 'P', 'K', 0x03, 0x04};
  const unsigned char zip_header2[8]  = { 'P', 'K', '0', '0', 'P', 'K', 0x03, 0x04}; /* WinZIPv8-compressed files. */
  return (memcmp(buffer,zip_header,sizeof(zip_header))==0 ||
      memcmp(buffer,zip_header2,sizeof(zip_header2))==0);
}
