/*

    File: fnctdsk.h

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
unsigned long int C_H_S2LBA(const t_param_disk *disk_car,const unsigned int C, const unsigned int H, const unsigned int S);
unsigned long int CHS2LBA(const t_param_disk *disk_car,const t_CHS*CHS);
uint64_t CHS2offset(const t_param_disk *disk_car,const t_CHS*CHS);
uint64_t C_H_S2offset(const t_param_disk *disk_car,const unsigned int C, const unsigned int H, const unsigned int S);

int write_clean_table(t_param_disk *disk_car);
void dup_t_CHS(t_CHS * CHS_dest, const t_CHS * CHS_source);
t_list_part *element_new(t_partition *part);
t_list_disk *insert_new_disk(t_list_disk *list_disk, t_param_disk *disk_car);
t_list_part *insert_new_partition(t_list_part *list_part, t_partition *part);
t_list_part *insert_new_partition_aux(t_list_part *list_part, t_list_part *new_element, const unsigned int dont_free_part);
t_list_part *remove_partition(t_list_part *list_part, t_list_part *element2removed);
t_list_part *sort_list_part(t_list_part *list_part);
void delete_list_part(t_list_part *list_part);
void  partition_reset(t_partition *partition);
t_partition *partition_new(void);
unsigned int offset2sector(const t_param_disk *disk_car, const uint64_t offset);
unsigned int offset2head(const t_param_disk *disk_car, const uint64_t offset);
unsigned int offset2cylinder(const t_param_disk *disk_car, const uint64_t offset);
void offset2CHS(const t_param_disk *disk_car,const uint64_t offset, t_CHS*CHS);
int check_list_part(t_list_part *list_part);
unsigned int get_geometry_from_list_part(const t_param_disk *disk_car, const t_list_part *list_part, const int debug);
int delete_list_disk(t_list_disk *list_disk);

