/*

    File: cramfs.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "common.h"
#include "cramfs.h"
#include "fnctdsk.h"
#include "intrf.h"
static int set_cramfs_info(const t_param_disk *disk_car, const struct cramfs_super *sb,t_partition *partition, const int debug, const int dump_ind);
static int test_cramfs(const t_param_disk *disk_car, const struct cramfs_super *sb,t_partition *partition,const int debug, const int dump_ind);

int check_cramfs(t_param_disk *disk_car,t_partition *partition,const int debug)
{
  unsigned char buffer[3*DEFAULT_SECTOR_SIZE];
  if(disk_car->read(disk_car,sizeof(buffer), &buffer, partition->part_offset)!=0)
  { return 1; }
  if(test_cramfs(disk_car,(struct cramfs_super*)&buffer[0x200],partition,debug,0)==0)
  {
    set_cramfs_info(disk_car,(struct cramfs_super*)&buffer[0x200],partition,debug,0);
    return 0;
  }
  return 1;
}

static int test_cramfs(const t_param_disk *disk_car, const struct cramfs_super *sb,t_partition *partition,const int debug, const int dump_ind)
{
  if (sb->magic==CRAMFS_MAGIC)
  {
    partition->upart_type = UP_CRAMFS;
  }
  else
    return 1;
  if(debug>0)
    ecrit_rapport("\ncramfs Marker at %u/%u/%u\n", offset2cylinder(disk_car,partition->part_offset),offset2head(disk_car,partition->part_offset),offset2sector(disk_car,partition->part_offset));
  return 0;
}

int recover_cramfs(t_param_disk *disk_car, const struct cramfs_super *sb,t_partition *partition,const int debug, const int dump_ind)
{
  if(test_cramfs(disk_car,sb,partition,debug,dump_ind)!=0)
    return 1;
  if(debug>0 || dump_ind!=0)
  {
    ecrit_rapport("\nrecover_cramfs\n");
    if(dump_ind!=0)
    {
      dump(stdscr,sb,DEFAULT_SECTOR_SIZE);
    }
  }
  partition->part_size = sb->size;
  partition->part_type_i386 = P_LINUX;
  partition->part_type_mac= PMAC_LINUX;
  partition->part_type_sun= PSUN_LINUX;
  set_cramfs_info(disk_car,sb,partition,debug,dump_ind);
  return 0;
}

static int set_cramfs_info(const t_param_disk *disk_car,const struct cramfs_super *sb,t_partition *partition, const int debug, const int dump_ind)
{
  set_part_name(partition,sb->name,16);
  switch(partition->upart_type)
  {
    case UP_CRAMFS:
      strncpy(partition->info,"cramfs",sizeof(partition->info));
      break;
    default:
      partition->info[0]='\0';
      return 1;
  }

  return 0;
}
