/*

    File: fatx.h

    Copyright (C) 2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

struct disk_fatx
{
  char		magic[4];
  uint32_t 	volume_id;
  uint32_t	cluster_size_in_sector;
  uint16_t	fats;
  uint32_t	unknown;
} __attribute__ ((__packed__));

int check_FATX(t_param_disk *disk_car,t_partition *partition,const int debug);
int recover_FATX(t_param_disk *disk_car, const struct disk_fatx *fatx_block, t_partition *partition, const int debug, const int dump_ind);
