/*

    File: file_doc.c

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "common.h"
#include "photorec.h"

static const char* header_check_doc(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
const t_file_hint file_hint_doc= {
  .extension="doc",
  .description="Microsoft Office Document (doc/xls/ppt/vis/...)",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_doc,
  .data_check=NULL,
  .file_check=NULL
};

static const unsigned char * find_in_mem(const unsigned char *haystack, const unsigned char *needle, const unsigned int haystack_size);
static const unsigned char * find_in_mem(const unsigned char *haystack, const unsigned char *needle, const unsigned int haystack_size)
{
  unsigned int i;
  unsigned int needle_size=strlen(needle);
  for(i=0;i<haystack_size-needle_size;i++)
    if(memcmp(&haystack[i],needle,needle_size)==0)
      return &haystack[i];
  return NULL;
}

struct OLE_HDR
{
  char magic[8];        	/*0*/
  char clsid[16];       	/*8*/
  uint16_t uMinorVersion; 	/*24*/
  uint16_t uDllVersion;   	/*26*/
  uint16_t uByteOrder;    	/*28*/
  uint16_t uSectorShift;  	/*30*/
  uint16_t uMiniSectorShift;	/*32*/
  uint16_t reserved;      	/*34*/
  uint32_t  reserved1;     	/*36*/
  uint32_t  reserved2;     	/*40*/
  uint32_t  num_FAT_blocks;     /*44*/
  uint32_t  root_start_block;   /*48*/
  uint32_t  dfsignature;        /*52*/
  uint32_t  miniSectorCutoff;   /*56*/
  uint32_t  dir_flag;           /*60 first sec in the mini fat chain*/ 
  uint32_t csectMiniFat;  	/*64 number of sectors in the minifat */
  uint32_t FAT_next_block; 	/*68*/
  uint32_t num_extra_FAT_blocks;     /*72*/
  /* FAT block list starts here !! first 109 entries  */
};

static const char* header_check_doc(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  const unsigned char doc_header[]= { 0xd0, 0xcf, 0x11, 0xe0, 0xa1, 0xb1, 0x1a, 0xe1};
  if(memcmp(buffer,doc_header,sizeof(doc_header))==0)
  {
    const struct OLE_HDR *h=(const struct OLE_HDR *)buffer;
    /* TODO try to understand OLE format */
    if(le16(h->reserved)!=0 || le32(h->reserved1)!=0 || le32(h->reserved2)!=0)
      return NULL;
    if(le16(h->uMiniSectorShift)!=6 || le16(h->uSectorShift)!=9)
      return NULL;
    if(le32(h->num_FAT_blocks)==0 || le32(h->num_FAT_blocks)>100)
      return NULL;
    /* */
    if(find_in_mem(buffer,"WordDocument",buffer_size)!=NULL)
    {
      return "doc";
    }
    else if(find_in_mem(buffer,"StarDraw",buffer_size)!=NULL)
    {
      return "sda";
    }
    else if(find_in_mem(buffer,"StarCalc",buffer_size)!=NULL)
    {
      return "sdc";
    }
    else if(find_in_mem(buffer,"StarImpress",buffer_size)!=NULL)
    {
      return "sdd";
    }
    else if(find_in_mem(buffer,"Worksheet",buffer_size)!=NULL || find_in_mem(buffer,"Book",buffer_size)!=NULL || find_in_mem(buffer,"Workbook",buffer_size)!=NULL || find_in_mem(buffer,"Calc",buffer_size)!=NULL)
    {
      return "xls";
    }
    else if(find_in_mem(buffer,"Power",buffer_size)!=NULL)
    {
      return "ppt";
    }
    else if(find_in_mem(buffer,"AccessObjSiteData",buffer_size)!=NULL)
    {
      return "mdb";
    }
    else if(find_in_mem(buffer,"Visio",buffer_size)!=NULL)
    {
      return "vis";
    }
    else if(find_in_mem(buffer,"Sfx",buffer_size)!=NULL)
    {
      return "sdw";
    }
    else if(find_in_mem(buffer,"CPicPage",buffer_size)!=NULL)
    {	/* Flash */
      return "fla";
    }
    /* FIXME */
    return file_hint_doc.extension;
  }
  return NULL;
}


