/*

    File: file_mov.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static const char* header_check_mov(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
const t_file_hint file_hint_mov= {
  .extension="mov",
  .description="MOV video",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_mov,
  .data_check=NULL,
  .file_check=NULL
};

static const unsigned char * find_in_mem(const unsigned char *haystack, const unsigned char *needle, const unsigned int haystack_size);
static const unsigned char * find_in_mem(const unsigned char *haystack, const unsigned char *needle, const unsigned int haystack_size)
{
  unsigned int i;
  unsigned int needle_size=strlen(needle);
  for(i=0;i<haystack_size-needle_size;i++)
    if(memcmp(&haystack[i],needle,needle_size)==0)
      return &haystack[i];
  return NULL;
}
static const char* header_check_mov(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  unsigned int offset=0;
  while(1)
  {
    unsigned int atom_size;
    if(offset+8>=buffer_size)
      return NULL;
    atom_size=(buffer[offset+0]<<24)+(buffer[offset+1]<<16)+(buffer[offset+2]<<8)+buffer[offset+3];
    if(atom_size<8)
      return NULL;
    /* check for commun atom type */
    if(buffer[offset+4]=='p' && buffer[offset+5]=='n' && buffer[offset+6]=='o' && buffer[offset+7]=='t')
    {
      if(atom_size < 256)
	return file_hint_mov.extension;
      else
	return NULL;
    }
    if(buffer[offset+4]=='w' && buffer[offset+5]=='i' && buffer[offset+6]=='d' && buffer[offset+7]=='e')
    {
      if(atom_size < 256)
	return file_hint_mov.extension;
      else
	return NULL;
    }
    if(buffer[offset+4]=='m' && buffer[offset+5]=='o' && buffer[offset+6]=='o' && buffer[offset+7]=='v')
    {
      if(atom_size < 256*256*256)
	return file_hint_mov.extension;
      else
	return NULL;
    }
    if(buffer[offset+4]=='f' && buffer[offset+5]=='t' && buffer[offset+6]=='y' && buffer[offset+7]=='p')
    {
      if(atom_size>buffer_size-offset)
	atom_size=buffer_size-offset;
      if(find_in_mem(&buffer[offset+8], "isom",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "mp41",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "mp42",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "3gp",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "mmp4",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "M4A",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "M4P",atom_size-8)!=NULL ||
	  find_in_mem(&buffer[offset+8], "M4B",atom_size-8)!=NULL)
	return "mp4";
      if(find_in_mem(&buffer[offset+8], "jp2",atom_size-8)!=NULL)
	return "jp2";
      if(find_in_mem(&buffer[offset+8], "qt",atom_size-8)!=NULL)
	return "mov";
    }
    offset+=atom_size;
  }
}


