/*

    File: file_ps.c

    Copyright (C) 2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"
#include "common.h"

static const char* header_check_ps(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
static int data_check_ps(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
const t_file_hint file_hint_ps= {
  .extension="ps",
  .description="PostScript document",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_ps,
  .file_check=NULL,
  .data_check=&data_check_ps
};

static const char* header_check_ps(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  const unsigned char ps_header[11]= { '%','!','P','S','-','A','d','o','b','e','-'};
  if(memcmp(buffer,ps_header,sizeof(ps_header))==0)
  { /* PS or EPSF */
    int mode=0;
    int i;
    for(i=sizeof(ps_header);i<20;i++)
    {
      switch(buffer[i])
      {
	case '\n':
	  return file_hint_ps.extension;
	case 'E':
	  if(memcmp(&buffer[i],"EPSF-",5)==0)
	    return NULL;
      }
    }
    return file_hint_ps.extension;
  }
  return NULL;
}

static int data_check_ps(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  unsigned int i;
  for(i=(buffer_size/2)-4;i+4<buffer_size;i++)
  {
    if(buffer[i]=='%' && buffer[i+1]=='%' && buffer[i+2]=='E' && buffer[i+3]=='O' && buffer[i+4]=='F')
    {
      file_recovery->file_size+=i+5-(buffer_size/2);
      return 2;
    }
  }
  return 1;
}

