/*

    File: photorec.h

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

/* 2^31-1 */
#define PHOTOREC_MAX_FILE_SIZE ((1<<(31-1))-1)
typedef struct file_hint_struct t_file_hint;
typedef struct file_recovery_struct t_file_recovery;
typedef struct list_file_hint_struct t_list_file_hint;
typedef struct file_stat_struct t_file_stat;
typedef struct struct_alloc_data t_alloc_data;
#include "list.h"

struct file_stat_struct
{
  unsigned int enable;
  unsigned int ifnothingfound;
  unsigned int not_recovered;
  unsigned int recovered;
  const t_file_hint *file_hint;
};

struct file_recovery_struct
{
  t_file_stat *file_stat;
  FILE *handle;
  char filename[2048];
  uint64_t file_size;
  uint64_t file_size_on_disk;
  t_alloc_list location;
};

struct file_hint_struct
{
  const char *extension;
  const char *description;
  const uint64_t min_header_distance;
  uint64_t min_filesize;
  /* don't try head_check if min_header_distance >0 and previous_header_distance <= min_header_distance */
  /* needed by tar header */
  const uint64_t max_filesize;
  const int recover;
  const char *(*header_check)(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only, t_file_recovery *file_recovery);
  int (*data_check)(const unsigned char*buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
  /* 0: bad, 1: EOF not found, 2: EOF*/
  void (*file_check)(t_file_recovery *file_recovery);
};

struct struct_alloc_data
{
  struct list_head list;
  uint64_t start;
  uint64_t end;
  t_file_stat *file_stat;
};

int64_t test_jpeg(FILE *infile);
void file_search_footer(t_file_recovery *file_recovery, const unsigned char*footer, const unsigned int footer_length);
void file_search_lc_footer(t_file_recovery *file_recovery, const unsigned char*footer, const unsigned int footer_length);
t_alloc_data *del_search_space(t_alloc_data *list_search_space, uint64_t start, uint64_t end);
