# Author:: Masaki Suketa.
# Adapted by:: Nathaniel Talbott.
# Copyright:: Copyright (c) Masaki Suketa. All rights reserved.
# Copyright:: Copyright (c) 2002 Nathaniel Talbott. All rights reserved.
# License:: Ruby license.

require 'runit/testcase'
require 'runit/cui/testrunner'
require 'dummytestcase'

class DummyTest < RUNIT::TestCase
  def test_foo
  end
  def test_bar
  end
end

class TestTestSuite < RUNIT::TestCase
  def setup
    @testsuite = RUNIT::TestSuite.new
  end

  def test_count_test_cases
    assert_equal(0, @testsuite.count_test_cases)

    @testsuite.add(DummyEmptyTest.suite)
    assert_equal(0, @testsuite.count_test_cases)

    @testsuite.add(DummyTest.suite)
    assert_equal(2, @testsuite.count_test_cases)

    @testsuite.add(DummyTest.suite)
    assert_equal(4, @testsuite.count_test_cases)

    dummytest_foo = DummyTest.new('test_foo')
    @testsuite.add(dummytest_foo)
    assert_equal(5, @testsuite.count_test_cases)
  end

  def test_add
    @testsuite.add(DummyEmptyTest.suite)
    assert_equal(0, @testsuite.size)
    assert_equal(0, @testsuite.count_test_cases)

    @testsuite.add(DummyTest.suite)
    assert_equal(2, @testsuite.size)
    assert_equal(2, @testsuite.count_test_cases)

  end
end

if $0 == __FILE__
  RUNIT::CUI::TestRunner.run(TestTestSuite.suite)
end

