%define ver       1.2.4
%define rel       1
%define prefix    /usr

Summary: TeX-Guy Package 1.2.4
Name: TeX-Guy
Version: %ver
Release: %rel
Copyright: LGPL
Group: Other
Vendor: The TypeHack Project
Packager: Hirotsugu Kakugawa
Url: http://TypeHack.aial.hiroshima-u.ac.jp/TeX-Guy/
Source: ftp://TypeHack.aial.hiroshima-u.ac.jp/pub/TypeHack/TeX-Guy-%{ver}.tar.gz
BuildRoot: /var/tmp/TeX-Guy-Root

Requires: VFlib3 >= 3.6

%description
TeX-Guy is a set of a device independent DVI interpreter,
printer drivers, and previewers for TeX DVI files.
It uses VFlib version 3 as a font module.
It includes the following software in this package:
 * DVIlib, a device independent DVI interpreter.
 * xgdvi, a previewer on X Window System using GTK+ 1.2 
 * spawg, a simple previewer on X Window System using GTK+ 1.2 
 * spawx11, a very simple previewer on X Window System using Xlib.
 * dvi2img, converter to generate an image file from a DVI file
 * dvi2rpdl, a printer driver for RICOH RPDL printers
 * dvi2escpg, a printer driver for EPSON ESC/PGL printers
   ... and more!

%prep
%setup -n TeX-Guy-%{ver}

%build
rm -rf $RPM_BUILD_ROOT
./configure --prefix=%prefix
make

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%install
mkdir -p $RPM_BUILD_ROOT/%{prefix}/bin
mkdir -p $RPM_BUILD_ROOT/%{prefix}/lib
mkdir -p $RPM_BUILD_ROOT/%{prefix}/include
mkdir -p $RPM_BUILD_ROOT/%{prefix}/etc
make prefix=${RPM_BUILD_ROOT}%prefix install

%files
%defattr(-,root,root,-)

%{prefix}/bin/*
%{prefix}/lib/*
%{prefix}/share/*
%{prefix}/include/*
