/*
 * xgdvi -  TeX DVI previewer with GTK 
 *
 *  Copyright (C) 1999-2000  Hirotsugu Kakugawa. All rights reserved. 
 *  See "COPYING" for distribution of this software. 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef  __XGDVI_H__
#define  __XGDVI_H__

#include "../with.h"


#define AA      3        /* must be integer value and be greater than 1 */
#define N_AA   (AA*AA+1)

#define EPS_INCREMENTAIL_STEP   (AA * 10)

#define PAGE_EMPTY        0
#define PAGE_DRAWING      1
#define PAGE_DRAW_FINISH  2

#define STAT_STARTUP      0
#define STAT_RUNNING      1
#define STAT_MAINLOOP     2

#define CMD_NONE          0
#define CMD_DRAW_PAGE     1

#define ORI_PORT     0
#define ORI_LAND     1


#define EXIT_MSG1(a1)   {fprintf(stderr,a1); fprintf(stderr,"\n"); exit(1);}
#define EXIT_MSG2(a1,a2){fprintf(stderr,a1,a2); fprintf(stderr,"\n"); exit(1);}

#define CTL(ch)  ((ch)-0x40)

#if defined(WITH_GETTEXT)
#  include <libintl.h>
#  define  _(str)   gettext (str)
#  define  N_(str)  (str)
#else
#  define  _(str)   (str)
#  define  N_(str)  (str)
#  define  bindtextdomain(cat, dir)  /*null*/
#  define  textdomain(cat)           /*null*/
#endif


extern DVI         dvi;
extern char       *dvi_file;
extern DVI_DEVICE  dev;
extern int         page;
extern double      shrink;
extern int         paper;
extern int         orient;
extern double      on_buffer_switch_shrink;
extern int         on_buffer_switch_paper;
extern int         on_buffer_switch_orient;
extern double      on_buffer_switch_view_x;
extern double      on_buffer_switch_view_y;

extern int        page_state;
extern int        ui_cmd;

extern char      *param_kpathsea_mode;
extern char      *param_vflibcap;
extern double     param_shrink;
extern int        param_dpi;
extern char      *param_paper_name;
extern int        param_paper;
extern int        param_orient;
extern char      *param_win_title;
extern unsigned int param_win_size_w;
extern unsigned int param_win_size_h;
extern int        param_gui_type;
extern int        paper_w, paper_h;
extern int        paper_aa_w, paper_aa_h;
extern int        param_no_state;
extern int        param_scroll_delta;
extern int        param_window_delta;

extern double     default_color_fg_r, default_color_fg_g, default_color_fg_b;
extern double     default_color_bg_r, default_color_bg_g, default_color_bg_b;
extern double     current_color_fg_r, current_color_fg_g, current_color_fg_b;
extern double     current_color_bg_r, current_color_bg_g, current_color_bg_b;


extern GtkWidget    *xgdvi;
extern GdkColormap  *cmap;
extern GdkColor      color_fg, color_bg;

extern char **paper_list;
extern char **mode_list;

extern void  xgdvi_cleanup(void);

extern DVI   load_dvi(char *dvi_file_new, 
		      DVI_DEVICE dvi_dev, DVI_PROPERTY props, int retry);
extern int   find_file(char *file);
extern int   find_file_gui(char *file);
extern int   find_file_kill_old(char *file);
extern int   reload_file(void);
extern int   find_file_no_select(char *file, int g, int pid, int oid);
extern void  switched_buffer(void);
extern void  run_command(int); 
extern void  change_button_mode(int mode);
extern void  draw_page(void);
extern void  clear_page(void);
extern void  update_page_display(void);
DVI_PROPERTY make_dvi_property(void);
extern int   paper_id(char *paper);
extern char *paper_name(int paper_id);
extern void  resize_window(void);
extern int   change_window_params(int change_shrink, double shrink,
				  int swap_orientation);
extern int   goto_page(int p);
extern void  message(char *fmt,...);

#define POS_TYPE_TOP      1
#define POS_TYPE_BOTTOM   2 
#define POS_TYPE_LEFT     4 
#define POS_TYPE_RIGHT    8
extern void     preview_window_scroll_delta(int dx, int dy);
extern void     preview_window_scroll_rdelta(int rx, int ry);
extern void     preview_window_set_pos(double rx, double ry);
extern void     preview_window_set_pos_center(double rx, double ry);
extern void     preview_window_set_pos_type(int type);
extern void     preview_window_get_pos(double *rx, double *ry);
extern int      preview_window_get_pos_type(void);

extern gint  event_configure(GtkWidget *w, GdkEventConfigure *ev);
extern gint  event_configure_win(GtkWidget *w, GdkEventConfigure *ev);
extern gint  event_expose(GtkWidget *w, GdkEventExpose *ev);
extern gint  event_page_slider(GtkWidget *w, gpointer*);
extern gint  event_button_press(GtkWidget *w, GdkEventButton *ev);
extern gint  event_button_release(GtkWidget *w, GdkEventButton *ev);
extern gint  event_motion_notify(GtkWidget *w, GdkEventMotion *ev);
extern void  event_command_input(gpointer, gint, GdkInputCondition);
extern gint  event_key_press(GtkWidget *w, GdkEventKey *ev);



#define  SCROLL_DELTA     3
#define  SCROLL_MAX     100

#define  WINDOW_DELTA    50


#define IMGTYPE_BITMAP      0
#define IMGTYPE_GRAYMAP     1
#define IMGTYPE_PIXMAP_RGB  2


#endif /*__XGDVI_H__*/
/*EOF*/
