/*
 * Decompiled with CFR 0.152.
 */
package xtpipes;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import xtpipes.FileInfo;
import xtpipes.InputObject;
import xtpipes.XtpipesEntityResolver;
import xtpipes.XtpipesPrintWriter;
import xtpipes.XtpipesUni;

public class Xtpipes {
    private static HashMap<String, Object> map;
    private static boolean needScript;
    private static boolean returnDom;
    private static String result;
    static PrintWriter logWriter;
    private static String inFile;
    private static String inData;
    private static boolean exceptionErrs;
    private static boolean messages;
    public static InputObject inputObject;
    private static String outFileName;
    private static PrintWriter outPrintWriter;
    private static boolean returnToFile;
    public static String scriptFile;
    private static String scriptMap;
    static String i_scriptDir;
    private static TransformerFactory fc;
    private static Transformer identityTransformer;
    private static SAXParserFactory saxFactory;
    private static DocumentBuilder domBuilder;
    private static Stack<XMLReader> saxReaderStack;
    private static Method method;
    private static String rootName;
    static boolean trace;
    private static String[] ml2xml;
    static Class<?> ml2xmlClassObj;
    public static String errMssg;
    static ArrayList<String> nsName;
    static ArrayList<String> nsValue;

    public static void main(String[] stringArray) throws Exception {
        map = new HashMap();
        needScript = true;
        returnDom = false;
        result = null;
        inFile = null;
        inData = null;
        exceptionErrs = false;
        messages = false;
        outFileName = null;
        outPrintWriter = null;
        scriptFile = null;
        i_scriptDir = null;
        scriptMap = null;
        saxReaderStack = new Stack();
        rootName = null;
        trace = false;
        Xtpipes.mainMethod(stringArray);
    }

    public static void xtpipes(String[] stringArray, OutputStream outputStream, PrintWriter printWriter) throws Exception {
        map = new HashMap();
        needScript = true;
        returnDom = false;
        result = null;
        inFile = null;
        inData = null;
        exceptionErrs = false;
        messages = false;
        outFileName = null;
        outPrintWriter = null;
        scriptFile = null;
        i_scriptDir = null;
        scriptMap = null;
        saxReaderStack = new Stack();
        rootName = null;
        trace = false;
        outPrintWriter = new XtpipesPrintWriter(outputStream, true);
        logWriter = printWriter == null ? new PrintWriter(System.err) : printWriter;
        Xtpipes.mainMethod(stringArray);
        outPrintWriter.flush();
    }

    public static Document getDOM(String[] stringArray) throws Exception {
        map = new HashMap();
        needScript = true;
        returnDom = false;
        result = null;
        inFile = null;
        inData = null;
        exceptionErrs = false;
        messages = false;
        outFileName = null;
        outPrintWriter = null;
        scriptFile = null;
        i_scriptDir = null;
        scriptMap = null;
        saxReaderStack = new Stack();
        rootName = null;
        trace = false;
        returnDom = true;
        Xtpipes.mainMethod(stringArray);
        Document document = null;
        if (result == null) {
            System.err.println("--- xtpipes warning --- getDOM without <return name=\"...\"> from 4xt file: " + scriptFile);
        } else {
            Object object;
            Object[] objectArray;
            try {
                objectArray = result.getBytes("UTF-8");
                object = new ByteArrayInputStream((byte[])objectArray);
                document = domBuilder.parse((InputStream)object);
            }
            catch (SAXParseException sAXParseException) {
                if (trace) {
                    logWriter.println("\n---------------------------------------------------\n" + result + "\n---------------------------------------------------\n");
                }
                object = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].charAt(0) != '-') {
                        object = (String)object + "  input file: " + stringArray[i] + ".";
                        break;
                    }
                    if (!stringArray[i].equals("-s") && !stringArray[i].equals("-S") && !stringArray[i].equals("-i") && !stringArray[i].equals("-o") && !stringArray[i].equals("-d")) continue;
                    ++i;
                }
                if (scriptFile != null) {
                    object = (String)object + "    script file: " + scriptFile;
                }
                Xtpipes.instructionErr(null, "parsing error: " + sAXParseException.getMessage() + (String)object, 21);
            }
            catch (Exception exception) {
                Xtpipes.instructionErr(null, exception.toString(), 5);
            }
            if (ml2xmlClassObj != null) {
                objectArray = new Class[0];
                object = ml2xmlClassObj.getMethod("closeFiles", (Class<?>[])objectArray);
                Object[] objectArray2 = new Object[]{};
                ((Method)object).invoke(null, objectArray2);
            }
        }
        return document;
    }

    public static Document getDOM(String string, String[] stringArray) throws Exception {
        map = new HashMap();
        needScript = true;
        returnDom = false;
        result = null;
        inFile = null;
        inData = null;
        exceptionErrs = false;
        messages = false;
        outFileName = null;
        outPrintWriter = null;
        scriptFile = null;
        i_scriptDir = null;
        scriptMap = null;
        saxReaderStack = new Stack();
        rootName = null;
        trace = false;
        returnDom = true;
        inData = string;
        Xtpipes.mainMethod(stringArray);
        Document document = null;
        if (result == null) {
            System.err.println("--- xtpipes warning --- getDOM without <return name=\"...\"> from 4xt file: " + scriptFile);
        } else {
            Object object;
            Object[] objectArray;
            try {
                objectArray = result.getBytes("UTF-8");
                object = new ByteArrayInputStream((byte[])objectArray);
                document = domBuilder.parse((InputStream)object);
            }
            catch (SAXParseException sAXParseException) {
                Xtpipes.instructionErr(null, "improper xml: " + sAXParseException.getMessage() + "\n code starts with: " + result.substring(0, Math.min(100, result.length())), 17);
            }
            catch (Exception exception) {
                Xtpipes.instructionErr(null, exception.toString(), 6);
            }
            if (ml2xmlClassObj != null) {
                objectArray = new Class[0];
                object = ml2xmlClassObj.getMethod("closeFiles", (Class<?>[])objectArray);
                Object[] objectArray2 = new Object[]{};
                ((Method)object).invoke(null, objectArray2);
            }
        }
        return document;
    }

    public static Document getDOM(String[] stringArray, PrintWriter printWriter) throws Exception {
        logWriter = printWriter == null ? new PrintWriter(System.err) : printWriter;
        return Xtpipes.getDOM(stringArray);
    }

    public static Document getDOM(String string, String[] stringArray, PrintWriter printWriter) throws Exception {
        logWriter = printWriter == null ? new PrintWriter(System.err) : printWriter;
        return Xtpipes.getDOM(string, stringArray);
    }

    private static void mainMethod(String[] stringArray) throws Exception {
        Object object;
        try {
            object = "   xtpipes (2008-01-26-00:38)\n   Command line options: \n     java xtpipes [-trace] [-help] [-m] [-E] [-s script_file] [-S script_map]\n                  [-i script_dir] [-o out_file] \n                  [-x...ml2xml_arg...]  (-d in_data | in_file)\n     -m        messages printing mode\n     -E        error messages into exception calls\n     in_data   XML data directly into the command line\n";
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                if (stringArray[i] == null || stringArray[i].equals("")) continue;
                if (stringArray[i].charAt(0) != '-') {
                    inFile = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-m")) {
                    messages = true;
                    logWriter.println("xtpipes (2008-01-26-00:38)\n java.version: " + System.getProperty("java.version") + "\n java.class.path: " + System.getProperty("java.class.path") + "\n os.name: " + System.getProperty("os.name") + "\n user.home: " + System.getProperty("user.home") + "\n user.dir: " + System.getProperty("user.dir"));
                    for (n = 0; n < stringArray.length; ++n) {
                        logWriter.println("     " + stringArray[n]);
                    }
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    if (++i < stringArray.length) {
                        scriptFile = stringArray[i];
                        continue;
                    }
                    System.err.println("--- Error --- Missing field for -s argument");
                    inFile = null;
                    inData = null;
                    break;
                }
                if (stringArray[i].equals("-S")) {
                    if (++i < stringArray.length) {
                        scriptMap = stringArray[i];
                        continue;
                    }
                    System.err.println("--- Error --- Missing field for -S argument");
                    inFile = null;
                    inData = null;
                    break;
                }
                if (stringArray[i].equals("-i")) {
                    if (++i < stringArray.length) {
                        i_scriptDir = stringArray[i];
                        continue;
                    }
                    System.err.println("--- Error --- Missing field for -i argument");
                    inFile = null;
                    inData = null;
                    break;
                }
                if (stringArray[i].equals("-o")) {
                    if (++i < stringArray.length) {
                        outFileName = stringArray[i];
                        continue;
                    }
                    System.err.println("--- Error --- Missing field for -o argument");
                    inFile = null;
                    inData = null;
                    break;
                }
                if (stringArray[i].startsWith("-x")) {
                    if (stringArray[i].substring(2).equals("")) {
                        if (ml2xml != null) continue;
                        ml2xml = new String[0];
                        continue;
                    }
                    if (ml2xml == null) {
                        ml2xml = new String[1];
                    } else {
                        String[] stringArray2 = new String[ml2xml.length + 1];
                        for (int j = 0; j < ml2xml.length; ++j) {
                            stringArray2[j] = ml2xml[j];
                        }
                        ml2xml = stringArray2;
                    }
                    Xtpipes.ml2xml[Xtpipes.ml2xml.length - 1] = stringArray[i].substring(2);
                    continue;
                }
                if (stringArray[i].equals("-E")) {
                    exceptionErrs = true;
                    continue;
                }
                if (stringArray[i].equals("-d")) {
                    if (++i < stringArray.length) {
                        inData = stringArray[i];
                        continue;
                    }
                    System.err.println("--- Error --- Missing field for -d argument");
                    inFile = null;
                    inData = null;
                    break;
                }
                if (stringArray[i].equals("-trace")) {
                    trace = true;
                    continue;
                }
                if (stringArray[i].equals("-help")) {
                    bl = true;
                    continue;
                }
                if (!exceptionErrs) {
                    for (n = i + 1; n < stringArray.length; ++n) {
                        if (!stringArray[n].equals("-E")) continue;
                        exceptionErrs = true;
                    }
                }
                Xtpipes.instructionErr(null, "Improper argument: " + stringArray[i] + "\n" + (String)object, 26);
            }
            if (outPrintWriter == null) {
                outPrintWriter = new XtpipesPrintWriter(System.out, true);
            }
            if (!returnDom && (bl || inFile == null && inData == null)) {
                System.err.println((String)object);
                if (inFile == null && inData == null) {
                    System.exit(0);
                }
            }
            new FileInfo(logWriter, i_scriptDir, trace);
            if (inFile != null) {
                inputObject = new InputObject(inFile, logWriter);
                if (inputObject.getInputStream() == null) {
                    Xtpipes.instructionErr(null, "Could not find or open file: " + inFile, 28);
                }
                inFile = inputObject.getFilename();
            } else {
                inputObject = new InputObject(inData.getBytes("UTF-8"), logWriter);
            }
            inputObject.buildProfile(trace);
        }
        catch (Exception exception) {
            Xtpipes.instructionErr(null, exception.getMessage(), exception.getStackTrace(), 31);
        }
        try {
            Object object2;
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            documentBuilder.setEntityResolver(new XtpipesEntityResolver());
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                    this.showSpecifics("warning", sAXParseException);
                }

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    this.showSpecifics("error", sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    this.showSpecifics("fatal error", sAXParseException);
                }

                public void showSpecifics(String string, SAXParseException sAXParseException) throws SAXParseException {
                    String string2 = "--- xtpipes " + string + " 24 --- " + sAXParseException.getSystemId() + " line " + sAXParseException.getLineNumber() + " col " + sAXParseException.getColumnNumber() + " : " + sAXParseException.getMessage();
                    if (exceptionErrs) {
                        throw new SAXParseException(string2, (Locator)null);
                    }
                    System.err.println(string2);
                    System.exit(1);
                }
            });
            fc = TransformerFactory.newInstance();
            identityTransformer = fc.newTransformer();
            identityTransformer.setErrorListener(new ErrorListener(){

                public void warning(TransformerException transformerException) throws TransformerException {
                    this.showSpecifics(transformerException);
                }

                public void error(TransformerException transformerException) throws TransformerException {
                    this.showSpecifics(transformerException);
                }

                public void fatalError(TransformerException transformerException) throws TransformerException {
                    this.showSpecifics(transformerException);
                }

                void showSpecifics(TransformerException transformerException) throws TransformerException {
                    String string = transformerException.getMessage();
                    String string2 = transformerException.getLocationAsString();
                    if (string2 != null) {
                        string = string2 + ": " + string;
                    }
                    throw new TransformerException(string);
                }
            });
            saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(true);
            ((DocumentBuilderFactory)object).setValidating(false);
            domBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            Class<Xtpipes> clazz = Xtpipes.class;
            Class[] classArray = new Class[]{Node.class, String.class};
            method = clazz.getMethod("execute", classArray);
            if (scriptMap != null) {
                try {
                    Object object3;
                    String string = FileInfo.searchFile(scriptMap);
                    if (string == null) {
                        throw new FileNotFoundException(scriptMap);
                    }
                    scriptMap = string;
                    if (saxReaderStack.empty()) {
                        object3 = saxFactory.newSAXParser();
                        object2 = ((SAXParser)object3).getXMLReader();
                        object2.setEntityResolver(new EntityResolver(){

                            public InputSource resolveEntity(String string, String string2) {
                                if (new File(string2).exists()) {
                                    return new InputSource(string2);
                                }
                                StringReader stringReader = new StringReader("");
                                return new InputSource(stringReader);
                            }
                        });
                    } else {
                        object2 = saxReaderStack.pop();
                    }
                    object2.setContentHandler(new DefaultHandler(){
                        private Stack<Boolean> condition = new Stack();

                        public void startDocument() {
                            this.condition.push(new Boolean(true));
                        }

                        public void startElement(String string, String string2, String string3, Attributes attributes) {
                            String string4;
                            if (this.condition == null) {
                                return;
                            }
                            if (trace) {
                                String string5 = "<" + string3 + "\n";
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    string4 = attributes.getQName(i);
                                    string5 = string5 + " " + string4 + "=\"" + attributes.getValue(i) + "\"";
                                }
                                string5 = string5 + ">";
                                logWriter.println(string5);
                            }
                            boolean bl = this.condition.peek();
                            if (string3.equals("when")) {
                                if (bl) {
                                    String string6 = attributes.getValue("name");
                                    string4 = attributes.getValue("value");
                                    if (string6.equals("system-id")) {
                                        bl = string4.equals(inputObject.getSystemId());
                                    } else if (string6.equals("public-id")) {
                                        bl = string4.equals(inputObject.getPublicId());
                                    } else if (string6.equals("dtd-root")) {
                                        bl = string4.equals(inputObject.getDtdRoot());
                                    } else if (string6.equals("root")) {
                                        bl = string4.equals(inputObject.getRoot());
                                    } else if (string6.equals("ext")) {
                                        bl = inputObject.getFilename().endsWith("." + string4);
                                    } else if (string6.equals("prefix")) {
                                        string6 = inputObject.getFilename();
                                        if (string6 != null) {
                                            int n = string6.lastIndexOf(47);
                                            if (n != -1 && n + 1 < string6.length()) {
                                                string6 = string6.substring(n + 1);
                                            }
                                            if ((n = string6.lastIndexOf(92)) != -1 && n + 1 < string6.length()) {
                                                string6 = string6.substring(n + 1);
                                            }
                                            bl = string6.startsWith(string4);
                                        }
                                    } else if (string6.equals("meta-type")) {
                                        bl = string4.equals(inputObject.getMetaType());
                                    } else if (string6.equals("content-type")) {
                                        bl = string4.equals(inputObject.getContentType());
                                    }
                                }
                            } else if (string3.equals("command-line")) {
                                if (scriptFile != null) {
                                    if (trace) {
                                        logWriter.println(" Found script file in map: " + scriptFile);
                                    }
                                    this.condition = null;
                                    return;
                                }
                            } else if (string3.equals("processing-instruction")) {
                                String string7;
                                if (bl && (string7 = inputObject.getXtpipes()) != null) {
                                    scriptFile = string7;
                                    if (trace) {
                                        logWriter.println(" Found script file in map: " + scriptFile);
                                    }
                                    this.condition = null;
                                    return;
                                }
                            } else if (string3.equals("select") && bl) {
                                scriptFile = attributes.getValue("name");
                                if (trace) {
                                    logWriter.println(" Found script file in map: " + scriptFile);
                                }
                                this.condition = null;
                                return;
                            }
                            this.condition.push(new Boolean(bl));
                        }

                        public void endElement(String string, String string2, String string3) {
                            if (this.condition == null) {
                                return;
                            }
                            if (trace) {
                                String string4 = "</" + string3 + ">";
                                logWriter.println(string4);
                            }
                            this.condition.pop();
                        }
                    });
                    object3 = new File(scriptMap).toURI().toURL().openStream();
                    object2.parse(new InputSource((InputStream)object3));
                    saxReaderStack.push((XMLReader)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Xtpipes.instructionErr(null, "File not found: " + fileNotFoundException.getMessage() + "; command line option -i", 33);
                }
                catch (Exception exception) {
                    Xtpipes.instructionErr(null, exception.toString(), exception.getStackTrace(), 27);
                }
            }
            if (scriptFile == null) {
                scriptFile = "xtpipes-default.4xt";
            }
            while (needScript) {
                String string;
                if (scriptFile == null) {
                    Xtpipes.instructionErr(null, "Missing 4xt script file name", 32);
                }
                if ((string = FileInfo.searchFile(scriptFile)) == null) {
                    throw new FileNotFoundException(scriptFile);
                }
                scriptFile = string;
                object2 = documentBuilder.parse(scriptFile);
                if (trace) {
                    logWriter.println("(" + scriptFile + ")");
                }
                Xtpipes.execute(object2.getFirstChild());
            }
            if (outFileName != null) {
                outPrintWriter.close();
            }
            logWriter.flush();
        }
        catch (SAXParseException sAXParseException) {
            String string = "Improper file " + scriptFile + ": " + sAXParseException.getMessage();
            Xtpipes.instructionErr(null, string, 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = scriptFile.equals(fileNotFoundException.getMessage()) ? "Could not find file: " + scriptFile : "Problem at script " + scriptFile + ": Could not find file " + fileNotFoundException.getMessage();
            Xtpipes.instructionErr(null, string, 3);
        }
        catch (Exception exception) {
            String string = "Problems at file: " + scriptFile + "\n   " + exception;
            Xtpipes.instructionErr(null, string, 4);
        }
    }

    private static void execute(Node node) throws Exception {
        while (node != null) {
            block122: {
                if (node.getNodeType() == 1) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string = node.getNodeName();
                    if (trace) {
                        logWriter.print("[##] = xtpipes => " + string);
                        if (node.hasAttributes()) {
                            object5 = node.getAttributes();
                            for (int i = 0; i < object5.getLength(); ++i) {
                                object4 = object5.item(i);
                                logWriter.print(" " + object4.getNodeName() + "=\"" + object4.getNodeValue() + "\"");
                            }
                        }
                        logWriter.println();
                        logWriter.flush();
                    }
                    if (string.equals("xtpipes")) {
                        needScript = false;
                        if (node.hasChildNodes()) {
                            if (outFileName != null) {
                                try {
                                    object5 = new FileWriter(outFileName);
                                    outPrintWriter = new XtpipesPrintWriter((FileWriter)object5);
                                    returnToFile = true;
                                }
                                catch (Exception exception) {
                                    Xtpipes.instructionErr(null, exception.toString(), 12);
                                }
                            }
                            if (node.hasAttributes()) {
                                object5 = node.getAttributes().getNamedItem("signature");
                                if (object5 != null && messages) {
                                    logWriter.println(object5.getNodeValue());
                                }
                                if ((object5 = node.getAttributes().getNamedItem("preamble")) != null && object5.getNodeValue().equals("yes")) {
                                    try {
                                        String string2;
                                        boolean bl = true;
                                        rootName = "<" + (rootName == null ? inputObject.getRoot() : rootName);
                                        if (inData == null) {
                                            object3 = new URL(inFile).openConnection();
                                            ((URLConnection)object3).setRequestProperty("User-Agent", "[" + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + "]" + "[" + System.getProperty("java.version") + " - " + System.getProperty("java.vendor") + "]");
                                            object2 = ((URLConnection)object3).getInputStream();
                                            object = new BufferedReader(new InputStreamReader((InputStream)object2));
                                            while ((string2 = ((BufferedReader)object).readLine()) != null && bl) {
                                                int n = string2.indexOf(rootName);
                                                if (n > -1) {
                                                    bl = false;
                                                    string2 = string2.substring(0, n);
                                                }
                                                outPrintWriter.println(string2);
                                                returnToFile = false;
                                            }
                                            ((BufferedReader)object).close();
                                        } else {
                                            int n = inData.indexOf(rootName);
                                            if (n > -1) {
                                                bl = false;
                                                string2 = inData.substring(0, n);
                                            } else {
                                                string2 = "";
                                            }
                                            outPrintWriter.println(string2);
                                            returnToFile = false;
                                        }
                                    }
                                    catch (Exception exception) {
                                        System.err.println("--- Error --- Couldn't copy preamble: " + exception);
                                    }
                                }
                            }
                            Xtpipes.execute(node.getFirstChild());
                        } else if (inData == null) {
                            scriptFile = inputObject.getXtpipes();
                            rootName = inputObject.getRoot();
                            needScript = true;
                        } else {
                            scriptFile = inputObject.getXtpipes();
                            rootName = inputObject.getRoot();
                            needScript = true;
                        }
                    } else if (string.equals("set")) {
                        object5 = node.getAttributes().getNamedItem("name").getNodeValue();
                        Node node2 = node.getFirstChild();
                        while (node2.getNodeType() != 4) {
                            node2 = node2.getNextSibling();
                        }
                        object4 = node2.getNodeValue().trim();
                        map.put((String)object5, object4);
                    } else if (string.equals("get")) {
                        try {
                            object5 = node.getAttributes().getNamedItem("name").getNodeValue();
                            String string3 = node.getAttributes().getNamedItem("file").getNodeValue();
                            object4 = new StreamSource(new File(string3));
                            object3 = new ByteArrayOutputStream();
                            identityTransformer.transform((Source)object4, new StreamResult((OutputStream)object3));
                            object2 = ((ByteArrayOutputStream)object3).toByteArray();
                            map.put((String)object5, new String((byte[])object2));
                        }
                        catch (Exception exception) {
                            Xtpipes.instructionErr(node, exception.toString(), 14);
                        }
                    } else if (string.equals("print")) {
                        object5 = node.getAttributes().getNamedItem("name").getNodeValue();
                        String string4 = (String)map.get(object5);
                        if (node.getAttributes().getNamedItem("file") == null) {
                            if (!trace) {
                                logWriter.println("[##]  = xtpipes => print: " + scriptFile);
                            }
                            logWriter.println(XtpipesUni.toUni(string4, ""));
                        } else {
                            object4 = node.getAttributes().getNamedItem("file").getNodeValue();
                            try {
                                object3 = new FileWriter((String)object4);
                                object2 = new XtpipesPrintWriter((FileWriter)object3);
                                ((XtpipesPrintWriter)object2).println(string4);
                                ((PrintWriter)object2).close();
                            }
                            catch (Exception exception) {
                                Xtpipes.instructionErr(node, exception.toString(), 15);
                            }
                        }
                    } else if (string.equals("return")) {
                        object5 = node.getAttributes().getNamedItem("name").getNodeValue();
                        result = (String)map.get(object5);
                        if (returnToFile) {
                            outPrintWriter.println(result);
                        }
                    } else {
                        Object object6;
                        String string5;
                        Object object7;
                        Object object8;
                        Object object9;
                        Object[] objectArray;
                        Object object10;
                        Object object11;
                        Object object12;
                        Object object13;
                        if (string.equals("if")) {
                            try {
                                object5 = node.getAttributes().getNamedItem("xml").getNodeValue();
                                String string6 = node.getAttributes().getNamedItem("dtd").getNodeValue();
                                object4 = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE doc [\n" + (String)map.get(string6) + "\n]>\n" + (String)map.get(object5);
                                object3 = ((String)object4).getBytes("UTF-8");
                                object2 = new ByteArrayInputStream((byte[])object3);
                                object = new InputSource((InputStream)object2);
                                object13 = saxFactory.newSAXParser();
                                object12 = ((SAXParser)object13).getXMLReader();
                                object12.parse((InputSource)object);
                                if (trace) {
                                    logWriter.print("--> true");
                                }
                                Xtpipes.execute(node.getFirstChild());
                            }
                            catch (Exception exception) {
                                if (trace) {
                                    logWriter.print("--> true");
                                }
                                break block122;
                            }
                        }
                        if (string.equals("xslt")) {
                            try {
                                object5 = node.getAttributes().getNamedItem("xml");
                                StreamSource streamSource = null;
                                if (object5 == null) {
                                    if (inData == null) {
                                        streamSource = new StreamSource(new File(inFile));
                                    } else {
                                        object3 = inData.getBytes("UTF-8");
                                        object2 = new ByteArrayInputStream((byte[])object3);
                                        streamSource = new StreamSource((InputStream)object2);
                                    }
                                } else {
                                    object4 = object5.getNodeValue();
                                    object3 = (String)map.get(object4);
                                    if (object3 != null) {
                                        object2 = ((String)object3).getBytes("UTF-8");
                                        object = new ByteArrayInputStream((byte[])object2);
                                        streamSource = new StreamSource((InputStream)object);
                                    }
                                }
                                object3 = node.getAttributes().getNamedItem("xsl").getNodeValue();
                                object2 = (String)map.get(object3);
                                object = ((String)object2).getBytes("UTF-8");
                                object13 = new ByteArrayInputStream((byte[])object);
                                object12 = new StreamSource((InputStream)object13);
                                object11 = node.getAttributes().getNamedItem("name");
                                object10 = null;
                                if (object11 == null) {
                                    objectArray = new StreamResult(outPrintWriter);
                                    returnToFile = false;
                                } else {
                                    object10 = new CharArrayWriter();
                                    objectArray = new StreamResult((Writer)object10);
                                }
                                errMssg = null;
                                fc.setErrorListener(new ErrorListener(){

                                    public void warning(TransformerException transformerException) throws TransformerException {
                                        this.showSpecifics(transformerException);
                                    }

                                    public void error(TransformerException transformerException) throws TransformerException {
                                        this.showSpecifics(transformerException);
                                    }

                                    public void fatalError(TransformerException transformerException) throws TransformerException {
                                        this.showSpecifics(transformerException);
                                    }

                                    void showSpecifics(TransformerException transformerException) throws TransformerException {
                                        String string = transformerException.getMessage();
                                        String string2 = transformerException.getLocationAsString();
                                        if (string2 != null) {
                                            string = string2 + ": " + string;
                                        }
                                        string = "XSL stylesheet problem: " + string;
                                        if (errMssg == null) {
                                            errMssg = string;
                                        }
                                        throw new TransformerException(string);
                                    }
                                });
                                object9 = fc.newTransformer((Source)object12);
                                ((Transformer)object9).setErrorListener(new ErrorListener(){

                                    public void warning(TransformerException transformerException) throws TransformerException {
                                        this.showSpecifics(transformerException);
                                    }

                                    public void error(TransformerException transformerException) throws TransformerException {
                                        this.showSpecifics(transformerException);
                                    }

                                    public void fatalError(TransformerException transformerException) throws TransformerException {
                                        this.showSpecifics(transformerException);
                                    }

                                    void showSpecifics(TransformerException transformerException) throws TransformerException {
                                        String string = transformerException.getMessage();
                                        String string2 = transformerException.getLocationAsString();
                                        if (string2 != null) {
                                            string = string2 + ": " + string;
                                        }
                                        if (errMssg == null) {
                                            errMssg = string;
                                        }
                                        string = "XML document prblem: " + string;
                                        throw new TransformerException(string);
                                    }
                                });
                                ((Transformer)object9).transform(streamSource, (Result)objectArray);
                                if (object11 != null) {
                                    object8 = object11.getNodeValue();
                                    object7 = ((CharArrayWriter)object10).toCharArray();
                                    map.put((String)object8, new String((char[])object7));
                                }
                            }
                            catch (TransformerException transformerException) {
                                if (trace) {
                                    transformerException.printStackTrace();
                                }
                                Xtpipes.instructionErr(node, transformerException.getMessage() + (errMssg == null ? "" : "; " + errMssg), 37);
                            }
                            catch (Exception exception) {
                                if (trace) {
                                    exception.printStackTrace();
                                }
                                Xtpipes.instructionErr(node, errMssg == null ? exception.toString() : exception.toString() + "; " + errMssg, 16);
                            }
                        } else if (string.equals("dom")) {
                            try {
                                Document document;
                                object5 = node.getAttributes().getNamedItem("xml");
                                if (object5 == null) {
                                    if (inData == null) {
                                        document = domBuilder.parse(new File(inFile));
                                    } else {
                                        object4 = inData.getBytes("UTF-8");
                                        object3 = new ByteArrayInputStream((byte[])object4);
                                        document = domBuilder.parse((InputStream)object3);
                                    }
                                } else {
                                    object4 = object5.getNodeValue();
                                    object3 = (String)map.get(object4);
                                    if (object3 == null) {
                                        Xtpipes.instructionErr(node, "improper xml attribute value", 18);
                                    }
                                    object2 = ((String)object3).getBytes("UTF-8");
                                    object = new ByteArrayInputStream((byte[])object2);
                                    document = domBuilder.parse((InputStream)object);
                                }
                                object4 = node.getAttributes().getNamedItem("class").getNodeValue();
                                object3 = node.getAttributes().getNamedItem("method").getNodeValue();
                                object2 = Class.forName((String)object4);
                                object = new Class[]{Node.class};
                                object13 = ((Class)object2).getMethod((String)object3, (Class<?>)object);
                                object12 = new Object[]{document};
                                ((Method)object13).invoke(null, object12);
                                object11 = node.getAttributes().getNamedItem("name");
                                object10 = null;
                                if (object11 == null) {
                                    objectArray = new StreamResult(outPrintWriter);
                                    returnToFile = false;
                                } else {
                                    object10 = new CharArrayWriter();
                                    objectArray = new StreamResult((Writer)object10);
                                }
                                Xtpipes.cleanXmlns(document);
                                object9 = new DOMSource(document);
                                try {
                                    identityTransformer.transform((Source)object9, (Result)objectArray);
                                }
                                catch (TransformerException transformerException) {
                                    object7 = trace ? "\n------------------------ xml code ------------------------\n" + Xtpipes.serialize(document) + "\n----------------------------------------------------------\n" : "";
                                    Xtpipes.instructionErr(node, transformerException.getMessage() + (String)object7, 35);
                                }
                                if (object11 != null) {
                                    object8 = object11.getNodeValue();
                                    object7 = ((CharArrayWriter)object10).toCharArray();
                                    string5 = new String((char[])object7);
                                    object6 = node.getAttributes().getNamedItem("dcl");
                                    if ((object6 == null || object6.getNodeValue().equals("no")) && string5.length() > 7 && string5.startsWith("<?xml") && !Character.isLetterOrDigit(string5.charAt(5))) {
                                        string5 = string5.substring(string5.indexOf("?>") + 2);
                                    }
                                    map.put((String)object8, string5);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                Xtpipes.instructionErr(node, "could not find method: " + noSuchMethodException.getMessage(), 18);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                if (trace) {
                                    invocationTargetException.printStackTrace();
                                }
                                Xtpipes.instructionErr(node, invocationTargetException.getCause().toString(), 36);
                            }
                            catch (Exception exception) {
                                if (trace) {
                                    exception.printStackTrace();
                                }
                                Xtpipes.instructionErr(node, exception.toString(), 20);
                            }
                        } else if (string.equals("sax")) {
                            object5 = "";
                            try {
                                Object object14;
                                Object object15;
                                Object object16;
                                Node node3 = node.getAttributes().getNamedItem("xml");
                                object4 = null;
                                object3 = null;
                                if (node3 == null) {
                                    if (inData == null) {
                                        object3 = inFile;
                                    } else {
                                        object2 = inData.getBytes("UTF-8");
                                        object = new ByteArrayInputStream((byte[])object2);
                                        object4 = new InputSource((InputStream)object);
                                    }
                                } else {
                                    object3 = node3.getNodeValue();
                                    object2 = (String)map.get(object3);
                                    if (object2 != null) {
                                        object = ((String)object2).getBytes("UTF-8");
                                        object13 = new ByteArrayInputStream((byte[])object);
                                        object4 = new InputSource((InputStream)object13);
                                    }
                                }
                                object2 = node.getAttributes().getNamedItem("content-handler").getNodeValue().split(",");
                                object = new Class[]{PrintWriter.class, HashMap.class, Method.class, PrintWriter.class, Boolean.TYPE};
                                object13 = node.getAttributes().getNamedItem("name");
                                object11 = null;
                                if (object13 == null) {
                                    object12 = outPrintWriter;
                                    returnToFile = false;
                                } else {
                                    object11 = new CharArrayWriter();
                                    object12 = new PrintWriter((Writer)object11);
                                }
                                objectArray = new Object[5];
                                objectArray[0] = object12;
                                object10 = new HashMap();
                                for (object9 = node.getFirstChild(); object9 != null; object9 = object9.getNextSibling()) {
                                    if (object9.getNodeType() != 1) continue;
                                    object8 = object9.getAttributes().getNamedItem("element").getNodeValue();
                                    if (((HashMap)object10).containsKey(object8)) {
                                        System.err.println("--- Warning --- redfining script: " + (String)object8);
                                    }
                                    ((HashMap)object10).put(object8, object9);
                                }
                                objectArray[1] = object10;
                                objectArray[2] = method;
                                objectArray[3] = logWriter;
                                objectArray[4] = trace;
                                object8 = Class.forName(((String)object2[0]).trim());
                                object7 = ((Class)object8).getConstructor((Class<?>)object);
                                string5 = ((Constructor)object7).newInstance(objectArray);
                                if (saxReaderStack.empty()) {
                                    object16 = saxFactory.newSAXParser();
                                    object6 = ((SAXParser)object16).getXMLReader();
                                    object6.setEntityResolver(new EntityResolver(){

                                        public InputSource resolveEntity(String string, String string2) {
                                            if (new File(string2).exists()) {
                                                return new InputSource(string2);
                                            }
                                            StringReader stringReader = new StringReader("");
                                            return new InputSource(stringReader);
                                        }
                                    });
                                } else {
                                    object6 = saxReaderStack.pop();
                                }
                                object16 = object6;
                                for (int i = 1; i < ((Object)object2).length; ++i) {
                                    object = new Class[]{PrintWriter.class, PrintWriter.class, Boolean.TYPE};
                                    objectArray = new Object[]{object12, logWriter, trace};
                                    object5 = "Class.forName( " + ((String)object2[i]).trim() + ") ";
                                    object8 = Class.forName(((String)object2[i]).trim());
                                    object5 = "get-constructor " + ((String)object2[i]).trim() + "( PrintWriter, PrintWriter, boolean ) ";
                                    object7 = ((Class)object8).getConstructor((Class<?>)object);
                                    object5 = "get-object " + ((String)object2[i]).trim() + "( PrintWriter, PrintWriter, boolean ) ";
                                    if (((Class)object8).getModifiers() % 2 != 1) {
                                        object5 = (String)object5 + "; class not defined to be public. ";
                                    }
                                    object15 = (XMLFilter)((Constructor)object7).newInstance(objectArray);
                                    object5 = "set-parent " + ((String)object2[i]).trim() + "( PrintWriter, PrintWriter, boolean ) ";
                                    object15.setParent((XMLReader)object6);
                                    object6 = object15;
                                }
                                object5 = "setContentHandler( " + ((String)object2[0]).trim() + " )";
                                object6.setContentHandler((ContentHandler)((Object)string5));
                                Node node4 = node.getAttributes().getNamedItem("lexical-handler");
                                if (node4 != null) {
                                    object15 = node4.getNodeValue();
                                    object = new Class[]{Class.forName(((String)object2[0]).trim()), PrintWriter.class, Boolean.TYPE};
                                    objectArray = new Object[]{string5, logWriter, trace};
                                    object5 = "Class.forName( " + ((String)object15).trim() + ") ";
                                    object8 = Class.forName(((String)object15).trim());
                                    object5 = "get-constructor " + ((String)object15).trim() + "( " + ((String)object2[0]).trim() + " ) ";
                                    object7 = ((Class)object8).getConstructor((Class<?>)object);
                                    object5 = "get-object " + ((String)object15).trim() + "( ... ) ";
                                    object14 = ((Constructor)object7).newInstance(objectArray);
                                    object5 = "set lexical handler " + ((String)object15).trim() + " ";
                                    object6.setProperty("http://xml.org/sax/properties/lexical-handler", (LexicalHandler)object14);
                                }
                                object6.setEntityResolver(new EntityResolver(){

                                    public InputSource resolveEntity(String string, String string2) {
                                        if (new File(string2).exists()) {
                                            return new InputSource(string2);
                                        }
                                        StringReader stringReader = new StringReader("");
                                        return new InputSource(stringReader);
                                    }
                                });
                                if (object4 == null) {
                                    Object object17;
                                    object5 = "While parsing file " + (String)object3 + ": ";
                                    object15 = null;
                                    if (ml2xml == null) {
                                        if (trace) {
                                            logWriter.println("No request for ml2xml configuration (command line option -x)");
                                        }
                                        try {
                                            object15 = new File((String)object3).toURI().toURL().openStream();
                                        }
                                        catch (FileNotFoundException fileNotFoundException) {
                                            try {
                                                object17 = null;
                                                try {
                                                    object17 = new URL((String)object3);
                                                }
                                                catch (MalformedURLException malformedURLException) {
                                                    object17 = new File((String)object3).toURI().toURL();
                                                }
                                                object15 = ((URL)object17).openStream();
                                            }
                                            catch (FileNotFoundException fileNotFoundException2) {
                                                object15 = new File(new File((String)object3).toURI().toURL().toString()).toURI().toURL().openStream();
                                            }
                                        }
                                    } else {
                                        try {
                                            ml2xmlClassObj = Class.forName("ml2xml.Ml2xml");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            Xtpipes.instructionErr(null, "Class not found: ml2xml.Ml2xml", 25);
                                        }
                                        object14 = new Class[]{String.class, String[].class};
                                        object17 = ml2xmlClassObj.getConstructor((Class<?>[])object14);
                                        try {
                                            if (trace) {
                                                String string7 = "Calling: ml2xml.Ml2xml(inputStream,new String[]{";
                                                for (int i = 0; i < ml2xml.length; ++i) {
                                                    string7 = string7 + (i == 0 ? "\"" : ", \"") + ml2xml[i] + "\"";
                                                }
                                                string7 = string7 + "})";
                                                logWriter.println(string7);
                                            }
                                            object15 = (InputStream)((Constructor)object17).newInstance(object3, ml2xml);
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            String string8 = "Problem at: ml2xml.Ml2xml(" + (String)object3 + "," + "new String[]{";
                                            for (int i = 0; i < ml2xml.length; ++i) {
                                                string8 = string8 + (i == 0 ? "\"" : ", \"") + ml2xml[i] + "\"";
                                            }
                                            string8 = string8 + "})";
                                            Xtpipes.instructionErr(null, string8 + "; " + invocationTargetException.getCause(), 38);
                                        }
                                    }
                                    object6.parse(new InputSource((InputStream)object15));
                                    if (ml2xml != null) {
                                        object14 = new Class[0];
                                        object17 = ml2xmlClassObj.getMethod("closeFiles", (Class<?>[])object14);
                                        ((Method)object17).invoke(null, new Object[0]);
                                    }
                                } else {
                                    object5 = "xtpipes sax parsing error";
                                    object6.parse((InputSource)object4);
                                }
                                if (object13 != null) {
                                    object15 = object13.getNodeValue();
                                    object14 = ((CharArrayWriter)object11).toCharArray();
                                    map.put((String)object15, new String((char[])object14));
                                }
                                saxReaderStack.push((XMLReader)object16);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                Xtpipes.instructionErr(node, (String)object5 + "could not find file: " + fileNotFoundException.getMessage(), 19);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                Xtpipes.instructionErr(node, (String)object5 + " class not found: " + classNotFoundException.getMessage() + "\n classpath = " + System.getProperty("java.class.path") + " ---", 22);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Xtpipes.instructionErr(node, (String)object5 + ": " + invocationTargetException.getCause(), 23);
                            }
                            catch (Exception exception) {
                                Xtpipes.instructionErr(node, (String)object5 + exception.toString(), 29);
                            }
                        } else {
                            Xtpipes.instructionErr(node, "Improper instruction: " + string, 11);
                        }
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    public static String execute(Node node, String string) throws Exception {
        String string2 = ".";
        String string3 = (String)map.get(string2);
        map.put(string2, string);
        Xtpipes.execute(node.getFirstChild());
        String string4 = (String)map.get(string2);
        if (string3 != null) {
            map.put(string2, string3);
        }
        return string4;
    }

    private static void instructionErr(Node node, String string, int n) throws Exception {
        Object[] objectArray;
        Object object;
        String string2 = "--- xtpipes error " + n + " --- ";
        if (node != null) {
            string2 = string2 + "At <" + node.getNodeName();
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                objectArray = object.item(i);
                string2 = string2 + " " + objectArray.getNodeName() + "=\"" + objectArray.getNodeValue() + "\"";
            }
            string2 = string2 + " > : ";
        }
        string2 = string2 + string;
        if (ml2xmlClassObj != null) {
            object = new Class[]{};
            Method method = ml2xmlClassObj.getMethod("closeFiles", (Class<?>)object);
            objectArray = new Object[]{};
            method.invoke(null, objectArray);
        }
        logWriter.flush();
        if (exceptionErrs) {
            throw new Exception(string2);
        }
        System.err.println(string2);
        System.exit(1);
    }

    private static void instructionErr(Node node, String string, StackTraceElement[] stackTraceElementArray, int n) throws Exception {
        logWriter.println("--- xtpipes error " + n + " --- " + string);
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            logWriter.println(stackTraceElementArray[i].toString());
        }
        Xtpipes.instructionErr(node, string, n);
    }

    static String serialize(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            String string = "";
            String string2 = node.getNodeName();
            string = string + "<" + string2;
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                string = string + "\n" + attr.getName() + "=\"" + attr.getValue() + "\" ";
            }
            string = string + "\n>";
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    string = string + Xtpipes.serialize(nodeList.item(i));
                }
            }
            string = string + "</" + string2 + ">";
            return string;
        }
        if (node.getNodeType() == 9) {
            String string = "";
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    string = string + Xtpipes.serialize(nodeList.item(i));
                }
            }
            return string;
        }
        if (node == null) {
            return "null";
        }
        return "";
    }

    static void cleanXmlns(Node node) {
        if (node.getNodeType() == 1) {
            int n;
            int n2 = nsName.size();
            ArrayList<Attr> arrayList = new ArrayList<Attr>();
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string = attr.getName();
                if (!string.startsWith("xmlns") || string.length() != 5 && string.charAt(5) != ':') continue;
                String string2 = attr.getValue();
                boolean bl = false;
                int n3 = nsName.size();
                while (n3 > 0) {
                    if (!nsName.get(--n3).equals(string)) continue;
                    bl = nsValue.get(n3).equals(string2);
                    break;
                }
                if (bl) {
                    arrayList.add(attr);
                    continue;
                }
                nsName.add(string);
                nsValue.add(string2);
            }
            n = arrayList.size();
            while (n > 0) {
                ((Element)node).removeAttributeNode((Attr)arrayList.get(--n));
            }
            arrayList = null;
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Xtpipes.cleanXmlns(nodeList.item(i));
                }
            }
            int n4 = nsName.size();
            while (n4 > n2) {
                nsName.remove(--n4);
                nsValue.remove(n4);
            }
        } else if (node.getNodeType() == 9) {
            nsName = new ArrayList();
            nsValue = new ArrayList();
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Xtpipes.cleanXmlns(nodeList.item(i));
                }
            }
            nsName = null;
            nsValue = null;
        }
    }

    static {
        logWriter = new PrintWriter(System.err);
        returnToFile = false;
        ml2xml = null;
        ml2xmlClassObj = null;
    }
}

