<!-- -->

    Source:  etoc.dtx (v1.08i-2016/09/29)
    Author:  Jean-Francois Burnol
    Author:  Christine Roemer et al. (German tranlation)
    Info:    Completely customisable TOCs
    License: LPPL 1.3c
    Copyright (C) 2012-2016 Jean-Francois Burnol.
    Copyright (C) 2014-2016 Christine Roemer and collaborators for
    the translation into German of the documentation.
    <jfbu at free dot fr>    <Christine_Roemer at t-online dot de>

ABSTRACT
========

The etoc package gives to the user complete control on how the entries
of the table of contents should be constituted from the *name*,
*number*, and *page number* of each sectioning unit. This goes via the
definition of *line styles* for each sectioning level used in the
document. The package provides its own custom line styles. Simpler
ones are given as examples in the documentation. The simplest usage
will be to take advantage of the layout facilities of packages dealing
with list environments.

Regarding the *global toc display*, etoc provides pre-defined styles
based on a multi-column format, with, optionally, a ruled title or
framed contents.

The `\tableofcontents` command may be used arbitrarily many times and
it has a variant `\localtableofcontents` which prints tables of
contents 'local' to the current surrounding document unit. An
extension of the `\label/\ref` syntax allows to reproduce (with
another layout) a local table of contents defined somewhere else in
the document.

Via *depth tags*, one gets an even finer control for each table of
contents of which sectioning units it should, or not, display.

The formatting inherited (and possibly customized by other packages)
from the document class will be used when in compatibility mode.

The assignment of levels to the sectioning units can be changed at any
time, and etoc can thus be used in a quite general manner to create
custom ''lists of'', additionally to the tables of contents related to
the document sectioning units. No auxiliary file is used additionally
to the standard `.toc` file.

INSTALLATION
============

The simplest is to download

>  <http://mirrors.ctan.org/install/macros/latex/contrib/etoc.tds.zip>

and then run `unzip etoc.tds.zip -d <DEST>` where `<DEST>` is a
TDS-compliant repertory.

Else, to extract the package (.sty) and driver (.tex) files from etoc.dtx:

- if etoc.ins is present:   etex etoc.ins
- without etoc.ins:         etex etoc.dtx

It is also possible to run latex or pdflatex directly on etoc.dtx.

To produce etoc.pdf one can run pdflatex (thrice) directly on etoc.dtx or on
the file etoc.tex which was extracted from previous step.

Options can be set in etoc.tex:

- scrdoc class options (paper size, font size, ...)
- with or without source code,
- with dvipdfmx or with latex+dvips or pdflatex.

Since release 1.08h pdflatex is the default in etoc.tex (prior it
was latex+dvipdfmx as it produces smaller PDFs) in order to allow
inclusion via the use of package `attachfile` of about 25 code
samples as file attachment annotations.

Installation:

    etoc.sty    -> TDS:tex/latex/etoc/etoc.sty
    etoc.dtx    -> TDS:source/latex/etoc/etoc.dtx
    etoc.pdf    -> TDS:doc/latex/etoc/etoc.pdf
    etoc-DE.pdf -> TDS:doc/latex/etoc/etoc-DE.pdf
    README.md   -> TDS:doc/latex/etoc/README.md

The other files may be discarded.

LICENSE
=======

This Work may be distributed and/or modified under the
conditions of the LaTeX Project Public License, in its
version 1.3c. This version of this license is in

> <http://www.latex-project.org/lppl/lppl-1-3c.txt>

and the latest version of this license is in

> <http://www.latex-project.org/lppl.txt>

and version 1.3 or later is part of all distributions of
LaTeX version 2005/12/01 or later.

The Authors of this Work are:

- Jean-Francois Burnol `<jfbu at free dot fr>` for the source code
  and English documentation, and
- Christine Roemer `<Christine_Roemer at t-online dot de>` and
  collaborators for the translation into German of the documentation.

This Work consists of the main source file etoc.dtx and the
derived files etoc.sty, etoc.ins, etoc.tex, etoc-DE.tex,
etoc.pdf, etoc-DE.pdf, etoc.dvi, etoc-DE.dvi.

RECENT CHANGES
==============

v1.08i \[2016/09/29\]
---------------------

This fixes an issue dating back to `1.08e-2015/04/17`: under
`\etocchecksemptiness` regime, some circumstances (such as adding to
an already compiled document a `\localtableofcontents` before the
main `\tableofcontents`) created an "`Undefined control sequence`
`\Etoc@localtop`" error. Thanks to Denis Bitouzé for reporting the
problem.

On this occasion, `\etocdoesnotcheckemptiness` has been
added to unset the flag.

A rather more exotic issue was fixed: the emptiness check for
local tocs could get confused if the `tocdepth` counter was varying
in some specific ways from inside the `toc` file.

After adding to a document a `\localtableofcontents`, two LaTeX
passes are needed for etoc to get a chance to print the
correct local contents. Formerly, etoc issued a Warning on
the first pass; it now also induces LaTeX into
announcing "There were undefined references", as this is nearer
to the end of the log file and console output.

v1.08h \[2016/09/25\]
---------------------

New functioning of `\etocsetnexttocdepth`: the tocdepth counter is
modified only at the time of the table of contents, not before. This
fixes an issue which arose when `\etocsetnexttocdepth` was used
multiple times with no intervening table of contents. Thanks to
Denis Bitouzé for reporting the problem.

The PDF documentation includes about 25 LaTeX code snippets also
as file attachment annotations, additionally to their verbatim
typesetting. The ordering of the documentation contents has been
slightly re-organized.

A previous documentation-only update on 2016/09/09 added a new
section with the (approximate) translation into etoc lingua of the
book class toc style, for easy customizability.

v1.08g \[2015/08/29\]
---------------------

Downgraded to a mere info message the etoc-issued warning
(relative to `\settocdepth/\maxtocdepth`) under class `memoir`.

v1.08f \[2015/04/28\]
---------------------

Minor changes to the documentation. `\etocsetlevel` more economical.

v1.08e \[2015/04/17\]
---------------------

The command `\etocchecksemptiness` tells etoc to not print, from
that point on, the headings of the local tables of contents if
they have empty contents. This is mainly for class authors who
might want to have their `\section` or `\chapter` automatically do
a `\localtableofcontents`. Could prove also useful for batch
conversions of documents. Thanks to Paul Gaborit who asked for
such a feature.

The command `\etocnotocifnotoc` extends this behaviour to global
TOCs: indeed why should documents with no sectioning units take
this as an excuse not to use package etoc ?

The command `\etocifwasempty{yes}{no}` can be used for
suitable extra action.

A `\tableofcontents\ref{foo}` now expects foo to be a label to a
_local_ TOC. The use with foo a label to a _global_ TOC is not
supported anymore as it had no utility and made the code more
complex.

The syntax `\localtableofcontents\ref{foo}` is now accepted as a
synonym to the earlier syntax `\tableofcontents\ref{foo}`.

v1.08d \[2015/04/09\]
---------------------

Translation into German of the additions made to the documentation
for the 1.08x series of releases.

Thanks to Christine Römer!

